comment +
   .-. .-.,----. .-.     /)    ,--,  ,---.  ,----.    /\
   | | | || ._--' ) \_ /'/'  .' .')  | .-.\ | .---' /'/\'\ |\    /|
   | `-' || `--. (_)\  /'   |  | (_) | `-'/ | `--. | |__| || `\/' |
   | .-. || .--'    / '\   _ \  \    |   (  | .--' |  __  || |\/| |
   | | | ||  `--. /'/ ) '\(_) '\ `\. | |\ \ | `---.| |  | || |  | |
  / (  |_)) ( ---'-'  (___)     '\__ |_|  \ \ ----'|_|  (_)) |  | |
 (__)    (___)                             (__)           (__)  '-'

 256 byte intro "Hex Cream"                   For compilation  use:
 Code:    bitl/7dump (2022)                   Turbo  Assembler 2.02
 mailto: aleks_gs@yahoo.com                   tasm /m2 hexcream.asm
                                              tlink /t hexcream.obj
 GrEeTiNgS  & ReSpEct:
 HellMood, sensenstahl, TomCatAbaddon, iONic, wbc\\bz7, p01, pestis
 Asato, rrrola, Optimus,  superogue,  Kuemmel, Digimind, Manwe, LBi

comment end! +

COUNT_BALLS=14

.model tiny

.code
.486
org 0100h

start:
     mov al, 13h     ; set VGA 320x200x8bpp
     int 10h

     les bp, [bx]    ; nearly VGA-segment (ES=9fffh)

     add dh, al      ; = CS+1300h (assume dx=cs)
     mov ds, dx      ; segment for frame-buffer

     add dh, al      ; = CS+2600h
     mov fs, dx      ; segment for texture

     mov gs, bx      ; 0 seg, for timer

     pop si          ; SI=0

;**************************************************************************
; SET PALETTE (FOUR GRADIENTS WITH UNCHAINED ORDER c/4*4+n )
;**************************************************************************
;     mov dl, 3
      xchg ax, dx
@pal:
     mov al, bh
     shr al, 2
     mov cl, dl
     mov ch, al
     shr ch, cl   ; green
     mov dh, al
     xor cl, 2
     shr dh, cl   ; red
     mov cl, al   ; blue
     mov bl, bh
     add bl, dl   ; index
     mov ax, 1010h
     int 10h
     sub bh, 4
     jnz @pal
dec dx
jns @pal



@restart:

     mov sp, es              ; reset stack pointer to 0x9fff




;**************************************************************************
; MAKE RADIAL-GRADIENT TEXTURE (128x128) [pass through 64kb due code size]
;**************************************************************************
     ;xor si, si
@l1:                 ;                       _,,ddP"""Ybb,,_
     mov ax, si      ;                     ,dP"'         `"Yb,
     shr ax, 7       ; =Y                ,d"                 "b,
     sub al, 64      ; DY:=Y-R;         d"                     "b
     imul al         ; A:=DY*DY;       d'        ,gPPRg,        `b
     xchg bx, ax     ; = A             8        dP'   `Yb        8
                     ;                 8        8)     (8        8
     mov ax, si      ;                 8        Yb     dP        8
     and al, 127     ; =X              Y,        "8ggg8"        ,P
     sub al, 64      ; DX:=X-R;         Ya                     aP
     imul al         ; B:=DX*DX;         "Ya                 aP"
     add bx, ax      ; M:=B+A;             "Yb,_         _,dP"
                     ;                       `""YbbgggddP""'
     test bh, 240    ; if M < 64*64 then begin
     jz @skip
        mov bh, 255
     @skip:
        shr bx, 4
        not bl
        ;--------------- add noise -------
        in ax, 40h
        xadd di, ax
        and al, 15
        sub al, bl
        sbb bl, bl
        xor al, bl
        ;----------------------------------
        and al, 252 ; unchained order n/4*4 (for multigradients fade)
        mov fs:[si], al
        mov ds:[si], bp     ; fill buffer
        inc si
jnz @l1


;**************************************************************************
; GENERATION LIST WITH RANDOM START POSITION AND VELOCITY (PUT TO STACK)
;**************************************************************************
     mov cx, COUNT_BALLS               ; count balls
@rand:
     mov dx, es               ; set max limit (for start offset)
     xor si, si
  @r2:
     @r_loop:
          in al, 40h          ; make pseudo-random value
          xadd di, ax
          stosb               ; draw glitch on screen, while pause
          cmp ax, dx
     ja @r_loop               ; repeat until value greater than DX

     mov dx, 4                ; - set max limit for velocity value
     sub ax, si               ; - more motion variety!
     push ax                  ; - put OFFSET/XV/YV to stack
     inc si
  jpo @r2                     ; loop three times
loop @rand


;**************************************************************************
; MAIN LOOP
;**************************************************************************
        push cx              ; init "oldtime" var

@mainloop:

        pop bx               ; get oldtime
        mov ax, gs:[46Ch]    ; get timer
        push ax              ; oldtime:=time;

          cmp al, 100        ; restart scene with new randomized parameters
          je @restart

        sub ax, bx           ; pasttime:=(time-oldtime);
        jz @mainloop         ; if pasttime = 0 then skip render


        mov bp, sp

        mov dl,  COUNT_BALLS          ; count of balls

   @balls:

        mov ax, [bp+2]        ; = YV (y-velocity)
        mov di, [bp+6]        ; = M  (current screen-offset)
        imul ax, 320          ; M = M + (YV * 320) + XV
        add ax, [bp+4]        ;
        add [bp+6], ax        ;
        add bp, 6             ;


;**************************************************************************
; MAIN DRAW ROUTINE
;**************************************************************************

        mov cl, 128
        ;xor si, si

        @draw:
           ;---------------------------------------------------------
             mov bx, di          ; For sinus-distort we use
             shr bx, 6           ; data from radial-gradient texture
             xor bh, bh          ;
             mov al, fs:[si+bx]  ;             .     .__,O
             shr al, 6           ;        .      *     / /`-'
             dec bl        ;cmp bl,127                 \^\
             jns @notneg   ;jna @notneg   .,_,  _____ /_ /____  _.-'``'
             not al              ;            ``~~~~~~~~~~~~~~~`_ =
             @notneg:            ;,.-'``'-.,_,.-'``'-.,_,.='``'-.,_,.-''
             add al, 4           ;
             xchg ax, bx ; - save one byte, but gives unexpected shift X & Y,
                         ;   because put AH-value to BH
                         ;   (it not ruining effect for this intro)
           ;---------------------------------------------------------

             mov ah, dl          ; set num of color-gradient for ball
             and ah, 3


             @drawline:
                  db 64h
                  lodsb
                  cmp al, ds:[di+bx]
                  jbe @drawskip
                      add al, ah
                      mov ds:[di+bx], al
                  @drawskip:
                  inc di
                  test si, 127
             jnz @drawline
             add di, 192

        loop @draw
        xor si, si

        dec dx
   jnz @balls

;**************************************************************************
; MOVE FRAME-BUFFER TO SCREEN (WITH FADE DATA IN BUFFER)
;**************************************************************************
     ;xor di, di
     ;xor si, si

     @l:
         mov al, ds:[si]
         stosb       ; - put to screen
         sub al, 4   ; - fade pixel in buffer
         sbb dl, dl  ; - if result < 0 then dl=255
         xor al, dl  ; - not too correct, but ok (right: "not dl","and al, dl")
         mov ds:[si], al
         inc si
     jnz @l

     in al, 60h               ; wait for any key
     das
jp @mainloop                 ; none received, start over


;**************************************************************************
; EXIT
;**************************************************************************
;     mov ax, 3                ; back to text
;     int 10h                  ; mode
     int 20h                  ; exit

end start

