

cpu 386
org	0100h

COUNT equ 10

STEP equ 32

EDGE equ 7

TEXT equ 8

BODYHEIGHT equ 33
SHAFTHEIGHT equ 5
TIPHEIGHT equ 5

ENDLINE equ 128

LEFTSIDE equ ( EDGE )
RIGHTSIDE equ (STEP - EDGE)

BODYY equ BODYHEIGHT
SHAFTY equ (BODYY+SHAFTHEIGHT)
TIPY equ (SHAFTY+TIPHEIGHT)

BACKTOP equ ( ENDLINE + BODYHEIGHT )
;BACKLINE equ (BACKTOP + 1)

DELAY equ (ENDLINE + BODYHEIGHT/2) ; + BODYHEIGHT * 2)

SWIPEDELAY equ ( DELAY * 3 + 10 )

COLORSTART equ 0x27; 0x27

;Setup video mode.
mov	al, 13h
int	10h

;screen mem
push 0xa000
pop es

;Setup font pointer 
push 0xf000 + 0xfa6
pop fs

mainLoop:

;Loop all them pixels
pixelloop:

mov ax, di
xor dx, dx

mov cx, 320
div cx

mov bx, -200
frameCount:

sar bx, 2
mov cx, BACKTOP
cmp bx, SWIPEDELAY
js skipDecrease
;Line starts moving up
sub cx, bx
add cx, SWIPEDELAY
;Disable syringe drawing
mov byte [killJump],0xeb

skipDecrease:

push ax

;Draw the background
cmp ax, cx
topLine:
jg backBottom
backTop:
salc
;mov al, 0

jmp backDraw
backBottom:

mov ax, dx
shr ax, 1

;Draw a little pattern
add al, bl
xor al, [-4]
aam

;When is this pixel supposed to be inserted
movzx si,al
movzx si, byte [si]
sub si, bx
add al, 0x10
cmp si, -DELAY
jg backDraw

add al, COLORSTART - 0x10
backDraw:
mov [es:di],al

pop ax

;Copy x 
mov cx, dx
and dl, 31

;Different speeds per column
mov si, cx
shr si, 5
movzx si, byte [si]

xor bp, bp
sub bx, si
cmp bx, ENDLINE
js keepGoing
;Fluid level
mov bp, bx
mov bx, ENDLINE
sub bp, bx
keepGoing:

sub ax, bx
;Beyond the screen
cmp ax, TIPY
killJump:
ja doBlack
;Different parts of the syringe
cmp al, BODYY
jnb drawTip

drawBody:
xchg dx, ax

;Basic outline

cmp al, LEFTSIDE
jb doBlack
je doWhite
cmp al, RIGHTSIDE
ja doBlack
je doWhite

;White line
cmp dl, BODYHEIGHT-1
je doWhite

;Try to get some text
mov bx, LOVEBYTE

;Alternate love/byte
push cx
test cl, 32
jnz add4
add bx, 4
add4:

mov si, dx
shr si, 3
;Character
movzx bx, byte [bx+si]
shl bx, 3

mov si, dx
and si, 7

;x of the text
sub al, TEXT
shr al, 1

xchg ax, cx
mov ch, 1
ror ch, cl
;Lookup font
test byte [fs:bx+si+0xe],ch
pop ax
jnz doWhite

;Interior 
cmp bp, dx
ja doBlack

;mov ax, [-4]
shr ax, 5
add al, COLORSTART

jmp doPixel

;This is the tip
drawTip:
neg al
add al, TIPY
shr al, 3

sub dl, 16
jns skipinvertdl
neg dl
skipinvertdl:
shr dl, 1
cmp al, dl

js doBlack

doWhite:
mov al, 15

doPixel:
mov [es:di],al

doBlack:
inc di
jnz pixelloop


waitLoop:
;Wait for redrace
mov dx, 0x3da
waitretrace:
in al, dx
test al, 8
jz waitretrace

inc word [frameCount-2]

jmp mainLoop

LOVEBYTE:
db 'BYTELOVE'


