;~~~~~~~~~~~~~~~~~ FPU: Flying Pancake Units ~~~~~~~~~~~~~~~~~;
;                                                             ;
;                           Made by                           ;
;                 Blossom from Marquee Design                 ;
;      for the 256 byte compo of Pancake Conference 2020      ;
;  rougly using the colors from the Pancake Beer Can palette  ;
;  Greetings to psenough, all sizecoders, pancake lovers and  ;
;       demotivation channel members. May your bytes be       ;
;                 few and your pancakes many.                 ;
;                           Enjoy!                            ;
;                                                             ;
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;

;%define freedos

org 100h

%ifdef freedos
push 0a000h-70
pop es
%else
les bp,[bx]
%endif

jmp initvideo

; Ingredients
w:
c dw 10*256

db 0c3h
db 89,93h,47

d dw 600
p dw 20
m dw 45
bah dw 128-32

initvideo:
mov al,13h
int 10h

push si
mov cl,31
mov dx,330h
rep outsb
pop si

mov bp,240

mainloop:
	%ifdef freedos
	sub dh,104
	%else
	sub dx,648Ch
	%endif
	
	; Start of FPU part and pancake loop
	xor bx,bx
	
	%ifdef freedos
	fninit
	%endif
	
	mov cx,bp
	mov cl,ch
	and cx,7
	inc cx
	pancakeloop: ; because one pancake is just not enough
		mov ax,cx
		shl ax,5
		neg ax
		add ax,bp
		xor ah,ah
		shl ax,2
		neg ax
		add ax,si
		
		pusha
		
		; Baking the pancakes
		fild word [bx-4] ; load l part of bp from ax
		fild word [bx-9] ; load x
f:		fidiv word [bx-16] ; divide by 256
		fisub word [byte si+(bah-100h)] ; minus
		fadd st0,st1
		fmul st0,st0
		fidiv word [byte si+(w-100h)] ; pancake width

		fld1
		fld st2
		fmul st0,st0
		fidiv word [byte si+(d-100h)] ; bounce amplitude decay
		fld st3
		fidiv word [byte si+(p-100h)] ; bounce period
		fcos
		fmulp
		fabs ; bounce
		fisub word [byte si+(m-100h)]

		fild word [bx-8] ; load y
		fidiv word [bx-16] ; divide by 256
		fst st4
		faddp
		fmul st0,st0
		fidiv word [bx-16] ; pancake height (happens to be 256... how convenient)
		fadd st0,st2
		
		; Check if we've got a pancake
		fcomp
		fstsw ax
		sahf 
		jb pancakefound  
		
		; Calculating the shadow
		fld st2
		fisub word [byte si+(m-100h)]
		fmul st0,st0
		fidiv word [bx-16] ; pancake height (happens to be 256... how convenient)
		fadd st0,st2
		
		; Check if we're in the shadow
		fcompp
		fstsw ax
		sahf 
		jb shadowfound  
		
		nextpancake: ; yes please
		popa
		dec cx
	jnz pancakeloop
	mov byte[si],0
	jmp noshadow
	shadowfound:
	popa
	inc byte[si]
	noshadow:
	
	; Calculate table cloth pattern
	pusha
	fild word [bx-8]
	fidiv word [byte si+(c-100h)]
	fabs
	fild word [bx-9]
	fdiv st1
	fistp word [bx-10]
	fidivr word [byte si+(f-100h)]
	fistp word [bx-11]
	popa
	
	; Kitchel tiles pattern
	sub dx,bp ; move it
	mov al,dh
	mov cl,dh
	add al,dl
	sub cl,dl
	xor al,cl
	and al,32
	shr al,5
	add al,7ch
	
	cmp dh,24
	js storepixel
	
	; Table cloth pattern
	mov cx,bp ; move it
	sub bh,cl
	
	mov al,bl
	xor al,bh
	and al,8
	
	cmp byte[si],0
	jnz calcshadow
	
	; Shadow part
	shl al,2
	add al,1Fh+12

	calcshadow:
	sub al,12
	jmp storepixel

	; Looks like we've found ourselves a pancake!
	pancakefound:
	popa
	mov al,006h ; realistic pancake color

	storepixel:
	stosb
	mov ax,0cccdh ; Extra pancakes for Řrřola!
	mul di
	;inc di
	;inc di
jnz mainloop

inc bp

%ifdef freedos ; ESC stuff
in al,60h
dec al
jnz mainloop
%else
jmp mainloop
%endif

