comment +
 888888888888
        ,88'     8I          256 byte intro "Odula"
      ,88"       8I          Code:    bitl/7dump (2023)
     ,88'        8I          mailto: aleks_gs@yahoo.com
  aaa888aa       8I
   ,8P     ,gggg,8I  gg      gg   ,ggg,,ggg,,ggg,   gg,gggg,
  ,88     dP"  "Y8I  I8      8I  ,8" "8P" "8P" "8,  I8P"  "Yb
  88'    i8'    ,8I  I8,    ,8I  I8   8I   8I   8I  I8'    ,8i
  88    ,d8,   ,d8b,,d8b,  ,d8b,,dP   8I   8I   Yb,,I8 _  ,d8'
  88    P"Y8888P"`Y88P'"Y88P"`Y88P'   8I   8I   `Y8PI8 YY88888P
                                                    I8
   GrEeTiNgS  & ReSpEct:                            I8
   baze, sensenstahl, TomCat/Abaddon, iONic, y0bi   I8
   wbcbz7,  p01,  pestis, Asato, rrrola,  Optimus   I8
   superogue, Kuemmel, HellMood, Manwe, LBi, JinX   I8
                                                    I8
   For compilation  use   Turbo  Assembler 2.02     I8
   tasm /m2 odula.asm  tlink /t odula.obj           I8

comment end! +

SCALE_FACTOR=115
DOTS_COUNT=10
TEXT_X=90
TEXT_Y=75


.model tiny
.data
message db "DEMO",2,"DULATiON$"

.code
.486
org 0100h

start:

mov al, 13h
int 10h

add dh, al              ; cs + 1300h
mov fs, dx              ; segment for buffer
mov es, dx

;**********************************************************************
; VIDEO MODE, PALETTE AND TEXT INIT
;**********************************************************************
pusha

@pal:                   ; setup palette
  imul dx, bx, 191
  mov ch, dh
  add ch, 10
  mov ax, 1010h
  int 10h
  inc bl
jnz @pal

mov dx, offset message  ; print text to seg 0A000h
mov ah, 09
int 21h

push 0a000h
pop ds
xor di, di
xor si, si
;mov ch, 10 ;320*8
rep movsb               ; copy text to buffer
popa


add dh, al              ; also segs for buffers
mov es, dx
add dh, al
mov ds, dx

;**********************************************************************
; MAIN LOOP
;**********************************************************************
@mainloop:
inc si                  ; movement
push si
test si, 1
jnz @skip_render        ; animation FPS/2


;**********************************************************************
; RANDOM DOTS ON SCREEN CENTER
;**********************************************************************
mov cl, DOTS_COUNT
@random_dots:
       in ax, 40h
       xadd ds:[di], ax
       and ax, 31
       mov bx, dx
       mov dx, ax
       imul ax, ax, 320
       add bx, ax
       mov ds:[bx+144+82*320], al
loop @random_dots

;**********************************************************************
; PRINT CHAR
;**********************************************************************
test si, 15
jnz @skip_char_draw

shr si, 4
and si, 15
shl si, 3
mov di, si
mov cl, 8
@loop_char_draw:
  mov dl, 8
  @readline:
      db 64h
      lodsb
      test al, al
      jz @skip
         mov ax, 3f3fh
         mov ds:[bx+di+(TEXT_X+320*TEXT_Y)], ax
         mov ds:[bx+di+320+(TEXT_X+320*TEXT_Y)], ax
      @skip:
      inc di
      inc di
      dec dx
  jnz @readline
  add si, 320-8
  add di, 320-16+320
loop @loop_char_draw
@skip_char_draw:

;**********************************************************************
; SCALE AND BLUR
;**********************************************************************
xor di, di
mov bp, SCALE_FACTOR*100;
mov ah, 200
@y:
  mov dx, 160*128-SCALE_FACTOR*160
  mov si, 100*128
  sub si, bp
  shr si, 7
  mov cx, 320
  imul si, cx
      @x:
           mov bx, dx
           shr bx, 7
           mov al, ds:[si+bx-1]
           add al, ds:[si+bx+1]
           add al, ds:[si+bx-320]
           add al, ds:[si+bx+320]
           shr al, 2
           stosb
           add dx, SCALE_FACTOR
      loop @x
sub bp, SCALE_FACTOR
dec ah
jnz @y

push es                 ; swap addresses of buffers
push ds
pop es
pop ds

@skip_render:

     mov  dx, 3DAh      ; Wait for vertical retrace
@w1:
;     in   al, dx
;     test al, 8
;     jnz  @w1
@w2:
     in   al, dx
     test al, 8
     jz   @w2


     push es            ; move buffer to screen
     push 0a000h
     pop es
     xor si, si
     xor di, di
     mov ch, 125 ;64000/2
     rep movsw
     pop es

in al, 60h              ; wait for ESC
dec ax
pop si
jnz @mainloop

;**********************************************************************
; EXIT
;**********************************************************************
mov al, 3               ; back to text
int 10h                 ; mode
ret
end start

