; Turbulences - 128b intro by MX^Addict 2025 (mxadd@mxadd.org)
BITS 16
org 100h

;
; Config
;
%define ALTERPAL    1

;
; Defines
;
%define off_ax     -2
%define off_cx     -4
%define off_dx     -6
%define off_bx     -8
%define off_sp    -10
%define off_bp    -12
%define off_si    -14
%define off_di    -16

%define var_VAScl   2
%define var_UVDiv   0

;
; Entry point
;
start:

	; ax=0 bx=0 cx=255 si=100h (if assumed)

	; Init gfx

	push 	0xa000
	pop  	es
	mov 	al, 0x13				; ax = 19
	int 	0x10

	; Palette

%if ALTERPAL
.palette:							; 127 shades of gold
	mov		dx, 0x3c8
	mov		ax, cx
	out		dx, al					; out index and dx = 0x3c9
	inc		dx

	sar		al, 1					; shades of gold
	out		dx, al
	mul		al
	shr		ax, 6
	out		dx, al
	xor		ax, ax
	out		dx, al

	loop	.palette				; ax = 0x??00, bx = 0, cx = 0, dx = 0x03C9 at end
 %else
	salc							; ax = 0
.palette:							; 42 shades of gray
	mov 	dx, 0x3c9
	xchg	ax, cx
	out 	dx, al
	loop	.palette				; ax = 0xFF01, bx = 0, cx = 0, dx = 0x03C9 at end
%endif	
	; Init vars

%if ALTERPAL
	push	word 127				; var_VAScl
%else
	push	word 41					; var_VAScl
%endif
	push	word 64					; var_UVDiv
	mov		si, sp					; Stack to si
	
	; Main loop

	fldz							; Load time
	
.top:

	xor 	di, di 					; frame buffer offset
	mov		cl, 200					; y loop counter (cx == 0, so cl only)

	fldlg2
	fmul	st0, st0				; ~ 0.09
	faddp	st1, st0				; Increment time
	
.yloop:	

	mov		bx, 320					; x loop counter
	
.xloop:
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	; si == stack frame
	; di == pixel position [0 - 320*200]
	; bx == X [0 ... 320]
	; cx == Y [0 ... 200]

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
	; uv_x = (float(X) / UVDiv)
	; uv_y = (float(Y) / UVDiv)

	pusha							; sp -= 16, [AX, CX, DX, BX, SP, BP, SI, DI]

	fild 	word [si+off_cx]		; load Y
	fidiv   word [si+var_UVDiv]
	
	fild 	word [si+off_bx]		; load X
	fidiv   word [si+var_UVDiv]
	
	; st0 = uv_x
	; st1 = uv_y
	; st2 = Time
	
	; Outer loop

	mov		cl, 12 ; 16				; Inner iterations count
	xor		ax, ax					; Counter (must count forward)

.fxouter:

	inc		ax
	pusha							; sp -= 16, [AX, CX, DX, BX, SP, BP, SI, DI]

	; st0 = uv_x
	; st1 = uv_y
	; st2 = Time

	; uv_x += (Factor / i) * cos(i * PIF * uv_y + Time);
    ; uv_y += (Factor / i) * cos(i * L2E * uv_x + Time);

	fild	word [si+off_ax-16]		; i

	fldpi
	fmul	st0, st3				; *= uv_y
	fmul    st0, st1				; *= i
	fadd	st0, st4				; += Time
	fcos

	fldl2e
	fmul	st0, st3				; *= uv_x
	fmul    st0, st2				; *= i
	fadd    st0, st5				; += Time
	fcos

	fldlg2							; Factor = 0.3 - Small turbulences
	fdivrp	st3, st0				; (Factor / i)

	fmul	st0, st2
	faddp	st4, st0				; uv_y += (Factor / i) * cos(i * L2E * uv_x + Time);

	fmulp	st1, st0
	faddp	st1, st0				; uv_x += (Factor / i) * cos(i * PIF * uv_y + Time);

	; st0 = uv_x next
	; st1 = uv_y next
	; st2 = Time
			 
	; Inner loop maintance
	popa
	loop	.fxouter
		
	; Fetch result
	; r = abs(sin((uv_y - uv_x) - Time)) * VAScl;

	fsubrp							; st0 = uv_y - uv_x
	fsub	st0, st1				; st0-= Time
	fsin
	fabs
	fimul	word [si+var_VAScl]
	fistp 	word [si+off_ax]
	popa
	stosb
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	; Loop maintance

	dec		bx						; next X
	jnz		.xloop
	loop	.yloop					; next Y
	jmp		.top

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; EOP
