#define IMPORT(MODULE, NAME) __attribute__((import_module(MODULE), import_name(NAME)))

IMPORT("env", "atan2") extern float atan2(float, float);
IMPORT("env", "time") extern float time();
IMPORT("env", "setPixel") extern void setPixel(int, int, int);

float min(float a, float b) {
    return __builtin_wasm_min_f32(a, b);
}

float max(float a, float b) {
    return __builtin_wasm_max_f32(a, b);
}

int effect0(int x, int y, int t) {
    return x;
}

int effect1(int x, int y, int t) {
    return (x + t) >> 4;
}

int effect2(int x, int y, int t) {
    return (x*x + y*y - t) >> 7;
}

int effect3(int x, int y, int t) {
    return (x & (y + t)) == 2;
}

int effect4(int x, int y, int t) {
    return (((int)(atan2((float)x, (float)y) * 41) + t) >> 5) ^ ((x + t / 4) >> 5) ^ ((y + t / 4) >> 5);
}

int effect5(int x, int y, int t) {
    return (x + ((y - t) & 9 )) >> 4;
}

static int (*effects[])(int, int, int) = { effect0, effect1, effect2, effect3, effect4, effect5 };

void upd() {
    for(int y = 0; y < 240; ++y) {
        for(int x = 0; x < 320; ++x) {
            int t = (int)(time() * 60.0);
            int sx = x + t;
            int dx = sx + y;
            int dy = sx - y;
            int s1 = (dx & 63) > 16;
            int s2 = (dy & 63) > 16;
            int weave = ((dx ^ dy) >> 6) & 1;
            int side = s1 + s2 * 2;
            side ^= (side == 3) * (1 << weave);
            int ex, ey;
            if(side == 1) {
                ex = dx;
                ey = dy;
            } else {
                ex = dy;
                ey = dx;
            }
            int effectIndex = ex >> 6;
            int effect = effects[((effectIndex * effectIndex) >> 7) % 6]((ex & 31) - 16, (ey & 31) - 16, t);
            setPixel(x, y, side * 16 - 16 + side * (6 + (effect & 1)));
        }
    }
}