; Bee-Bee THE OUTLINE FRACTAL by TomCat/Abaddon
; 256-byte intro for Outline 2024 party
; ispired by ASMINITY by matja

RESX EQU 320
RESY EQU 200
SCREEN EQU 08100H

SOUND=0
TIMER=0;8
LAYER=1

DIGITS = (HDIGIT-VDIGIT) + (ODIGIT-HDIGIT)/2 + (DECOMP-ODIGIT)/8
BASE = (ODIGIT+DIGITS*8)

ORG 256

start:
; FNINIT
; MOV AL,13H
; INT 10H

if SOUND=1
 MOV AL,0B6H
 OUT 43H,AL
end if

if TIMER>0
 MOV AL,TIMER
 OUT 40H,AL
 OUT 40H,AL
end if

 MOV SI,VDIGIT
 MOV DI,DECOMP
 MOV CL,(HDIGIT-VDIGIT)
.1:
  MOV AL,-30
  STOSW
  MOV AL,61
  STOSW
  MOVSB
  STOSW
  STOSB
 LOOP .1
 MOV CL,(ODIGIT-HDIGIT)/2
.2:
  MOV AX,36*256
  STOSW
  MOV AH,30
  STOSW
  MOVSB
  STOSB
  MOVSB
  STOSB
 LOOP .2

 PUSH DI
 XCHG CX,AX;MOV CL,DIGITS*8
.3:
  LODSB
  CBW
  MOV [DI],AX
  FILD WORD [DI]
  FIDIV WORD [const256]
  FSTP DWORD [DI]
  SUB DI,SP
 LOOP .3
 POP BP

 PUSH 8100H
 POP DS
 PUSH 0A000H;-20*4
 POP ES
 MOV DI,SCALE-BASE

 FLDZ
 FLDZ

draw_frame:
  IMUL AX,DX,13    ; generate pseudo-random number, DX = seed
  XCHG AH,AL
  MOV DX,AX	   ; ax = pseudo-random number
  AAM DIGITS
  CBW
  IMUL SI,AX,32
.1:
  FLD ST0			; y y x
  FMUL DWORD [SI+BP]		; y*[si] y x
  FLD ST2			; x y*[si] y x
  FMUL DWORD [SI+BP+4]		; x*[si+4] y*[si] y x
  FADDP 			; x*[si+4]+y*[si] y x
  FADD DWORD [SI+BP+16] 	; x*[si+4]+y*[si]+[si+16] y x
  FXCH ST2			; x y newx
  XOR BP,8			; y*[si+12]+x*[si+8]+[si+24] x y newx
  JPO .1			; y x newy newx

  FIMUL WORD [DI+BP]		; scale*y x newy newx
  FISTP WORD [DI]		; x newy newx
  IMUL SI,[DI],-320
  FIMUL WORD [DI+BP]		; scale*x newy newx
  FISTP WORD [DI]		; newy newx
  ADD SI,[DI]

  MOV  BYTE [SI+120*320+160],7EH
main:
 LOOP draw_frame

if SOUND=1
 MOV AX,[DI+BP]
 SHR AX,4
 AND AL,10011B
 CMP AL,00010B
 STC
 JZ .0
 SHR AL,1
.0:
 SALC
 OUT 61H,AL
 IMUL AX,[DI+BP],4
 JNS .1
 NEG AX
.1:
 OUT 42H,AL
 MOV AL,AH
 OUT 42H,AL
end if

if TIMER>0
 HLT
end if

 CALL SaveFrame
 NOP

 MOV SI,DI
cls:
  MOV AX,DS
  SUB AL,CH
  SHR AX,4
  MOVSB
  MOV [SI-1],AL
 LOOP cls

 IMUL AX,[DI+BP],4
 SAR AX,2
 DEC AX
 MOV WORD [DI+BP],AX

if LAYER=1
 TEST AL,7
 JNZ .4
 SUB BX,321
.4:

 PUSH BX
 MOV CL,16*15
.1:
 BT [BP+DI-SCALE+LOGO],CX
 JNC .2
 MOV BYTE [BX],42
.2:
 INC BX
 TEST CL,15
 JNZ .3
 ADD BX,320-16
.3:
 LOOP .1
 POP BX
end if

 IN AL,60H
 DAS
 JC main

if SOUND=1
 SALC
 OUT 61H,AL
end if

if TIMER>0
 SALC
 OUT 40H,AL
 OUT 40H,AL
end if

 FCOMPP
RETN

if LAYER=1
LOGO:
 DW 0011010001010100B;15
 DW 0100101001010110B;14
 DW 0100010011011000B;13
 DW 0100001011011110B;12
 DW 0110000101100000B;11
 DW 0011001111111100B;10
 DW 0001110101011000B;09
 DW 0000011011100000B;08
 DW 0001101101010100B;07
 DW 0001100110001010B;06
 DW 1100011010000100B;05
 DW 0000011011000010B;04
 DW 0000000001100010B;03
 DW 0000100000111100B;02
 DW 0000100000000000B;01
end if

VDIGIT:;Vertical digits
 DB 22
 DB 34
 DB 17
 DB 39
 DB -51
 DB -39
SCALE: DB 0;,3
 DB -34
 DB -22
 DB -11
HDIGIT:;Horizontal digits
 DB -45,-11
 DB -28,-11
 DB 6,-11
 DB 45,-11
 DB 45,0
 DB -11,11
 DB -45,11
 DB 45,11
ODIGIT:;Other digits
 DB 30,30,-30,30,28,0
const256:
 DB 0,1
DECOMP:

DB 50000 DUP (0)

;//////////////////////////////////////////////////////////////////////////////
FileName DB 'BEE00000.BMP',0
FileName2 DB 'PAL200.BMP',0

ALIGN 128

SaveFrame:
 PUSHA
 PUSH DS

 PUSH CS
 POP DS
 MOV SI,FileName
 MOV CX,12
 MOV AH,2
.0:
 LODSB
 MOV DL,AL
 INT 21H
 LOOP .0
 MOV DL,13
 INT 21H
 MOV DL,10
 INT 21H

 MOV DX,FileName
 MOV AH,3CH
 INT 21H
 PUSH AX

 MOV SI,FileName+7
.8:
 INC BYTE [SI]
 CMP BYTE [SI],'9'
 JNA .9
 MOV BYTE [SI],'0'
 DEC SI
 JMP .8
.9:

 MOV DX,FileName2
 MOV AX,3D00H
 INT 21H
 XCHG BX,AX
 PUSH SCREEN
 POP DS
 MOV DX,64000
 MOV CX,54+4*256
 MOV AH,3FH
 INT 21H
 MOV AH,3EH
 INT 21H
 POP BX
 MOV AH,40H
 INT 21H
 MOV CX,RESX
 MOV BP,RESY
.1:
 SUB DX,CX
 JC .2
 MOV AH,40H
 INT 21H
 JMP .1
.2:
 MOV AH,3EH
 INT 21H

 POP DS
 POPA
RETN
