comment %

Tested with DosBox and PC-EM BIM PS/1 model 2121 + MSDOS 3.3 (apparently works also on a PC-EM 286 machine, in theory it shouldn't)

Neeeds minimum a 386 with color text screen -CGA,EGA,VGA- because of this:
  CBW (since 386)
  PUSH inmediate (since 80186)
  Writing hardcoded on B800:0000 (color text buffer)

Pseudocode:
	for y=0 to 18
		for x=0 to 18
			if (((x+3) mod 6)= (y mod 6)) then locate x,y : print "*" : locate 18-x,y : print "*"
		next x
	next y

Assemble and link instructions (TASM 4):
  tasm /m2 /zi /la ntfa.asm
  tlink /t ntfa

%

ideal
p386

_X EQU CH
_Y EQU CL
_OFS1 EQU SI
_OFS2 EQU DI
_SIZE EQU 18


segment code para public 'code' use16
        assume cs:code,ds:code
        org 100h
        
beginning:
		push 0B800h
		pop ds
		
		mov _OFS1,(((80*2)*_SIZE+1)+((30+_SIZE)*2))-1
		mov _OFS2,(((80*2)*_SIZE+1)+((30+(18-_SIZE))*2))-1
		
		mov _Y,_SIZE+1
for_y:
		mov _X,_SIZE
for_x:
		mov al,_X
		cbw
		add al,3+1
		mov bl,6
		div bl
		xchg dx,ax				; DH = ((x+3+1) mod 6)
		mov al,_Y
		cbw
		div bl
		cmp dh,ah				; AH = (y mod 6)
		jne skipit
		mov [byte ptr si],'*'	; draw one direction
		mov [byte ptr di],'*'	; draw another direction
skipit:
		dec _OFS1
		dec _OFS1
		inc _OFS2
		inc _OFS2

		dec _X
		jnz for_x

		sub _OFS1,(80*2)-(_SIZE*2)
		sub _OFS2,(80*2)+(_SIZE*2)

		dec cx
		jnz for_y		

		ret

ends

end	beginning

