org 100h

; nasm

; ds: usually same as cs
; es: the double buffer

%include "lhdefs.inc"

%define panel_w bp
%define panel_h bp + 2
%define panel_d bp + 4
%define panel_sy bp + 6
%define panel_sx bp + 8
%define panel_xyinc bp + 10
%define panel_cols bp + 12
%define anim_state bp + 14

%define bg_colour 192

main:
	push cs
	pop ax
	add ax, 1000h
	mov es, ax

	mov ax, 13h
	int 10h

	; reserve some space for args to the panel func. IE we set bp once and then
	; re-use it repeatedly.
	mov bp, 400h

	xor di, di; frame counter

.mainloop:
	call scene

	inc di

	test di, 15
	jnz .copy_buffer
	inc word [anim_state]

	and word [anim_state], 0fh

	cmp word [anim_state], 10
	jne .copy_buffer

	; thanks to sizecoding.org for this routine
	mov al,	3Fh ; command modeset UART mode - command
	mov dx,	331h ; midi control
	out dx,	al
	dec dx ; data port
	;mov al, 0c0h    ; change instrument
	;out dx, al
	;mov al, 1
	;out dx, al
	mov si, secret_tune
	outsb
	mov cl, 8
.notes:
	mov al,[fs:0x46c]	; read timer value
	test al, 3
	jnz .notes
	inc byte [fs:0x46c]
	outsb
	mov al, 67h  ; volume
	out dx, al
	loop .notes

.copy_buffer:                    ; copy and clear the buffer.
	push ds
	xor si, si
	push word 0a000h             ; copy from es to ds
	pop ds
.copy_buffer_loop:
	mov ax, bg_colour
	xchg al, [es:si]
	mov [si], al
	inc si
	jnz .copy_buffer_loop
	pop ds

.idle_loop:
	in al, 60h
	cmp al, 1h
	jne .mainloop

	ret

scene:
	mov si, lh_scene
	mov dx, 081ch      ; tree trunk offsets

.loop:
	xor ah, ah
	lodsb
	cmp al, DRAW_END
	je .endscene
	cmp al, DRAW_LOOP
	je .setup_loop
	cmp al, DRAW_PALETTE
	je .setup_palette
	cmp al, DRAW_SCALE
	je .setup_scale
	cmp al, DRAW_PREEND
	je .setup_preend

	; otherwise, it's a box.
	; 256 -> 320 by adding 320 / 4.
	mov bx, ax
	shr ax, 2
	add ax, bx
	add al, dh
	mov [panel_sx], ax               ; x
	; y-coordinate is directly encoded.
	lodsb
	add al, dl
	mov [panel_sy], al
	mov cx, [panel_d]
	call cuboid
	jmp .loop


.setup_loop:
	lodsb
	test dl, dl                     ; have we cleared the offsets?
	jz .custom_palette              ; yes, don't loop again
	sub si, ax                      ; move scene pointer
	add word [panel_cols], 3        ; shift to the next palette
	xor dx, dx                      ; clear x and y offsets
	jmp .loop

.custom_palette:
	mov al, [anim_state]
	cmp al, 10
	jg .loop
	cmp al, 5
	mov al, 2
	jl .noflashanim
	mov ax, di
	and ax, 2
.noflashanim:
	add al, 12
	jmp .mid_palette

.setup_palette:
	lodsb
.mid_palette:
	add ax, lh_palettes
	mov [panel_cols], ax
	jmp .loop

.setup_scale:
	lodsb
	mov [panel_w], ax
	lodsb
	mov [panel_h], ax
	lodsb
	mov [panel_d], ax
	jmp .loop
	
.setup_preend:
	cmp byte [anim_state], 10
	jg .loop
	ret

.endscene:
	ret

cuboid:
	; same stack as for 'panel' with the addition of:
	; bp + 8 : h
	; we also assume the palette pointer has two more bytes behind it.
	; cx: d

	; we store:
	; ax: w

	;pusha

	mov ax, [panel_w]

	; pt(x, y, w, d, coltop);
	mov word [panel_xyinc], 0101h ; increment both x and y
	call panel
	dec word [panel_sy]          ; correct moire pattern, only required when xinc != 0
	call panel

	; pl(x, y + h, w, h, colleft);
	push cx                      ; remember depth
	mov cx, [panel_h]            ; use h instead of d for left panel
	add [panel_sy], cx           ; use y + h for the starting y coordinate (also for the next call)
	mov byte [panel_xyinc + 1], 0 ; panel_xyinc = 0, 1
	inc byte [panel_cols]        ; next colour
	call panel
	pop cx                       ; cx = depth

	; pr(x + w, y + h + w / 2, d, h, colright);
	mov [panel_w], cx			 ; use depth as the width parameter
	mov cx, ax                   ; cx = width
	add [panel_sx], cx           ; sx = sx + w
	shr cx, 1                    ; cx = w / 2
	add [panel_sy], cx           ; panel_sy = y + h + w / 2
	sub byte [panel_xyinc], 2    ; xyinc = 0, -1
	mov cx, [panel_h]            ; h
	inc byte [panel_cols]        ; next colour
	call panel

	sub byte [panel_cols], 2     ; restore palette
	mov [panel_w], ax            ; restore width

	;popa

	ret

panel:
	; stack:
	; bp: w
	; bp + 2 : sy  (modified during call)
	; bp + 4 : sx  (modified during call)
	; bp + 6 : xinc, yinc
	; bp + 8 : h (unused, referenced here as it's used by the cuboid call)
	; bp + 10 : pointer to col
	; cx: d
	pusha

	mov bx, [panel_sy]              ; copy sy to bx as we'll modify it in the horizontal loop.
	mov si, [panel_sx]              ; copy sx to si as we also modify this one.

.depth_loop:
	; loop over d, which is already passed in CX.

	push bx                       ; modified during horizontal loop
	push cx
	xor cx, cx                    ; cx = horizontal index from 0 to w - 1

	; loop over w, adjusting y when necessary to fake isometric projection.
.horiz_loop:
	mov ax, si                     ; ax = sx
	add ax, cx                     ; ax = x + sx
	;cmp ax, 320
	;jge .horiz_loop_skip_pixel     ; don't draw pixel if value too large
	;test ax, ax
	;js .horiz_loop_skip_pixel      ; or too small
	cmp bx, 200                    ; you too
	jge .horiz_loop_skip_pixel

	; calculate pixel offset.
	push ax                        ; store the current x position
	pop di                         ; as an offset into the double buffer
	mov ax, bx                     ; ax = y
	mul word [word_320]            ; ax = y * 320

	add di, ax                     ; di = y * 320 + x

	; read the colour in an an unnecessarily complicated way.
	push di
	mov di, [panel_cols]
	mov dl, [di]
	mov dh, dl
	pop di
	mov [es:di], dx				   ; draw pixel double width
	mov dx, [panel_xyinc]          ; load xinc, yinc
.horiz_loop_skip_pixel:
	test di, 1                     ; decrement y every second x value
	jz .horiz_loop_skip_add_y
	add bl, dl					   ; add yinc to y
.horiz_loop_skip_add_y:
	inc cx                         ; increment x
	cmp cx, [panel_w]              ; compare x to w
	jl .horiz_loop                 ; loop if x < w

	pop cx                         ; now we're looping over depth again
	pop bx                         ; restore sy while we're at it

	shr dx, 8
	add si, dx                     ; add xinc to sx


	; if xinc is not set or we're on an odd-numbered depth, go up.
	test dl, dl                    ; if xinc is 0
	jz .depth_loop_dec_y
	test cx, 1                     ; or we're at an odd-numbered d value
	jz .depth_loop_after_dec_y
.depth_loop_dec_y:
	dec bx                         ; decrement sy value
.depth_loop_after_dec_y:
	loop .depth_loop

	popa
	ret


word_320: dw 320
secret_tune:
db 90h   ; send note on channel 0
db 67, 66, 63, 57, 56, 64, 68, 72

%include "lh.inc"
