;QB LOVE - 256b intro by TomCat/Abaddon

DEBUG EQU 0
maxvol EQU 0

Divider EQU 68

ORG 256

 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

if maxvol=1
 MOV BH,080H
 MOV GS,BX
 MOV [GS:BX],BX
end if

 MOV BH,0A0H
 PUSH BX
 MOV BP,SP              ; BP: -4
@@:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FSIN                   ; SIN(counter*PI/128)
 FIMUL WORD [SI]        ; 127*SIN(counter*PI/128)
 FISTP WORD [BX]        ; -
 INC BX
 DEC BYTE [DI]          ; loop 256x
 JNZ @B                 ; BX = sinus table

 MOV AL,13H             ; set video mode 320x200
.1:
if DEBUG=0
 INT 10H                ; call VGA Bios
end if
 IMUL DX,BX,128
 IMUL CX,BX,64  
 AND CX,01F00H
 TEST BL,BL
 JS .2
 XCHG CL,DH
.2:
 INC BL                 ; DH/CH/CL->R/G/B
 MOV AX,1010H           ; set one color by the VGA BIOS
 JNZ .1
 DEC BX
 MOV CH,BL
 INT 10H                ; set last color to white for highlight

 MOV AX,3508H
 INT 21H
 MOV [SI-2],ES
 MOV [SI+BP],BX

 POP ES
 POP BX                 ; BX:0
.0:
 INC DI                 ; DI:-1
 PUSH BX                ; put normal vectors to the stack
 PUSH BX
 PUSH DI                ; [SP]: 0 0 -1
 PUSH BX
 PUSH DI
 PUSH BX                ; [SP]: 0 -1 0
 PUSH DI
 PUSH BX
 PUSH BX                ; [SP]: -1 0 0
 INC DI
 JZ .0

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,Divider-90H     ; carry flag means turn on the speaker
 CALL init

 MOV BX,BB
nextframe:
 MOV SI,46CH
 FLD DWORD [BX-BB+SPEED]; speed
 FIMUL DWORD [BX-BB+IRQ.COUNTER];speed*time
 FLD ST0                ; alpha
 FADD ST0,ST0           ; 2alpha alpha

.1:
 MOV DI,SP              ; DI: normal vectors
.2:
 ADD SI,12
 FILD WORD [DI+2]       ; NY 2a a
 FILD WORD [DI]         ; NZ NY 2a a
 FILD WORD [DI+4]       ; NX NZ NY 2a a
.3:
 FLD ST3                ; 2a NX NZ NY 2a a
 FSINCOS                ; cos sin NX NZ NY 2a a
 FLD ST3                ; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1           ; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4               ; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2           ; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3               ; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0           ; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0          ; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0         ; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0          ; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [SI+BP]     ; sin*NX+cosNZ NY 2a a
 NEG BP
 JNS .3                 ; loop 2x (next axis)
 FSTP DWORD [SI]        ; 2a a
 ADD DI,6
 JNZ .2                 ; loop 6x (next side)
 FXCH                   ; a 2a
 NEG AX
 JS .1                  ; loop 2x (next cube)
 FUCOMPP                ; -

 NEG CX
nextline:
nextpixel:
 PUSHA                  ; 6*3*2: AX CX DX BX SP BP SI DI

 FILD WORD [BX-BB+CUBE] ; c
 CALL TraceCube
 FSTP DWORD [BX+4]      ; -
 JCXZ missed1
 FLD1                   ; 1
 JL shade
 XCHG DX,AX

 FIMUL WORD [BX-BB+CUBE2]; c
 CALL TraceCube
FIX2:
 FSTP DWORD [BX+8]      ; -
 FLD1                   ; 1
 JCXZ .1
 JL shade
.1:
 MOV BYTE [BX],33
 FCHS                   ; -1
 JCXZ back

 XCHG DI,AX
 CMP [BX+11],CH
 JL shade

back:
 MOV DI,DX
 CMP [BX+7],CH
 JL shade
 FSTP ST0

missed1:
 POPA
 MOV AL,0
 JMP plot

shade:
 FLD DWORD [DI]
 FSUB DWORD [DI+BP]
 FSUB DWORD [DI+4]      ; N.S
 FMULP
 FLDZ                   ; 0 N.S
 FUCOMI ST0,ST1         ; 0 N.S
 FCMOVB ST0,ST1         ; max N.S
 FSTP ST1               ; max

 FIMUL WORD [BX-BB+MAXCOLOR]
 FISTP WORD [BP+4-36-2]
 POPA
 ADD AL,[BX]
plot:
 STOSB
 INC DX
 CMP DX,160
 JNE nextpixel
 NEG DX
 DEC CX
 CMP CX,-100
 JNE nextline

 IN AL,60H
 DAS
 JC nextframe

 LDS DX,[256-4]
 SALC

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H

missed:
 FUCOMPP                ; c
RETN                    ; return to DOS prompt

TraceCube:
 FLDZ                   ; 0 c
 FILD DWORD [BX-BB+CUBE]; BIG 0 c
 FSUB ST1,ST0           ; BIG -BIG c

 MOV CX,6
nextside:
 CMP [SI+7],CH          ; Nz=0?
 JZ skip                ; no intersection

 FLD DWORD [SI+4]       ; Nz min max c
 FLD ST3                ; c Nz min max c
 FMUL ST0,ST1           ; c*Nz Nz min max c

 FLD ST4                ; c c*Nz Nz min max c
 FMUL DWORD [SI+BP]     ; c*Nx c*Nz Nz min max c
 FISUBR WORD [BP+4-36-6]; Px-c*Nx c*Nz Nz min max c
 FMUL DWORD [SI+BP]     ; Nx*(Px-c*Nx) c*Nz Nz min max c

 FLD ST5                ; c Nx*(Px-c*Nx) c*Nz Nz min max c
 FMUL DWORD [SI]        ; c*Ny Nx*(Px-c*Nx) c*Nz Nz min max c
 FISUBR WORD [BP+4-36-4]; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz min max c
 FMUL DWORD [SI]        ; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz min max c

 FADDP ST1,ST0          ; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz min max c

 FDIVRP ST2,ST0         ; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz min max c
 FSUBRP ST1,ST0         ; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz min max c
 JL front

 FUCOMI ST0,ST1         ; Iz min max c
 FCMOVNB ST0,ST1        ; Iz min max c
 FSTP ST1               ; min max c
 CMOVB AX,SI
 JMP skip

front:
 FUCOMI ST0,ST2         ; Iz min max c
 FCMOVB ST0,ST2         ; Iz min max c
 FSTP ST2               ; min max c
 CMOVNB DI,SI

skip:
 SUB SI,12
 LOOP nextside

 FUCOMI ST0,ST1         ; min max c
FIX1:                   ; JBE:76H, JA:77H, JS:78H / JB:72H, JAE:73H, JZ:74H
 JB missed
 INC CX

 FMUL ST0,ST0           ; min2 max c
 FXCH ST2               ; c max min2
 FMUL ST0,ST0           ; c2 max min2
 FMUL DWORD [BX-BB+HOLE]

 FILD WORD [BP+4-36-6]  ; Px 2c2 max min2
 FMUL ST0,ST0           ; Px2 2c2 max min2
 FILD WORD [BP+4-36-4]  ; Py Px2 2c2 max min2
 FMUL ST0,ST0           ; Py2 Px2 2c2 max min2
 FADDP ST1,ST0          ; Py2+Px2 2c2 max min2
 FSUBP ST1,ST0          ; 2c2-Py2-Px2 max min2
 FSUBR ST2,ST0          ; 2c2-Py2-Px2 max 2c2-Py2-Px2-min2
 FXCH ST1               ; max 2c2-Py2-Px2 2c2-Py2-Px2-min2
 FMUL ST0,ST0           ; max2 2c2-Py2-Px2 2c2-Py2-Px2-min2
 FSUBP ST1,ST0          ; 2c2-Py2-Px2-max2 2c2-Py2-Px2-min2
 FSTP DWORD [BX]        ; 2c2-Py2-Px2-min2
 MOV BYTE [BX],159
 CMP [BX+3],CH
RETN

; --------------------------- music please ! -------------------------------
NOTES:

IRQ:
 PUSHA
 MOV AL,2
.SAMPLE:

 SHR AL,1              ; zero means pause (no sound)
 JZ @F
 OUT 42H,AL             ; out the 6bit sample
@@:

 DB 66H,68H             ; PUSH DWORD 0FF000001H
.COUNTER:
 DB 0,16,0              ; timer counter (default 4096)
;DB 0,0,13              ; for debug 0D0000H
 DB 0                   ; sample sum (default 0)
 POP SI                 ; SI=timer counter
 POP BX                 ; BL=pattern, BH=volume

 MOV BP,NOTES
 INC DWORD [BP-NOTES+IRQ.COUNTER]

KICKDRUM:
 MOV AX,16128
 CWD
 MOV CX,32767-16384-4096
 AND CX,SI
 INC CX
 DIV CX
 AND AL,128;64
.1:
 ADD BH,AL

DONE:
 MOV [BP-NOTES+IRQ.SAMPLE-1],BH

if maxvol=1
 CMP [GS:8000H],BH
 JAE @F
 MOV [GS:8000H],BH
@@:
end if

 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET


SPEED DD 0.00005;3125
HOLE DD 1.75

CUBE DW 64
CUBE2 DW 38
MAXCOLOR DW 56

BB:
