; -----------------------------------------------------------------------------
; Kharon - a 256 byte story by marquee design
; (c)2020 marquee design  
;
; This intro is about the 5 stages of grief people experience when a loved
; one dies. It is named after Kharon. The ferryman of Hades who carries
; souls of the newly deceased across the river Styx that divided the world
; of the living from the world of the dead. This intro is ment to represent
; a modern hi-tech rail version of that trip to the underworld.
;
; Made in only 2 hours before the deadline, so excuses if some things seem
; a bit rough around the edges :S Thanks to Blossom for helping out with the
; FPU code.
;
; Greetings to: 
; sensenstahl, tomcat/abaddon, rrrola, digimind, p01, hellmood, frag, harekiet
; nuey, bruce, sjaak, sag, ile, aaldert, fready and the rest at #demotivation
;
; check out our other stuff at https://marqueedesign.revival-studios.com
; -----------------------------------------------------------------------------
%define OFFSET_9FFF (7*320-23)
%define OFFSET_FREEDOS (18*320-1)
;%define FREEDOS
;%define USECOLOR

; ============================= KERNEL INIT =================================
org 100h

start:
db 168   ; +0 distscale
dw 2800h ; +1 mul128
db 128	 ; +3 uvscale
dw 5	 

; init segments
mov fs,bp
%ifndef FREEDOS
 les bp,[bx]	
 mov gs,bp
%else 
 push word 0xa000-70
 pop es 
 push 8000h 
 pop gs
%endif
xchg ax,cx

; init video and colors
mov al,13h
palloop:				
 int 10h
%ifdef USECOLOR
; sub dh,4
 sub ch,4
 dec bx
 mov ax,1010h
loop palloop
%endif

;setup text
 mov ah,9
 %ifdef FREEDOS
 mov dx,text
 %else
 mov dl,text-100h
 %endif
 int 21h
 copy:
 es lodsb
 mov byte[fs:si],al
 loop copy

texture:	
 mov dx,bx
 imul ax, dx, 2
 xor dx, ax
 and dl, dh
 salc
bloop:
 adc al,0
 shr dx,1
 jnz bloop			; admit it: bloop sounds cute.
 mov byte [gs:bx],al;3
 inc bx
jnz texture

; ============================= UPDATE LOOP =================================
frameloop:
	xor bx,bx
	mov ax,0xcccd
	mul di	
    	%ifdef FREEDOS
	sub dh,104
    	%else 
	sub dx,0x648c
    	%endif

    	; death trip
	pusha
	fninit
	fldpi
	fild word [bx-14]
	fidiv word [si]
	fsincos
	fild word [bx-8]
	fidiv word [si+2]
	fadd st0,st1
	fld st0
	fild word [bx-9]
	fidiv word [si+2]
	fadd st0,st4
	fpatan
	fld st0
	fimul word [si+1]
	fistp word [bx-10]
	fld st0
	fsin
	fdivp st2,st0
	fmul st0,st4
	fadd st0,st3
	fsin
	fimul word [si+4]
	fadd st0,st4
	frndint
	fabs
	fmulp
	fld st0
	fidivr word [si]
	fimul word [si]
	fistp word [bx-11]
	fimul word [si]
	fistp word [bx-6]
	popa

	; fetch that texture
	add bx,bp
	movzx ax,byte [gs:bx]
	imul ax,cx
%ifdef USECOLOR
	shr ax,11
%else 
	shr ax,10
%endif
	; clamp color 
	mov cx,bp	 	
	xor cl,cl	
	test al,16+32+64+128
	jz drawtext
	mov al,15			

drawtext:	
	cmp dh,14
	ja storepixel
	imul bx,cx,20
	add bx,di
	shr bx,1
	or bx,1
	%ifdef FREEDOS
	or al,byte [fs:bx-OFFSET_FREEDOS]			; 5 bytes !!!
	%else 
	or al,byte [fs:bx-OFFSET_9FFF]			; 5 bytes !!!
	%endif
storepixel:
	%ifdef USECOLOR
	shr cx,4
	%else 
	mov cl,16
	%endif	
	add al,cl
	stosb
	inc di
	inc di
skippy:
jnz frameloop
 hlt
 inc bp
%ifndef FREEDOS			
 ; raildrone sound
 imul ax,bp,82 
 aam 0xd3
 mov dx,0x330
 out dx,al
 nosound:
%ifdef USECOLOR
jmp skippy
%else
in al,60h
dec al
jnz skippy
ret
%endif
%else
in al,60h
dec al
jnz skippy
ret
%endif

; ============================= DATA =================================
text:
 db 'denial'
 %ifdef FREEDOS 
 db 13,10
 %else 
 db 10
 %endif

 db 'anger'
 %ifdef FREEDOS 
 db 13,10
 %else 
 db 10
 %endif

 db 'bargain' ; ing'
 %ifdef FREEDOS 
 db 13,10
 %else 
 db 10
 %endif

 db 'depression'
 %ifdef FREEDOS 
 db 13,10
 %else 
 db 10
 %endif

 %ifdef USECOLOR
 db 'accept$' ; accept$
 %else
 db 'acceptance$'
 nop     		; for tony's sanity ;-)
 %endif

; - enjoy!
