;     __        __      __  __
;    /_  /  \/ / / / / /_  /_/
;   /   /_  / /_/  |/ /_  / \    (c) 2025, Milos Bazelides (Baze), Slavomir Labsky (Busy)
;
; Please use the Netwide Assembler (https://www.nasm.us/) to assemble the code:
; nasm.exe flyover.asm -o flyover.exe
;
; The package includes an alternative executable (flyover-no-vsync.exe) with adjusted timing
; for systems where the graphics driver doesn't enable vertical sync by default.
;
; The demo uses a peculiar way to check for keyboard events and keep the window responsive.
; Although it's short, it may occasionally cause the program to exit early. If that happens,
; simply try running it again. Double-clicking is usually the best option.
;
; As many programmers know, OpenGL can be challenging due to divergent driver implementations
; and its status as a "legacy" API. Size coding techniques add further complexity, relying on
; hard-coded values, driver quirks, and fixed-function pipeline features. Despite tight space
; constraints, we've aimed to maximize compatibility, though the program may not work on all
; setups. While we enjoy generating compelling visuals, our primary goal was to demonstrate
; the possibility of using shaders in 512 bytes without relying on pre-resolved DLL function
; addresses or hard-coded ordinals. To that end, we hope we've succeeded.
;
; We encourage the community to further refine this concept, as we have also been inspired
; by the work of Aske Simon Christensen (Blueberry), Rune Stubbe (Mentor/TBC), Frank Force
; (KilledByAPixel), Alexander Sotirov, and others.

%define VSYNC 1

;==============================================================================================
; HASHES OF IMPORTED DLL FUNCTIONS
;==============================================================================================

LoadLibraryA		equ	0x030C001C	; kernel32.dll
ExitProcess		equ	0x0178FB68	; kernel32.dll
CreateWindowExA		equ	0x02B7A390	; user32.dll
GetDC			equ	0x014E4EC0	; user32.dll
GetInputState		equ	0x02A6B790	; user32.dll
SetPixelFormat		equ	0x013B8A94	; gdi32.dll
SwapBuffers		equ	0x02E827FC	; gdi32.dll
wglCreateContext	equ	0x00F2808C	; opengl32.dll
wglMakeCurrent		equ	0x00789E40	; opengl32.dll
wglGetProcAddress	equ	0x02AF2804	; opengl32.dll
glRecti			equ	0x00740250	; opengl32.dll

;==============================================================================================
; PE HEADER
;==============================================================================================

		bits	32
		org	0x10000			; the smallest allowed value

ImageBase:	db	'MZbb'			; Mark Zbikowski, Busy, Baze :)
		db	'PE', 0, 0		; PE + 0x00 Signature
		dw	0x014C			; PE + 0x04 Machine (Intel 386 or later)
		dw	0			; PE + 0x06 NumberOfSections	 
;----------------------------------------------------------------------------------------------
;		dd	-1			; PE + 0x08 TimeDateStamp
;		dd	-1			; PE + 0x0C PointerToSymbolTable
;		dd	-1			; PE + 0x10 NumberOfSymbols
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
NextLib2:	mov	ebx,[ebp + ebx + 0x78]
		add	ebx,ebp			; EBX = export directory table
		mov	ecx,[ebx + 0x18]
		loop	NextFunc1		; ECX = NumberOfNames - 1
		db	2
Height		equ	$ - 2 - Shaders
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dw	0			; PE + 0x14 SizeOfOptionalHeader
		dw	2			; PE + 0x16 Characteristics (executable)
OptHeader:	dw	0x010B			; PE + 0x18 Magic (PE32)
;----------------------------------------------------------------------------------------------
;		db	-1			; PE + 0x1A MajorLinkerVersion
;		db	-1			; PE + 0x1B MinorLinkerVersion
;		dd	-1			; PE + 0x1C SizeOfCode
;		dd	-1			; PE + 0x20 SizeOfInitializedData
;		dd	-1			; PE + 0x24 SizeOfUninitializedData
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
NextFunc1:	mov	esi,[ebx + 0x24]
		add	esi,ebp				; ESI = ordinal table
		movzx	esi,word [esi + ecx * 2]	; ESI = DLL function ordinal
		mov	edx,[ebx + 0x1C]
		jmp	NextFunc2
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dd	Start1 - ImageBase	; PE + 0x28 AddressOfEntryPoint
;----------------------------------------------------------------------------------------------
;		dd	-1			; PE + 0x2C BaseOfCode
;		dd	-1			; PE + 0x30 BaseOfData  
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
OpenGl32:	db	'opengl32'		; the string is terminated by ImageBase
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dd	ImageBase		; PE + 0x34 ImageBase
		dd	4			; PE + 0x38 SectionAlignment
		dd	4			; PE + 0x3C FileAlignment
Width		equ	$ - 5 - Shaders
;----------------------------------------------------------------------------------------------
;		dw	-1			; PE + 0x40 MajorOperatingSystemVersion
;		dw	-1			; PE + 0x42 MinorOperatingSystemVersion
;		dw	-1			; PE + 0x44 MajorImageVersion
;		dw	-1			; PE + 0x46 MinorImageVersion
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Start3:		shl	ebp,16			; EBP = address of kernel32.dll
NextLib1:	mov	ebx,[ebp + 0x3C]	; EBX = PE header
		jmp	NextLib2
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dw	4			; PE + 0x48 MajorSubsystemVersion
;----------------------------------------------------------------------------------------------
;		dw	-1			; PE + 0x4A MinorSubsystemVersion
;		dd	-1			; PE + 0x4C Win32VersionValue
;		dd	0x04000000		; PE + 0x50 SizeOfImage
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Start2:		pop	ebp
		mov	edi,LibNames - 4	; Win32VersionValue = 0x0001xxxx
		dec	ebp
		jmp	Start3
		db	4			; SizeOfImage = 0x04xxxxxx
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dd	0			; PE + 0x54 SizeOfHeaders
;----------------------------------------------------------------------------------------------
;		dd	-1			; PE + 0x58 CheckSum
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Start1:		pop	ax
		jmp	Start2
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dw	2			; PE + 0x5C Subsystem (Windows GUI)
		dw	0			; PE + 0x5E DllCharacteristics  
LibNames:	dd	Gdi32			; PE + 0x60 SizeOfStackReserve
		dd	User32			; PE + 0x64 SizeOfStackCommit
		dd	OpenGl32		; PE + 0x68 SizeOfHeapReserve
Shaders:	dd	Shader			; PE + 0x6C SizeOfHeapCommit
;----------------------------------------------------------------------------------------------
;		dd	-1			; PE + 0x70 LoaderFlags
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
NextFunc2:	add	edx,ebp			; EDX = export address table
		push	ebp
		db	0xB8			; MOV EAX,0
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		dd	0 			; PE + 0x74 NumberOfRvaAndSizes

;==============================================================================================
; MAIN PROGRAM BODY
;==============================================================================================

NextFunc3:	mov	edx,[edx + esi * 4]
		add	edx,ebp			; EDX = DLL function address

		pop	esi
		add	esi,[ebx + 0x20]	; ESI = name pointer table
		mov	esi,[esi + ecx * 4]
		add	esi,ebp			; ESI = DLL function name pointer

CalcHash:	imul	eax,-49
		lodsb				; load a new ASCII character
		or	al,al
		jnz	CalcHash
		shr	eax,6
		mov	[eax],edx		; store the function address

		loop	NextFunc1

		scasd				; advance the library name pointer
		push	dword [edi]		; lpLibFileName
		call	[LoadLibraryA]
		xchg	ebp,eax

		test	ebp,ebp
		jnz	NextLib1

;		push	ebp			; lpParam = nullptr
;		push	ebp			; hInstance = 0
		push	ebp			; hMenu = 0
		push	ebp			; hWndParent = 0
		push	dword [edi + Height]	; nHeight = 519
		push	dword [edi + Width]	; nWidth = 1024
		push	ebp			; Y = 0
		push	ebp			; X = 0
		push	0x90000000		; dwStyle = WS_POPUP | WS_VISIBLE
		push	ebp			; lpWindowName = nullptr
		push	0xC018			; lpClassName (ATOM of UxSubclassInfo)
		push	ebp			; dwExStyle = 0
		call	[CreateWindowExA]

		push	eax			; hWnd
		call	[GetDC]
		xchg	ebx,eax			; EBX = HDC

;		push	ebp			; ppfd = nullptr
		push	10			; hard-coded pixel format
		push	ebx			; HDC
		call	[SetPixelFormat]

		push	ebx			; HDC
		call	[wglCreateContext]

		push	eax			; HGLRC
		push	ebx			; HDC
		call	[wglMakeCurrent]

		push	edi			; strings = Shaders
		push	eax			; count = 1 (TRUE)
		push	0x8B30			; type = GL_FRAGMENT_SHADER

		mov	esi,GlCreateShaderProgram
		push	esi
		mov	edi,wglGetProcAddress
		call	[edi]
		call	eax			; EAX = glCreateShaderProgramv

		push	eax			; program
		add	esi,GlUseProgram - GlCreateShaderProgram
		push	esi
		call	[edi]
		call	eax			; EAX = glUseProgram

		add	esi,GlUniform - GlUseProgram
		push	esi
		call	[edi]
		xchg	edi,eax

RenderLoop:	push	eax			; EAX = -1, except in the first iteration
		push	eax
		push	ebp			; EBP = 0..frame count (GPU will clip)
		push	ebp

		push	ebp			; v0 = frame count
		push	0			; location = 0
		call	edi			; EDI = glUniform1i

		call	[glRecti]		; render frame
		inc	ebp			; increment the frame counter

		push	ebx			; HDC
		call	[SwapBuffers]

		call	[GetInputState]		; peek for keyboard events
		dec	eax
		js	RenderLoop
 
		jmp	[ExitProcess]		; we're out!

;==============================================================================================
; ASCII DATA
;==============================================================================================

Gdi32:			db	'gdi32', 0
User32:			db	'user32', 0
GlCreateShaderProgram:	db	'glCreateShaderProgramv', 0
GlUseProgram:		db	'glUseProgram', 0
GlUniform:		db	'glUniform1i', 0

Shader:			db	'#version 410', 10, 'out vec3 o;uniform int t;void main()'
%if VSYNC
			db	'{ivec3 b;b-=b;for(o=b;(b.x|b.y)%9>=b.z;o++)b=ivec3(o.x*(gl_FragCoord.xy/26-10)+t/3e1,o);o=b/o/150;}'
%else
			db	'{ivec3 b;b-=b;for(o=b;(b.x|b.y)%9>=b.z;o++)b=ivec3(o.x*(gl_FragCoord.xy/26-10)+t/2e3,o);o=b/o/150;}'
%endif
			; the OS zeroes pages, making the last null redundant
