/* 
  CLIFE1D.C  - Classic 1D Cellular Automata Generator.

   (C) A.Millett 1992-2025. Released as free software under GNU GPL3 license. 
	(See: www.gnu.org/licenses/gpl-3.0.html )

  Simplified one Dimensional Cellular Automata pattern Generator, for DOS. 
  Hit SPACE for next pattern, ESC to quit. (type CLS or MODE 80 after)

  Uses MOD 5 sum of 3 cells above for next gen.
  For DOS/VGA, minimal version written in <256 bytes for TurboC + TCTINY lib.
   
  To build: TCTINY [TC3PATH] XLIFE2Dx   to build tiny .COM file (<1k)
  (See TCTINY.TXT for details on using TCTINY library) 

  Code from LIFE17.C, XLIFE2D4.C ..
->CLIFE1D-104  (6.5.2025)
  Make smaller/faster, sim to NASM version.
->CLIFE1D-105  (6.5.2025) (180 bytes)

*/

typedef unsigned char BYTE;
typedef unsigned int UINT;

#include "tctiny.c"

BYTE far *pTop = (BYTE far *) ((unsigned long) 0xa0000000L);		/* Vdu top, also used as "Rules" array */

#define XMOD 5

void main ()
{
    register BYTE far *pVdu;
    UINT x;
    UINT rnd = 0xa000; 
		/* Set VGA video mode 13h 320x200x256 */
    IO_VIDEOMODE (0x13);
    do {
		/* Top line is a "rules" lookup table for rest of screen */
      for (x = 0; x < 319; x ++) {
        rnd += x; rnd += rnd + (rnd >> 15); rnd ^= (rnd >> 8);
	pTop [x] = rnd;
      }
		/* Draw main screen, each new cell based on state of 3 above. */
      pVdu = pTop;
      do {
	pVdu [321] = pTop[(*pVdu+pVdu[1]+pVdu[2]) % XMOD] ;
	pVdu ++;
      } while ((UINT) pVdu);
		/* Ok, check for user key hit */
      do {
        IO_GETKEY (x); 
      } while (x == 0);
    } while (x != 27);
    /* IO_VIDEOMODE (3); */
}
