;------------------------------------------------------------
; mona86                               original idea: ilmenit
; by rudi/dke                            rel.date: 04.04.2024
;------------------------------------------------------------
  org 100h

  ;video
  mov al,19
  int 16
  push 40960
  pop es
  
  ;layer and stroke length initialization
  mov edx,0x7ec80000  ;32-bit seed
  mov sp,64           ;current layer
L mov bp,sp
  shl bp,1            ;correct index for stroke length data
  mov dx,[D-2+bp]     ;stroke length
  mov cx,dx           ;x-coord in lobyte, y-coord in hi-byte
  shl bp,4            ;current layer * 32

  ;galois lfsr seed update
P rol edx,1           ;rotate msb into lsb
  test dl,1           ;check msb which was rolled above
  jz Z                ;jump if zero 
  and dl,0xfe         ;clear bit 0
  xor edx,0x4c11db7   ;xor seed with polynomial
  mov bl,dl           ;displacement value

  ;conditional increment and decrement
Z and bl,130          ;mask out bit 2 and 8.
  cmp bl,2
  je X
  cmp bl,130
  je U
  jmp T
X inc cl              ;x++
  jmp T
U dec cl              ;x--
T cmp bl,1
  jb Y
  cmp bl,128
  je V
  jmp W
Y inc ch              ;y++
  jmp W
V dec ch              ;y--

  ;pixel coordinate calculation routine
W and cx,0x7f7f       ;x & 127 and y & 127
  mov si,sp
  and si,3
  mov ax,320
  mul ch
  add ax,cx           ;x+(y*320)
  mov di,ax
  mov al,[C+si]
  stosb

  ;loop checks
  dec bp
  jg P
  dec sp
  jns L

  ;stroke length data
D dw 0x2139,0x2bb9,0x2c44,0x9e37,0x25a7,0x96ce,0x312e,0xaf9d
  dw 0xc07b,0x238f,0xb23d,0x1e14,0xad63,0x3eaf,0x8d3c,0x5240
  dw 0x80c7,0xac72,0xb8e2,0x1877,0xe916,0x3ebb,0x0a09,0x0413
  dw 0x532c,0xb0f1,0x2914,0x8a96,0xb114,0xb242,0x542b,0xd431
  dw 0x3051,0xd57a,0x0d7d,0x7dfc,0xa32c,0x29ad,0x0859,0x8af7
  dw 0xa347,0x90a3,0x97f5,0xdf19,0x26d6,0x3d11,0x209c,0x2093
  dw 0x9cd2,0xd0b1,0x0280,0x70b5,0xb05a,0xb83e,0x9378,0x0ebd
  dw 0x1b0b,0x8a91,0xf59b,0x0e3c,0x072b,0x2f9b,0x37be,0x030a

  ;atari colors
C db 0x43,0x00,0x06,0x41