;CHROME REVENGE by Abaddon
;code:TomCat / music:ern0
;music only for PC Speaker

Divider EQU 68

ORG 256

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,Divider-90H     ; carry flag means turn on the speaker
 CALL init

 SUB AH,AH
 INT 16H
 POP DX
 POP DS
 SALC

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN

; --------------------------- music please ! -------------------------------
INCLUDE "NOTES.INC"

NOTES:
; DB Fs3,As3,Cs4,Fs4
; DB Fs3,A_3,Cs4,E_4
; DB Fs3,H_3,Ds4,Fs4
; DB Fs3,A_3,Cs4,A_4
; DB G_3,H_3,D_4,Fs4

 DB A_3,B_3,D_4,Fs4
 DB B_3,D_4,E_4,Gs4

 DB B_3,D_4,Fs4,B_4
 DB B_3,Cs4,E_4,Gs4

 DB Cs4,E_4,Fs4,A_4

IRQ:
 PUSHA
 MOV AL,2
.SAMPLE:

 SHR AL,1               ; zero means pause (no sound)
 JZ @F
 OUT 42H,AL             ; out the 6bit sample
@@:

 DB 66H,68H             ; PUSH DWORD 0FF000001H
.COUNTER:
 DB 0,16,0              ; timer counter (default 4096)
;DB 0,0,13              ; for debug 0D0000H
 DB 0                   ; sample sum (default 0)
 POP SI                 ; SI=timer counter
 POP BX                 ; BL=pattern, BH=volume

 MOV BP,NOTES
 INC DWORD [BP-NOTES+IRQ.COUNTER]

 MOV AX,BX
 CMP AL,2
 JB DRUMS

 MOV CX,3
 MOV DI,4*4
 SHR AL,1
 JC @F
 TEST SI,1111000000000000B
 JZ SKIP
 MOV CH,128
 MOV DI,AX
 SHLD DI,SI,CL
 AND DI,3*4
@@:
 DEC AX
 SHR AL,1
 AND CL,AL

CHORDS:
 SALC
 MOV AH,[BP+DI]         ; pitch F#,...
 MUL SI
 AND DX,1FH             ; wave saw

 ADD BH,DL

 INC DI
 TEST DI,3
 JNZ CHORDS

 IMUL AX,SI,-16
 OR AL,111B
 ROR AX,CL
 MUL BX                 ; tone env

 IMUL AX,SI,-1          ; volume env
 OR AH,CH
 MUL DX                 ; sample (6 bits [0..63])

 MOV BH,DH

SKIP:
 INC BX
 INC BX
 AND BL,3*4
 JZ DONE

DRUMS:
 SUB SI,1000000000000B

SEED:
 MOV AX,1

HIHAT:
 IMUL AX,AX,65521        ; constant recommended by Vuk
 MOV WORD [BP-NOTES+SEED+1],AX
 MUL SI
 XCHG AX,DX
 AND AX,32
 SHRD CX,SI,16+6+1
 TEST CL,32
 JZ SNARE
 AND CX,31
 INC CX
 CWD
 DIV CX
 JMP KICKDRUM.1

SNARE:
 XCHG CX,AX
 MOV AH,0D0H
 OR AX,SI
 IMUL AX
 TEST DH,DH
 JNZ .1
 XCHG AX,CX
 MUL DL
 ADD BH,AH
.1:

KICKDRUM:
 MOV AX,16128
 CWD
 MOV CX,8191
 AND CX,SI
 INC CX
 DIV CX
 AND AL,64
.1:
 ADD BH,AL

 MOV AL,180             ; vol 181 -> vol 127
 MUL BH                 ; mastering
 XCHG BX,AX
DONE:
 MOV [BP-NOTES+IRQ.SAMPLE-1],BH

 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET
