#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <malloc.h>
#include "lodepng.h"

int main()
{
	FILE* comFile = fopen("circles.com", "rb");
	unsigned char* comFileContents = (unsigned char*)calloc(256, 1);
	fread(comFileContents, 1, 256, comFile);

	int oneColorWidth = 50;
	int oneColorHeight = 10;
	int imageHeight = 256 / 4 * oneColorHeight;

	unsigned char* image32 = (unsigned char*)malloc(imageHeight * oneColorWidth * 4);

	for (int mul = 4; mul <= 8; mul *= 2) {
		for (int add = 0; add < 4; add++) {
			for (int i = 0; i < imageHeight * oneColorWidth * 4; i++) {
				image32[i] = 0;
			}

			for (int color = 0; color < 64; color++) {
				unsigned char r = comFileContents[color * mul + add];
				unsigned char g = comFileContents[color * mul + add + 1];
				unsigned char b = comFileContents[color * mul + add + 2];

				for (int y = 0; y < oneColorHeight; y++) {
					for (int x = 0; x < oneColorWidth; x++) {
						image32[((color * oneColorHeight + y) * oneColorWidth + x) * 4 + 0] = b; // in mode 112h color order in BGR
						image32[((color * oneColorHeight + y) * oneColorWidth + x) * 4 + 1] = g;
						image32[((color * oneColorHeight + y) * oneColorWidth + x) * 4 + 2] = r;
						image32[((color * oneColorHeight + y) * oneColorWidth + x) * 4 + 3] = 255;
					}
				}
			}

			char imageFileName[256];
			sprintf(imageFileName, "palette_mul%d_add%d.png", mul, add);
			lodepng_encode_file(imageFileName, (unsigned char*)image32, oneColorWidth, imageHeight, LCT_RGBA, 8);
		}
	}

	free(comFileContents);
	fclose(comFile);
}

