%define T                       data
%define XX                      data+4
%define YY                      data+8

%define LENGTH                  0x500

org 100h
s:
    mov ax, 0x1112
    int 0x10

    mov ax, 0xb800
    push eax
    pop es

top:
    mov ax, [T]
    and ax, 0xf
    jne skip

    ; clear screen
    mov di, 0
    mov cx, 2*80*50
    cld
    mov ax, 0x0820
    rep stosw

    ; TMDC
    mov      bx,2*80*48 + 10
    mov      word [es:bx], 0x0f54
    mov      word [es:bx+4], 0x0f4d
    mov      word [es:bx+8], 0x0f44
    mov      word [es:bx+12], 0x0f43
    mov      word [es:bx+16], 0x0403

skip:

    fld     dword [p1]        ; p1
    fimul   dword [T]         ; p1*t
    fld     st0               ; a1 a1=p1*t

    fld     dword [p2]        ; p2 a1 a1
    fimul   dword [T]         ; b1=p2*t a1 a1
    fld     st0               ; b1 b1 a1 a1

; Loop
    mov  cx, LENGTH

    ; Init c1 = 0
    fldz                      ; 0 b1 b1 a1 a1

draw:
    
    fadd     dword [p3]       ; c1+p3 b1 b1 a1 a1
    fxch     st1              ; b1 c1+p3 b1 a1 a1
    fcos                      ; c(b1) c1+p3 b1 a1 a1
    fxch     st1              ; c1+p3 c(b1) b1 a1 a1
    fld      st0              ; c1+p3 c1+p3 c(b1) b1 a1 a1
    fsincos                   ; c(c1) s(c1) c1+p3 c(b1) b1 a1 a1

    fmulp    st3, st0         ; s(c1) c1+p3 c(c1)*c(b1) b1 a1 a1
    fxch     st2              ; c(c1)*c(b1) c1+p3 s(c1) b1 a1 a1
    fimul    word [height]    ; H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    frndint                   ; (int) H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    fiadd    word [height]    ; H + (int) H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    fistp    word [YY]        ; c1+p3 s(c1) b1 a1 a1

    fxch     st3              ; a1 s(c1) b1 c1+p3 a1
    fsin                      ; s(a1) s(c1) b1 c1+p3 a1
    fmul                      ; s(a1)*s(c1) b1 c1+p3 a1
    fimul    word [width+1]   ; W*s(a1)*s(c1) b1 c1+p3 a1
    frndint                   ; (int) W*s(a1)*s(c1) b1 c1+p3 a1
    fistp    word [XX]        ; b1 c1 a1

    ; (YY & 0xfe) * W + ((XX + W) & 0xfe)
    and      word [YY], 0xfe

width:
    mov      ax, 80           ; this 80 is used up there

    mul      word [YY]
    xchg     bx, ax

    mov      ax, word [XX]
    add      ax, 80
    and      ax, 0xfe
    add      ax, bx
    mov      bx, ax

    mov      dword [es:bx+4], 0x07200703 ; 20 -> fa -> f9 -> 7
    mov      byte [es:bx+2], bl
    mov      byte [es:bx+4], cl

    mov      ax, cx
    and      ax, 0x100
    ror      ax, 8
    jz       skip2
    mov      ax, 0xf

skip2:
    mov      byte [es:bx+1], al
    mov      byte [es:bx+5], al


     fld      st2           ; a1 b1 c1
     fadd     dword [p1]    ; a1+p1 b1 c1
     fld      st0           ; a1+p1 a1+p1 b1 c1
     fxch     st2           ; b1 a1+p1 a1+p1 c1
     fadd     dword [p2]    ; b1+p2 a1+p1 a1+p1 c1
     fld      st0           ; b1+p2 b1+p2 a1+p1 a1+p1 c1

     fld      st4           ; c1 b1 b1 a1 a1

    sub cx, 1
    jnz draw

    add dword [T], 1

	in al, 0x60
    dec al

; return to top of loop if AL != 1
	jnz top
    ret
    
; ----------------------------------------------------
; Constants
; ----------------------------------------------------
p1:
    dd 0.012347
p2:
    dd 0.013531
p3:
     dd 0.00245431 ; (3.1415169 / LENGTH)
height:
    dw 50
; ----------------------------------------------------
; Vars
; ----------------------------------------------------
data:
