;-----------------------------------------------
;'industrial times' by Kuemmel for Revision 2019
;-----------------------------------------------
org 100h
use16

;---screen init:   
sub al,-(0x13+0x80)		;no screen clearing but doesn't matter and provides address (by Hellmood)
mov fs,word[si] 		;double buffer (results in 0x6d2c which is okay as an address)
int 10h

;---palette init
mov dx,03c9h
pal_loop:				;greyscale palette all lanes
	mov al,cl
	out dx,al
	out dx,al
	out dx,al
loop pal_loop

;---sound init
xor bp,bp				;bp is sound multi, starting value of 0 => 3.46 s of silence at start :-)
mov ax,3508h			;21h, ah=35h get interrupt handler | al=08h interrupt number (PIT timer)
int 21h 				;return: es:bx
push es
push bx 				;backup current interrupt handler
mov al,63				;PIT counter divisor => 63 equals 18939 Hz
mov dx,irq				;new handler address
call init				;sound init routine (also used for exit)

;---screen address init
push 0a000h
pop es

;---main intro loop
main:

;---create night sky with pulsing light & random dust particles
;uses ax,bx,cx,dx,di
test bp,bp					;wait 3.46 s before using the pulsing light
jz skippy
mov ax,word[irq.counter-2]	;get random seed from irq.counter into ax
skippy:
mov cl,ah					;use timer for circle size adjust via => beat visuals
and cl,63					;or try 31 (faster pulsing)
push bx 					;backup global parallax counter
light_plus_feinstaub_loop:
	adc bx,dx			;randomizer routine from Hellmood's TV noise :-)
	adc ax,bx
	inc bx
	push ax 			;backup random seed
	cmp al,ch			;amount of random particles trigger
	jb no_saturation	;random greyscale
	mov ax,0xcccd		;rrrola's trick 
	mul di				;x=dl (0...255), y=dh (0...199)
	mov al,dh			
	mov ch,63+16		;make feinstaub less dependent on y
	sub ch,dh
	shr ch,3			;adjust amount of feinstaub
	mul al				;y*y = > 199*199
	shr ax,1			;0...19800
	xchg ax,dx			;ax=x; dx=y*y	
	mul al				;x*x = > 255*255
	shr ax,1			;0...32512
	add ax,dx			;x*x+y*y
	add ah,cl			;0...204 + sound visualisation offset 
	cmp ah,63
	jbe no_saturation
		mov ah,63		;saturate to 63 shades of grey
	no_saturation:
	mov byte[fs:di],ah
	pop ax				;restore random seed
	inc di
jns light_plus_feinstaub_loop	;no need for lower half of screen
pop bx					;restore global parallax counter

;---create 3 layers of industrial blocks with chimneys :-)
;uses ax,bx,cx,dx,di
push bx 					;backup global parallax counter
mov cl,16					;3 layers => layer = 16,32,64
layer_loop:
	shl bx,1				;parallax scrolling offset calc
	mov ch,byte[si] 		;window colour based on sound sample for each layer
	mov di,320*64			;di = 64*320 start address for industrial blocks 
	industrial_block_loop:
		mov ax,0xcccd		;rrrola's trick 
		mul di				;x=dl (0...255), y=dh (0...199)
		sub dl,bh			;parallax movement
		mov al,cl			;colouring based on layer
		add al,64			;base is y = 64 => y + 16/32/64
		cmp dh,al			;check line for design chimney/building change
		jae skip_chimney
			;...chimney design
			mov dh,cl
			shr dh,2		;or try 1,2,3 => amount of chimneys 1/2/4
			or dh,cl
			test dh,dl
			jnz skip_plot	;no plot if not chimney
		skip_chimney:
			sub al,8		;adjust colour of buildings
			;...building design
			push cx
			shr cl,2		;size of windows
			and dl,cl
			pop cx
			and dl,dh		;(x AND layer) AND y ? 0
			jz skip_window
			;...building window design
				mov al,ch	;windows based on sound sample for each layer
				shr al,1
		skip_window:
		mov byte[fs:di],al
		skip_plot:
		inc di
	jnz industrial_block_loop
	add cl,cl				;layer = 16,32,64
jns layer_loop				;equals cmp cl,128 as 128 is first signed number 0x80
pop bx						;restore global parallax counter
	
;---bx is global counter for parallax movement, don't change anywhere else...
add bx,127		;+127 saves a byte over +128
	
;---vsync for timing & flicker reduce
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---copy buffer to screen
;needs di=0,cx=0 / di is zero here
xor cx,cx
copy_buffer_loop:
	salc				;xor cx,cx clears carry flag, following instructions don't
	xchg byte[fs:di],al	;clear backbuffer also otherwise glitches at first chimney layer
	stosb
loop copy_buffer_loop

;---key check and exit			
in al,60h
dec al		;ah is not zero due to industrial block loop
jnz main	;nothing so go on
pop dx		;restore handler address at exit
pop ds				
init:		;ax is zero at exit here...
out 40h,al	;al = 0 or 63 => write PIT counter 0 divisor = 63 low byte
xchg ax,cx	;cx is zero here at exit and init
out 40h,al	;al = 0 => write PIT counter 0 divisor again = 0 high byte
			;=> this results in a frequency for the interrupt call of 18939 Hz.
			;as clock is 1,19318181818 MHz => 1,19318181818 MHz / 63 = 18939 Hz
mov ax,2508h
int 21h
ret			;return after init or exit code

;---bytebeat interrupt subroutine
;based on ideas from http://www.pouet.net/topic.php?which=8357&page=1
irq:
pusha
mov ax,0						;ax: timer => self modifying code
.counter:
shr ax,1						;sound creation via SHIFT/OR with timer & MUL/ADD with top timer
mov cx,ax
shr ax,3
or cx,ax
shr ax,4
or cx,ax
shr ax,7
or cx,ax
xchg ax,cx
mul bp
add ax,bp
mov dx,0378h					;LPT1 parallel port address
out dx,al						;write 8 bit sample data
mov byte[si],al 				;save sample for sound visualisation
inc word[irq.counter-2] 		;inc timer each interrupt call within code
mov al,20h
out 20h,al
popa
jnz skip_inc_top_timer
	add bp,12					;inc top timer/sound for more variation every 65535/18939 = 3.46 s
skip_inc_top_timer: 
iret
