;---"fontaineous particulous" by Kuemmel for Revision 2021      ---
;--- a 8 effect fontaine battery with a special at effect 8 :-) ---
org 100h
use16
p_max			= 1300	;maximum amount of particles (needs to be smaller than 4078 due to segment override of data)
p_max_max		= 2047	;maximum length/particles of one effect 
p_add			= 5		;amount of particles added each frame
p_start_colour	= 32	;start colour of particle, greyscale 32, rainbow 56
p_end_colour	= 15	;end colour of particle, greyscale 15, rainbow 31
p_bottom_line	= 1		;draw bottom line (yes=1,no=0), kind of water surface effect

;---init stuff
sub al,-(0x13+0x80)	;trick by Hellmood
mov fs,[si]			;backbuffer
int 10h
push 0a000h				
pop es							
xor bp,bp			;init timer/particle counter
fninit

;--- main loop
main_loop:
mov di,constants	;constant address -fixed-
mov si,constants+32	;particle address -moving-
and bp,32767-3		;0111.1111.1111.1100	16383-3
add bp,p_add		;add new particles or just inc global timer...

;---8 different effect variations dependent on timer bp
mov byte[di+randomizer-constants+2],113 ;init randomizer for all effects
mov cx,p_start_colour+256*p_end_colour	;modify start & end colour due to effect 7 later
shld ax,bp,5		;????.????.???0.1111 => read timer on effect choice position
test al,1b
jnz effect_rand		;if 0,2,4,6 => de-randomize 1,3,5,7 => randomize
	mov byte[di+randomizer-constants+2],127
effect_rand:
and al,111b			;effect choice 0...7 => 8 different effects
;-effect 0: no change to presets
jz effect_0_colouring_and_height
cmp al,7			;check for effect_7
je effect_7
;-effects 1...6: vertical adjustments over time
neg al				;-2...-6
add al,14			;12...8
xchg ax,cx		
shld ax,bp,cl		;effect variation from timer level
and al,111b			;11 or 111b 
sub al,7			;5 or 7
mov byte[di-2],al	;ah is 0xff all the time
jmp skip_effect_7	;skip effect_7
;-effect 7: rainbow and slow-motion of effect 0
effect_7:
hlt					;slow-motion
mov cx,56+256*31	;rainbow colour range
effect_0_colouring_and_height:
mov byte[di-2],-5	;fixed height
mov byte[di+col_particle-constants+3],cl		;modify start colour in code
mov byte[di+col_lower_limit-constants+1],ch		;modify end colour in code
skip_effect_7:

;---particle loop
mov cx,bp			;cx = bp for loop
and cx,p_max_max	;0000.0111.1111.1111
cmp cx,p_max		;check if above p_max
jbe particles_loop
	mov cx,p_max	;limit to the "flow off"
	particles_loop:
		mov bx,8					;loop counter also used for offset addressing x/y
		xy_loop:					;st0					st1
		cmp cx,p_add				;if cx <= particle_add then add random particles
		ja skip_add_random_particles
			randomizer:
			imul ax,word[di],113	;rnd generation - multiply magic constant
			mov word[di],ax 		;rnd generation - feedback to the seed
			;interesting: 57791,59999, 577, 5807, 28447, 48271
			;seeming good: 977, 2207, 67, 109, 113
			;looking funny: 127
			;based on 32 Bit version from https://xoofx.com/blog/2009/10/25/random-float-number-using-x86-asm-code/
			;imul eax,dword[si],16807
			;mov dword[si],eax	
			fild word[di+bx-4]	    ;200/160
			fst dword[si+bx+4]		;store po at +12/+4
			fild word[di]			;get rnd				200/160
			fidiv word[di+2]		;range rnd(-1...+1)		200/160
			faddp st1,st0			;200/160+rnd
			fiadd word[di+bx-2]	    ;200/160+rnd + -5/0
			fstp dword[si+bx]		;store p at +8/+0
		skip_add_random_particles:
		fld dword[si+bx]			;p
		fadd dword[di+bx+8]			;p+gr
		fld st0 					;p+gr					po_new=p+gr   
		fsub dword[si+bx+4]			;v=(p+gr)-po			po_new
		fmul dword[di+12]			;v=(p+gr)-po)*dg		po_new
		fadd st0,st1				;p=(p+gr)+v				po_new
		fstp dword[si+bx]			;po_new
		fist word[di+bx+20]			;po_new for plot
		fstp dword[si+bx+4]
		sub bx,8
	    jns xy_loop 				;loop twice for px and py at bx = +8/+0
		mov ax,word[di+20]			;screen y
		mov bx,word[di+20+8]		;screen x	
		cmp ax,199
		if p_bottom_line=0
			ja skip_plot
		end if
		if p_bottom_line=1
			jbe skip_limit_y
				mov ax,199				;=> water stays at the bottom :-)
			skip_limit_y:
		end if
		cmp bx,319					;right ?
		jg skip_plot
		test bx,bx					;left ?
		js skip_plot
			imul ax,ax,320			;y*320	
			add bx,ax				;y*320+x
			col_particle:
			mov byte[fs:bx],p_start_colour
		skip_plot:
	    add si,16					;next particle address
	loop particles_loop				;loop through all available particles

;---vsync
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---copy screen with feedback on standard palette
xor di,di
copy_screen:
    mov al,byte[fs:di]
	dec ax
	col_lower_limit:
	cmp al,p_end_colour
	jg skippy
		salc
	skippy:
	mov byte[fs:di],al
	stosb
loop copy_screen

;---key check and exit			
in al,60h
dec al		;ax doesn't work here
jnz main_loop
ret
dw    210	;int_y_off		 - 4	;if 195 = opcode 'ret' is used you save 1 more byte :-) 
dw     -5	;int_y_add	     - 2 
constants:
dw		1   ;random seed	 + 0
dw 0x8000   ;random div 	 + 2 
dw    159	;int_x_off	     + 4
dw		0	;int_x_add	     + 6
dd  0.087	;ygr		     + 8
dd 0.9999	;dg				 +12
dd    0.0	;xgr		     +16	;could be skipped if DOSBox...;-)
;particle_data at +32 to have space for variable storage after constants 
;dword py	  ;1st particle
;dword py old
;dword px
;dword px old 
;dword py	  ;2nd particle...
