-- title:  July 2
-- author: Jin X
-- desc:   TIC-80 256b intro
-- script: lua

t=0
cls()
function TIC()
 -- params
 r=math.sin(time()*.000007)*1.57+3.14 -- julia parameter (angle)
 v=math.sin(r)*.8
 u=math.cos(r)*.8
 i=math.sin(time()*.00007) -- moving from one side to another
 r=1.57+r/2
 q=math.sin(r)*i
 p=math.cos(r)*i
 z=math.sin(time()*.0004)*5+27 -- zoomer
 -- draw
 for y=t%4-67,67,4 do
  for x=-119,119,2 do
   r=(math.atan(y,x)-time()*.0002)%6.28 -- angle + rotation
   if r>3.14 then r=6.28-r end
   i=(x*x+y*y)^.5*.03 -- distance from center
   -- julia fractal
   d=0 -- depth
   r=p+r*.9^z -- im
   i=q+i*.9^z -- re
   while r*r+i*i<4 and d<48 do
    d=d+1
    r,i=r*r-i*i+u,2*r*i+v
   end
   circb(x+120,y+68,1,-d/3)
  end
 end
 t=t+2
end
