;num.one // whack-a-byte
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: wednesday campanella - medusa
;____________________________________________________________________________

;quick docs: - press the correct key on the num block within the time limit

;long bla bla:
;whack-a-mole
;hit the key on the num block indicated by the smiley face
;if you want a real challenge do not use the num block ;)
;if you hit the wrong key you lose 1 life
;game ends when all 3 lifes are gone
;if you don't hit within the time limit, you lose 1 life as well
;as long as you survive the score is increased by 1 every time the timer
;gets a reset or you hit a button (even the wrong one)
;if you reach score 256 the game ends and you can consider yourself a winner
;the timer gets a reset + new cpu pos when a key is pressed, so after hittin
;a key there is no time to breathe
;also 0.com was chosen as name so one does not have to take away the hand
;from the num block in case of a restart

;assuming: ax = 0 cx = 255 bx = 0
;          80x25 textmode
;          num block is activated

;global used: di = the key pressed by the player
;             [bp] = frame counter ---> replaced by bp
;             [bp+2] = cpu pos you have to match  --> replaced by [ds:2]
;             [bp+4] = key pressed ? --> replaced by [ds:bx(0)]
;             [ds:80*2*26] rnd seed

;runs under dosbox and freedos. xp console does not like 80x25
;sorry but not going to waste those bytes just to kill
;it under freedos where the switch takes so long the game is over before it
;even starts. initially i wanted to have it in 40x25 for nice visuals but
;that would eat just more bytes for the setup. but this way you can restart
;the game fast and get another cramp in your hand.

;error?: overlap of not pressing a key and then pressing while there was an update in the
;random pos. not really an error because you need to be on top of the game anyway. it is a
;challenge. don't be too fast nor too slow. find the sweet spot of success. that's what the
;counter bar is for. i could have gone for 1 hit kill but that would be less motivating i
;guess. to the false sense of safety due to 3 hearts displayed is good.

;well i also added a visualisation for the timer because i could squeeze out quite some
;bytes. it is not a good nor fun concept but i for myself might have tried it at least
;once if i would have found it on a disk in the 90s. but are those small games not in many
;cases like throwaway jokes nobody thinks are funny but they got produced for some
;variety/comedy show :D

;runs under dosbox and freedos. it runs under xp but since xp has its issues with textmodes
;while also having 80x50 as standard in the console one has to set up the switch to 80x25
;before running the game.

org 100h
use16

bse equ 38*2+10*80*2 ;pos of stuff

start:   push 0b800h ;textmooooooode
         pop ds
         mov fs,bx   ;frame limiter
;         mov al,03h  ;by assumung this
;         int 10h     ;-4b and not mode switch problems
                      ;so you can instantly start a new session
                      ;after failing big time

cls:
mov byte[ds:bx],ch ;0
inc bx
jnz cls
;xor bp,bp ;frame counter
           ;jna at check does the job for the 1st frame to sync things

;mov byte[ds:bse+4*80+4],"0"
;mov byte[ds:bse+4*80+4+1],9

;mov word[ds:bse+4*80+4],0930h ;0 score
mov di,6
init:
mov word[ds:di+bse+4*80*2-2],0930h ;0 score
mov word[ds:di+bse-2],0c03h ;life
dec di
dec di
;mov word[bp+di],bx ;zero stuff
jnz init

xor bp,bp ;frame counter
          ;using bp above does not save b because
          ;mem access is +1 using bp compared to di
          ;this also gives the player time to get adjusted
          ;before the 1st cpu pos gets generated

;mov word[ds:bse+4*80*2],0932h   ;test 2
;mov word[ds:bse+4*80*2+2],0935h ;test 5
;mov word[ds:bse+4*80*2+4],0935h ;test 6

mov cl,3 ;# of lifes
         ;you better adjust fast
;init stuff is done at score/life init
;mov byte[bp+4],bl;set that a key was pressed at the beginning
                 ;to eliminate different memory contents

;mov word[bp],bx;0 ;init frame counter to 0
                  ;just to be fair (3b for it is a bit unfair though)

;mov word[bp+2],bx ;init random player pos

main:
;#################
;putting the key check here instead of at the end saves a few b
;because jumps get short ones so it is a winning trade even with
;an extra jump to main + jump to breaker getting larger

;plus this way after pressing a key a new pos is created and the
;frame limiter grabs instead of doing that and then check the key
xor di,di ;init value

         mov ah,01h
         int 16h
         jz main_               ;if no key pressed do nothing
                                ;and simply update screen

         mov ah,00h            ;key pressed so get the code
         int 16h               ;nouws

         cmp al,27             ;esc
         je breaker            ;bye bye

cut4:    cmp al,31h            ;1
         jb main_
cut6:    cmp al,39h            ;9
         ja main_

movzx di,al     ;save the code of the pressed key
jmp keypressed  ;and get right into the checks
;#################

main_:

;bx = 0 here, always

adc word[ds:80*2*26],1357 ;adc word[cs:start],1357 ;seed

inc bp ;inc frame counter

;display some sort of timing counter
;not accurate but it is good enough
;below 8 it gets drawn black (bg color)
;above/incl that it gets blue (bg)
;so it is off by 2 but that is okay for such a small
;feature + one has to look at the play field and not
;the bar ;)
imul si,bp,2
mov ax,si;imul ax,bp,2
count:
mov word[ds:si+bse+160*10-10+1],ax
dec si
dec si
jnz count

cmp bp,10    ;check frame counter
jna skip     ;there is still time to press a key
xor bp,bp    ;reset frame counter

cmp byte[ds:bx],bl;0 ;key was pressed
je skip2             ;so do not punish

;cmp di,bx
;jne skip2
call punish ;in your face
jz breaker  ;for not making a simple decision

skip2:
;mov byte[bp+4],1 ;set to no key was pressed
                 ;so at next loop there will be
                 ;a punishment except a key is pressed
                 ;within the frame count
inc byte[ds:bx]   ;activate punishmend for the next frame

;xor ax,ax
;xor dx,dx
mul bx
;bx = 0
mov bl,6
score:
mov al,byte[ds:bx+bse+4*80*2-2] ;get score
cmp ah,bh;0                     ;reminder?
jne okok1                     ;nope
inc ax;al ;score+1
cmp al,"9"
jna okok2  ;all good, so no reminder
mov al,"0" ;reset current counter
jmp okok1  ;and display it
okok2:
inc ah     ;deactivate reminder
okok1:
mov byte[ds:bx+bse+4*80*2-2],al ;display count at pos
add dl,al                       ;add the current digit
cmp dl,32h+35h+36h              ;did you reach the goal?
je breaker  ;well done, gamer. now go and code something
dec bx      ;next digit
dec bx      ;so at 999 +1 it resets to 0
jnz score


onceagain:
;create new cpu pos
in al,40h             ;rnd enough
imul word[ds:80*2*26] ;seed
inc ah  ;)
setp ah ;)
shr al,5 ;/32 = 0..7
add al,ah ;0..8
inc ax    ;1..9
xor ah,ah
add al,30h

;cmp al,39h;testing
;ja breaker;testing
;cmp al,31h;testing
;jb breaker;testing

;cmp ax,word[bp+2] ;not at a spot twice
;je onceagain

mov word[ds:2],ax  ;store the cpu pos
jmp skip          


;if 1..9 is pressed a jump is done to this offset
keypressed:
mov bp,10;di;15 ;so next frame will get a new pos
                   ;for the mole
                   ;since the lenght of the counter bar is based on bp
                   ;using di would cause an display error
mov byte[ds:bx],bl;0 ;a key was pressed
                     ;so don't punish at the next frame for not pressing
                     ;since things get a reset at the next frame

;draw things
skip:
;bx = 0
;ax is free to use
;dh = 0
mov dx,30h;counter/pos
mov bx,3*160
field1:
xor si,si
field2:
inc dx
;mov byte[ds:bse+si+bx+1],14+7*16;col
;mov byte[ds:bse+si+bx],00h
;mov word[ds:bse+si+bx],7e00h ;draw an empty cell
mov ax,7e00h

cmp dx,word[ds:2]          ;is current field the random cpu pos?
jne no2                    ;nope
;mov byte[ds:bse+si+bx],02h ;draw random cpu pos
mov al,02h
no2:

cmp dx,di        ;is current field the player pos?
jne no           ;nope
                 ;this also includes if no key is pressed (di = 0)
;mov byte[ds:bse+si+bx],0dbh;254 ;draw the field the player chose
;mov al,0dbh;indicate where player hit
;mov ah,0ah ;indicate hit
mov ax,0adbh

cmp di,word[ds:2] ;is player on same field as cpu?
je go_on          ;yes so show it and go on with it

too_bad:     ;life -1
call punish  ;oh mai
jz breaker   ;you are a lamer
mov ah,04h   ;show that you did not hit

go_on:
;mov byte[ds:bse+si+bx+1],0ah;show that you hit
;mov ah,0ah
no:
mov word[ds:bse+si+bx],ax ;draw the field

inc si
inc si
cmp si,3*2
jne field2
sub bx,160
jnz field1

;check timer and make next frame
mov word[fs:046ch],ax ;set
again:
cmp word[fs:046ch],ax ;get
je again ;check again, if time passed

;#################
;keycheck got moved upwards
jmp main
;#################

punish:
dec cx ;sets zf
imul di,cx,2
mov byte[ds:di+bse],ch ;delete heart
;mov byte[ds:bse+si+bx+1],04h;show that you did not hit

breaker: ret ;halt!
         nop ;255
         nop ;256