; VARIABLES :
;=============
valeur128   dd 128.0
valeur255   dd 255.0
valeur16384 dd 2000.0

;mt_x        dd 0
;mt_y        dd 0
mt_temp     dd 0

TunnelX     db 0
TunnelY     db 0

; PrepareTunnel
;===============
; Desc     : Prpare les deux tables
; Entre   : ES, FS : les adresses des tables
; Modifis : DI=0, EAX=?
; Retour   : /


PrepareTunnel:

; Premire partie :
  xor di,di
                             ; ST       | ST(1) | ST(2) | ST(3) | ST(4) |
  fldpi                      ; pi       |        
  fld dword [valeur128]      ; 128      | pi    |
  fld dword [valeur255]      ; 255      | 128   | pi    |
  
  mov [temp1],dword 0

  mta_ligne:
    mov [temp2],dword 0

    mta_colone:
      fild dword [temp1]      ; y        | 255   | 128   | pi    |
      fsub st2               ; y-128    | 255   | 128   | pi    |
      fild dword [temp2]      ; x        | y-128 | 255   | 128   | pi    |
      fsub st3               ; x-128    | y-128 | 255   | 128   | pi    |
      
      fpatan                 ; atn(x/y) | 255   | 128   | pi    |

      fmul st1               ; 255*atn  | 255   | 128   | pi    |
      fdiv st3               ; 255atn/pi| 255   | 128   | pi    |
      fistp dword [mt_temp]  ; 255      | 128   | pi    |
      fwait                  ; fo bien un peu attendre
      mov eax,[mt_temp]
      stosb

      inc word [temp2]
      cmp word [temp2],256
    jne mta_colone

    inc word [temp1]
    cmp word [temp1],256
  jne mta_ligne



; Deuxime partie :
  push es
  push fs
  pop es
  pop fs

  xor di,di


;  fincstp                    ; 128      | pi
;  ffree st1                  ; 128      |
  finit
  fld dword [valeur128]
  fld dword [valeur16384]    ; 16384    | 128   |
  
  mov dword [temp1],0
  .mtd_ligne:
    mov dword [temp2],0

    .mtd_colone:
      fild dword [temp2]      ; x        | 16384 | 128   |
      fsub st2               ; x-128    | 16384 | 128   |
      fmul st0,st0           ; (x-128) | 16384 | 128   |

      fild dword [temp1]      ; y        | x    | 16384 | 128   |
      fsub st3               ; y-128    | x    | 16384 | 128   |
      fmul st0,st0           ; (y-128) | x    | 16384 | 128   |
      faddp st1,st0          ; x+y    | 16384 | 128   |
      fsqrt                  ; (x+y) | 16384 | 128   |
      fdivr st0,st1          ; 16384/. | 16384 | 128   |
      
      fistp dword [mt_temp]  ; 16384    | 128   |
      wait
      mov eax,[mt_temp]
      stosb

      inc word [temp2]
      cmp word [temp2],256
    jne .mtd_colone

    inc word [temp1]
    cmp word [temp1],256
  jne .mtd_ligne

  push es
  push fs
  pop es
  pop fs

ret

; DoTunnel
;==========
; Desc     : Calcule le tunnel en 256*256
; Entres  : DS = angles, ES = depths, 
;            FS = texture, GS = destination
; Modifis : BX=?, DI=0
; Retour   : /

DoTunnel:
  mov dx,[cs:TunnelX]
  xor di,di

  .DoTunnel_loop:
    mov bl,[ds:di]
    add bl,dl
    mov bh,[es:di]
    add bh,dh
    mov bl,[fs:bx]
    mov [gs:di],bl

    inc di
  jnz .DoTunnel_loop
ret
