; __  __ VLOČKA
;_\ \/ /_ a 32-byte intro by rrrola <rrrola@gmail.com>
;\_\__/_/  best watched in DOSBox (needs fast BIOS putpixel)
; /_/\_\  greets to everyone who's ever written a 32-byte intro

; It's a semi-random walk with hexagonal symmetry.
; Lucky discovery, then a long search for the prettiest settings.

; Keep a pen position in [CX=x, DX=y] an draw a pixel there.
; Rotate it around the center [R,R] in 6 steps:
;   x -> R+x-y -> 2R-y -> 2R-x -> R-x+y -> y -> x -> ...
; Sometimes nudge x to the left based on a random state in DI.
;   We keep rotating so we can effectively move in all 6 directions.
; The pen position also feeds back to the random state.
;   It's similar to a LFSR, but it's intentionally not too random
;   to get patterns with different amounts of order and chaos:
;   lines, wavy paths, wide 3D mazes, snowflakes, noise...
; When x=0, pick a new pixel color (out of four) based on the current y.

; It needs to repeat eventually (there are about 37 bits of state).

org 100h  ; assume ax=0 cx=0xff si=0x100 di=sp=0xfffe [sp]=0

  add ax,0x4f02                                              ;05 02 4f
P add cx,[si] ; rotation center R = 0x0205-1 = 516           ;03 0c
  pop dx      ; on init: dx=0                        colors:{;5a
  and dh,3    ; wrap around, stay on the screen: dx<1024    {;80 e6 03

  mov bx,0x105; on init: set VESA mode 1024x768, 256 colors, al=4F (blue)
  int 0x10    ; later: draw pixel at [cx,dx] (al=color, bh=ignored page=1)

  sub di,cx   ; feed back position to random state (di)
  sub di,dx
  add di,di   ; set carry

  loop C      ; cx -= 1
  mov al,dh   ; if cx=0, change color {sand=5a, blue=80, dirt=e6, cyan=3}
  xlat        ; al = [bx+dh] = [bx + Y/256], don't change carry

C push cx     ; rotate around the center in 6 steps
  sbb cx,dx   ; [x, y] = [R+x-y-carry, x]

  mov ah,0x0c ; int 0x10 - draw pixel

  jmp P
