;Final Bytes - 256 byte intro
;coded by TomCat/Abaddon

BASE EQU BP-16
BASE2 EQU BASE+SI-256
REGS0 EQU BASE-2
SDX0 EQU REGS0-6
REGS1 EQU REGS0-16
SAX1 EQU REGS1-2
REGS2 EQU REGS1-16
SAX2 EQU REGS2-2
SDX2 EQU REGS2-6
BIG EQU MAXCOLOR
STEP EQU MAXCOLOR

ORG 256

 FLDLN2 		; alpha
 MOV AL,13H		; set video mode 320x200
 INT 10H		; call VGA Bios
 DEC BX 		; BX:0FFFFH
nextcolor:
 XCHG BX,CX
 SHR CL,1
 JNO .2
 MOV CL,63
.2:

 DB 0			; skip data
MAXCOLOR DW -131;-198;255;56;74;94
 AND DI,[DI]		; DD 0.04;0.03217

 IMUL DX,BX,64
 MOV AX,1010H		; set only one color by the VGA BIOS
 INT 10H		; call VGA Bios
 MOV CX,BX
 LOOP nextcolor 	; CX:0 BX:1 DX:64 DI:0
 CBW			; AX:16
 CWD			; DX:0
 XCHG BP,AX		; BP:16
 MOV BL,4		; BX:4

 PUSH WORD 0A064H	; small letterbox - skipping the first 5 lines
 PUSH WORD 08000H	; buffer for rotated normal vectors
 POP DS
 POP ES

.1:
 FADD DWORD [BASE2+STEP]; alpha
 FLD ST0		; alpha alpha
 FADD ST0,ST0		; 2*alpha alpha
;FCOS
 MOV AX,110101000011B	; tetrahedron normal vectors
.2:
 MOV CL,3
.3:
 FLD1
 SHR AX,1
 JNC .4
 FCHS
.4:
 LOOP .3
.5:
 FLD ST3		; 2a NX NZ NY 2a a
 FSINCOS		; cos sin NX NZ NY 2a a
 FLD ST3		; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1		; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4		; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2		; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3		; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0		; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0		; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0 	; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0		; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [DI+BX]	; sin*NX+cosNZ NY 2a a
 NEG BX
 JS .5			; loop 2x (next axis)
 FSTP DWORD [DI]	; 2a a
 ADD DI,BP;16
 TEST AX,AX
 JNZ .2 		; loop 6x (next side)
 FSTP ST0		; a
 TEST DI,DI
 JNZ .1
;FSTP ST0		; -

 MOV CL,190
nextframe:
 HLT
 PUSHA
nextline:
 MOV DX,320
nextpixel:
 PUSHA
 MOV AL,31
 AND AX,DX
 XCHG CX,AX
 SUB CX,BP
 AAM 32
 SHR DX,5
 XCHG DL,AL
 SUB DX,BP
 AAD 10
 XCHG CX,AX
 IMUL DI,CX,117
 PUSHA
 ADD DI,[SDX0]		; frame counter
 SHL DI,6		; 64 bytes per tetrahedrons (4 normal vectors)
 FLDL2T 		; the radius of tetrahedron
 ADD CX,CX
 CMP [SDX0],CX
 JNE .2
 FSQRT			; smaller radius at the beginning
.2:
 JNC .3
 FSUB ST0,ST0		; zero radius -> hide
.3:
 FILD DWORD [BASE2+BIG] ; positive_bignumber c
 FILD WORD [BASE2+BIG]	; negaive_bignumber positive_bignumber c

 MOV CL,4;*2		; SIDES (num of normals)
nextside:
 SUB DI,BP;16
 FLD DWORD [DI-4]	; Nz max min c
 FLDZ			; 0 Nz max min c
 FUCOMIP ST0,ST1	; Nz max min c
;JZ skip		; no intersection
 FLD ST3		; c Nz max min c
 FMUL ST0,ST1		; c*Nz Nz max min c
 FLD ST4		; c c*Nz Nz max min c
 FMUL DWORD [DI+BX]	; c*Nx c*Nz Nz max min c
 FISUBR WORD [SAX2]	; Px-c*Nx c*Nz Nz max min c
 FMUL DWORD [DI+BX]	; Nx*(Px-c*Nx) c*Nz Nz max min c
 FLD ST5		; c Nx*(Px-c*Nx) c*Nz Nz max min c
 FMUL DWORD [DI]	; c*Ny Nx*(Px-c*Nx) c*Nz Nz max min c
 FISUBR WORD [SDX2]	; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz max min c
 FMUL DWORD [DI]	; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz max min c
 FADDP ST1,ST0		; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz max min c
 FDIVRP ST2,ST0 	; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min c
 FSUBRP ST1,ST0 	; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz max min c
 JA front

 FUCOMI ST0,ST2 	; Iz max min c
 FCMOVNB ST0,ST2	; Iz max min c
 FSTP ST2		; max min c

skip:
 LOOP nextside

 POPA
 POPA
 FUCOMIP ST0,ST1	; min c
 JC .1
 SALC
.1:
;FUCOMPP		; -
 FNINIT 		; -
 ADD AL,255-223 	; ambient
 STOSB
 DEC DX
 JNZ nextpixel
 LOOP nextline
 POPA
 INC DX
 IN AL,60H
 DEC AX
 JNZ nextframe
RETN			; return to DOS prompt

front:
 FUCOMI ST0,ST1 	; Iz max min c
 FCMOVB ST0,ST1 	; Iz max min c
 FSTP ST1		; max min c
 JB skip
 FLD DWORD [DI-4]
 FIMUL WORD [BASE2+MAXCOLOR]
 FISTP WORD [SAX1]
JMP skip
