;party.dll
;hellmood^dsr & sensenstahl^hjb

;the intro has no cls. everything is
;written directly into the vga memory
;a decision that saves quite some bytes
;and fits the concept/structure of the code

org 100h
use16

;assuming:
;ax = bx = cx = 255
;vga memory empty (0) after int 10h

start:   
         mov al,13h     ;320x200x256
         int 10h
         mov dx,text    ; adress of text
	 xchg bp,ax	; BP = 0x091C -> AH = 0x09
         int 21h        ; write text to screen
	 lds bp,[bx]	; bp = 0x20CD, DS = 0x9FFF

grab: ; move the text to the right place on screen
cmp [di],bl	; BL = 0
jz gg ; if pixel zero, grab next one
; color values have to be bigger than 0x38 and 
mov word [di+320*44+68-7+4],0x5c*256+0xb0 ; write shaded string , col 0x5F shade 0xB0
mov [di],bl ; erase old pixel
gg:
dec di ; next pixel
jnz grab ; until done

main:
inc bp          ;global stuff(tm)

mov si,music	; Music Data Address
mov dx,330h		; MIDI Port

mov ax,bp		; get time in AX
test al,63		; within each block of 64 notes/ticks
jnz nodataflip	; ...
xor byte [ss:si+1],dh ; flip the bass line instrument
nodataflip:
test al,3		; half speed 15, double 3, generell 2^x -1
jnz nomusic		; play a drum element each 4th note/tick

				; 0x20CD is the start value of the timer from [0]
cmp ax,0x20cd + 128	 ; before tick/note 128, only hihats
jna tb				 ; after that
xor byte [ss:si+5],8 ; change between bass and hihat
tb:

mov cl,10			; output 10 music data bytes from below
cmp ax,0x20cd + 256 ; unless tick 256 is not yet reached
ja ta
mov cl,7			; then only 7, without the bass line
ta:

rep ss outsb		; redirected via SS, since DS is already used
nomusic:

;ax = identical here after 1st loop
;put some screens and lights where the crowd is

mov di,320*50 ;area of crowd

fillah:
inc ax   ;rnd
mul di   ;enough
push ax  ;kill all artefacts in ax during loop
cmp dl,4;put a light?
ja noh2  ;nah
mov byte[di+320*125],al ;put some lights in the dark

noh2:
cmp ah,cl ;put a screen?
ja noh1  ;nah

mov dx,di ;calc the screen sizes depending on the pos
shr dx,11 ;so larger at the bottom and smaller on top

inc dx    ;never 0 which would break things

imul si,dx,320 ;calc y
screen2:

imul cx,dx,2 ;widescreen
screen1:
mov bx,cx ;get x
add bx,di ;add current pos

add ax,bx ;color works
add ax,bp ;no static colors
shr ax,1  ;but also no complete shiiite
mov byte[bx+si+320*120],al;10
loop screen1

sub si,320
jnz screen2

noh1:
pop ax
dec di
jnz fillah ;do the complete crowd area

;create the bigscreen with a scene
mov dh,106
bigscreen2:
mov dl,36 ;-220 
bigscreen1:


mov si,dx	; save coordinates DL and DH in SI, since they get destroyed

	mov al,93	; that's the vertical line color
    cmp dl,53+4 ; and that's the position
	jz lineskip

	mov cl,239-2 ; depth cut off for raycaster
				 ; kleiner ist schneller, macht aber front artefakte
	L:
	lea dx,[si-84*256-36] ; offset coordinates to the canvas
	imul bx,cx, -1;inverted depth into BX

	mov al,dh 				; get Y position in AL
	sub al,bl				; offset X by depth (curve)
	jc W					; if above curve, skip entirely
	mul bl					; AH = X'
	xchg ax,dx				; DH = X' AL = Y
	mul bl					; AH = Y'
	mov al,dh				; AL = X'
		cmp al,16			; X' left of 16?
		jl FFF
		mov ah,32+1			; then change Y to produce grass/street

	FFF:
	or al,ah				; geometry + texture collapse
	
	cmp bp,0x20cd+128+20	; no movement before tick/note 128+20
	jna nomov
	add bx,bp				; movement by timer
	nomov:
	
	and ax,bx				; masking geometry with depth
	test al,16				; test if ray hit
	loopz L					; if not, depth ++ and repeat
	test al,2				; check if inside window
	jz nope					; if not, skip this
	mov al,0x2c-0x38		; deutschbuerograu! (difference between sky and light)
	test bp,4				; all 4 notes/ticks, lights on/off!
	jz nope
	W:
	add al,0x38-1			; window blink OR sky =)
	nope:
inc ax						; shift all by one to seperate canvas from black hall
lineskip:
mov dx,si					; restore coordinates DL DH from SI
lea si,[di+320*25+49+16]	; translate to canvas position
cmp byte [si],0x38			; something with higher value than everything from canvas?
jns noplot					; then that must be the printed string, so don't write
mov byte[si],al 			; otherwise, happily set the canvas pixel
noplot:
inc di						; next physical pixel
inc dl						; next virtual X coordinate
jnz bigscreen1
add di,320-220			; next physical pixel + line feed
add dh,2					; next virtual Y coordinate ( + effect squeeze)
jnz bigscreen2

hlt		; Musik impliziert DosBox, und da geht HLT :)

         in al,60h            ;read keyboard buffer
         dec al		      ;works
         jnz main             ;no, so go on
music:
breaker: ret                  ;halt!
;db 0xc3	; change channel 0 instrument		= RET
db 78	; bass
db 0xc9	; change drumkit
db 25	; electric

db 0x99	; drum channel
db 44	; hihat 44, xor 8 = 36 = bass
db 127	; volume
db 0x93	; play note on channel 0
db 35	; note value			; 120 15/25, 115 11, 108 21, 71 25, 78 35-45!, 80 sth, 85 sth,
db 127	; volume				; 88 25, 60 24 (original)
text db ' dSr!HjB',254,'$'
