%define MAX_X 320
%define MAX_Y 200

    org 100h
    mov si, Scenes
    jmp main
Scenes:
    ;;;;
    ; order
    ; length
    ; color speed
    ; algo
    
    db 1
    db 120
    db 254

    db 4
    db 5
    db 63

    db 2
    db 40
    db 16

    db 3
    db 11
    db 23

    db 3
    db 11
    db 254

    db 4
    db 9
    db 23

    db 4
    db 9
    db 128    
 
    db 5
    db 5
    db 233

    db 5
    db 5
    db 64
    
    db 6
    db 3
    db 7

    db 6
    db 3
    db 64

    db 7
    db 3
    db 255
 
    db 7
    db 2
    db 32

    db 8
    db 5
    db 127

    db 8
    db 2
    db 32

    db 9
    db 7
    db 133
    
    db 9
    db 2
    db 254

    db 10
    db 5
    db 255
    
    db 10
    db 2
    db 255
   
    db 5
    db 5
    db 15
  
    db 5
    db 5
    db 16
   
    db 6
    db 3
    db 14
    
    db 1
    db 60
    db 56
    
    db 7
    db 4
    db 7

    db 8
    db 4 
    db 3

    db 9
    db 3
    db 11

    db 9
    db 4
    db 7
    
main:
    mov ax,13h 
    int 10h 

    push 0A000h
    pop es

.iter:
    mov di,4860 
;   mov ax,00b
    xor ax,ax 
    mov dx,1
    xor bx,bx
    xor bp,bp
   
;   load order
    lodsb
    mov cl,al
;   load line length
    lodsb
    mov dh,al

;   load color speed change
    lodsb
    mov ah,al
    pusha 
    mov bh,al
    ; start color
    mov ah,128
;   draw curve
    call Hilbert
    popa

;    inc bx
;    push bx
;    cmp bx, 6
;    jnz .iter

.palette:
;   setup palette registers
    mov dx,0x03c8
    mov al,1
    out dx,al
    inc dx
;   init pallette logic. 
    mov cx, 255*3      
.palette_loop:
    xor al,al
    test ah,1
    jz .p2
    cmp bl,cl
    jne .finally
.p2:
    cmp bl,cl
    jb .finally
    dec al
.finally:
    out dx,al
    loop .palette_loop    

;   inc framecounter
    test bh,bh
    jnz main
    inc bx
      
;   vsync
    mov dx, 0x03da
    mov cl, 0x08
.vsync_poll:
    in al,dx
    test al,cl
    jz .vsync_poll

.keyboard_test:
    in al,60h
    dec al
    jnz .palette
   
;   switch back gfx mode
    mov ax,3
    int $10

;   exit program
    retn

; Hilbert curve 
Hilbert: 
    %define .order cl 
    %define .direction al 
    ; 00 right 
    ; 01 up 
    ; 10 left 
    ; 11 down 
    %define .rotation dl
    ; 1 clockwise 
    ;-1 counterclockwise
;    mov byte[es:di],2
.recursion: 
    dec .order 
    js .exit 
    call .corner 
    call .corner 
    call .recursion 
    sub .direction,.rotation 
    call .step 
    neg .rotation 
    call .recursion 
    ; preserve original values 
    sub .direction,.rotation 
    neg .rotation 
.exit: 
    inc .order
    retn 

.corner: 
    neg .rotation 
    sub .direction,.rotation 
    call .recursion 
.step:
    push bx
    ror .direction,2 
    sbb bx,bx           ; dir&&2 ? -1 : 0 
    rol .direction,2 
    sbb bp,bp           ; dir&&1 ? -1 : 0 
    and bp,MAX_X-1      ; dir&&1 ? MAX_X-1 : 0 
    inc bp              ; dir&&1 ? MAX_X : 1 

    xor bp,bx           ; conditional negate 
    sub bp,bx           ; based on dir&&2 
    pop bx

;    mov byte[es:bp+di],ah
    push cx
    mov cl,dh ; line length
.drawline:
    mov byte[es:bp+di],ah
    add di,bp
loop .drawline
;   update color
    add bl,bh
;   assuming cl is 0
    adc ah,cl 
    pop cx
.stepdone:
    retn

