; HyperVibes lite - compo version
; 256b intro coded by TomCat/Abaddon

; Compatibility:
; -Rufus USB boot with FreeDOS
; -WMware Workstation
; -WinXP Command Prompt
; -DOSBox

; youtube: https://youtu.be/qPqaHXIJjJY
; prototype: https://www.shadertoy.com/view/lt2fR1

; greetigs to:
; -ern0 (thanks for the music notes!)
; -Rrrola (great seminars!)
; -Mu6k (so many kind of entries)
; -Digimind (fantastic entries!)
; -Kuemmel (come to Function!)
; -sensenstahl (uncountable 256b intros)
; -HellMood (sizecoding.org needs more articles)
; and all other sizecoders!

ORG 256
 POP    DS              ; DS=0
 MOV    [46CH],AX       ; set BIOS timer counter to zero
 MOV    AL,13H
 INT    10H
 MOV    AL,0B6H         ; usually this is the default timer mode
 OUT    43H,AL          ; but I had some free bytes, so why not?
 PUSH   0A000H

 INC    CX
 MOV    DX,3C9H
.1:
 PUSH   77H
 PUSH   44H
 PUSH   22H
.2:
 MOV    AL,209          ; INT8 speedup to 22.21Hz
 OUT    40H,AL          ; PTC counter = 209*257
 POP    AX
 ADD    AX,CX
 CBW
 XOR    AL,AH
 SHR    AL,1
 OUT    DX,AL
 TEST   SP,SP
 JPE    .2
 LOOP   .1

 POP    ES
 MOV    SI,table
main:
; screen coordinates from video memory offset: DL=0..255, DH=0..199
 MOV    AX,0CCCDH
 MUL    DI
 MOV    AX,[46CH]       ; get BIOS timer counter
 MOV    CL,2
 MOV    BL,AL
 SHR    AX,CL
 PUSH   AX
 INC    DL
 JNZ    nosound

 DEC    DL              ; X coordinate correction: DL=1..255
 JNC    silent
 TEST   AL,1
 JZ     sound
 TEST   AL,128+64+32
 JS     @F
 JPO    silent
@@:
 MOV    AH,70
 TEST   AL,128+2
 JZ     @F
 MOV    AH,120          ; 70 or 120 for bassline notes
@@:
 SALC
 JMP    beep
sound:
 TEST   AL,128+64+32
 JS     @F
 JPE    silent
@@:
 SHR    AL,1
 AND    AX,15           ; AL=index of note
 XCHG   BP,AX
 MOV    AL,15
 MUL    BYTE [BP+SI]    ; [SS:table+index]*15
beep:
 OUT    42H,AL
 MOV    AL,AH
 OUT    42H,AL
 STC
silent:
 SALC
 OUT    61H,AL
 CBW                    ; if speaker off then AH=0
 IN     AL,60H          ; if ESC pressed then AL=1
 DEC    AX
 JZ     exit            ; if AX=1 then EXIT

nosound:
 POP    AX
 MOV    [SI],CX         ; background color index

 TEST   AL,128+64+32
 JS     lines
 JPE    lines
 CBW

plasma:
 MOV    [SI],DL
 FILD   WORD [SI]
 FMUL   ST0,ST0
 MOV    [SI],DH
 NEG    DX
 FILD   WORD [SI]
 FMUL   ST0,ST0
 FADDP
 FSQRT
 FISTP  WORD [SI]
 ADD    [SI],BX
 XCHG   AX,[SI]
 LOOP   plasma
 AND    [SI],AL
 SHL    BYTE [SI],3
back:
 MOVSB
 DEC    SI
 JMP    main

lines:
 JNS    @F
 DEC    CX
@@:

 SUB    DL,128          ; dx = x - 128
 SUB    DH,100          ; dy = y - 100

next:
 ADD    BL,16
 JZ     skip            ; avoid zero division
rotate:
 MOV    AX,BX
 SHL    AX,CL
 SUB    AL,BH
 CBW
 XOR    AL,AH
 SUB    AL,64
 IMUL   DH
 XCHG   DH,DL
 XCHG   AX,BP
 XOR    BH,64
 JNZ    rotate
 ADD    AX,BP
 JNS    @F
 NEG    AX              ; c = abs(a*dx+b*dy)
@@:
 IMUL   BP,BX,16        ; zoom = (255&t)*16
 CMP    AX,BP
 JNB    skip
; c<zoom
 DIV    BL
 SUB    AL,56
 ADD    [SI],AL         ; AL = AL - 56 + c/(255&t)
skip:
 SUB    CH,32
 JNZ    next
 JMP    back

exit:
 OUT    42H,AL          ; restore PTC counter
 OUT    42H,AL
 MOV    AL,3            ; back to text mode
 INT    10H
 INT    20H             ; intro terminated

table:
 DB 181 ;2712
 DB 152 ;2280
 DB 120 ;1800
 DB 152 ;2280
 DB 203 ;3044
 DB 161 ;2416
 DB 120 ;1800
 DB 161 ;2416
 DB 135 ;2030
 DB 161 ;2416
 DB 203 ;3044
 DB 120 ;1800
 DB 135 ;2030
 DB 152 ;2280
 DB 181 ;2712
 DB 203 ;3044
