        ; redneonlines - 128b @ outline 2o23 - wbcbz7 18.o5.2o23
        ; 286/nofpu/vga/midi @ 0x330

        ; my first attempt at MIDI sizecoding tekkkkno sequencing stuff
        ; all coincidences with gaia - poetry of love soundtrack is purely coincidental :)

        ; greetings to all sizecoders all around the world (not for bunker species)
        ; compile with nasm, %define SAFE_EXIT for ESCapeable version

        org     0x100
        use16

start:
        mov     al, 0x13
        int     0x10

%ifdef SAFE_EXIT
        ; save old INT1C
        mov     ax, 0x351C  ; -
        int     0x21    ; -
        push    bx  ; -
        push    es  ; -
        mov     cx, 0xA000
        mov     es, cx
%else 
	mov     bh, 0xA0
        mov     es, bx
%endif
        ; install our timer ISR
        mov     dx, midi_isr
        mov     ax, 0x251C
        int     0x21

.loop:
.pixloop:
        mov     ax, 0xCCCD      ; rrrola stuff
        mul     di              ; dh - y, dl - x
        mov     ax, dx
        add     dx, ax
        and     cx, 16+32+64
        imul    dx, cx
        sar     dx, 6
        sub     ax, dx
        add     ax, bp
        sub     al, -128
        jns     .skip1
        neg     al
.skip1:
        sub     ah, 100
        jns     .skip2
        neg     ah
.skip2:
        add     al, ah
        shr     ax, 4
        and     al, bl
        and     al, 7
        imul    ax, 0x48
        sub     al, (0x48 - 0x28)
        stosb
        inc     di 
        
%ifdef SAFE_EXIT
        jnz     .pixloop

        in      al, 0x60
        dec     al
        jnz     .loop

        ; restore INT1C
        pop     ds
        pop     dx
        mov     ax, 0x251C
        int     0x21
        
        ret
%else
        jmp     .loop
%endif

        ; MIDI ISR stuff
midi_isr:
        inc     bp
        mov     cx, bp
        mov     bl, ch
        pusha
        ; init midi stuff
        mov     al, 0x3F
        mov     dx, 0x331
        out     dx, al
        dec     dx
        and     bl, 3
        and     cx, 7
        jnz     .track
        mov     si, bass
        mov     cl, bass.len
        rep     outsb
.track:
        mov     si, instr_data
.loop:
        lodsw
        bt      ax, cx
        jnc     .skip
        ; play instrument
        mov     al, 0x99
        out     dx, al
        mov     al, ah
        out     dx, al
        xor     al, 127
        out     dx, al
.skip:
        dec     bx
        jnp     .loop
        popa
        ;iret           ; embedded into data

bass:
    db       0xCF, 40, 0x9F
.len    equ     $-bass+2

        ; instrument mask per tick, then note
instr_data:
.hat   db  0b00010001, 80
.drum  db  0b00000001, 35
.tamb  db  0b10010001, 64

