;KALICUBE - 256byte intro by TomCat/Abaddon
; a quarter of a cube raymarched & mirrored

ORG 256

u EQU -8
y EQU -4
x EQU 0
z EQU 4

 MOV AL,13H
 INT 10H
 CWD
main:
 PUSH CS
 MOV BP,SP
 PUSH 0A000H
 PUSH BX
 ADD DX,SP
 POP DI
 POP ES
 MOV CH,320*200/256/2
 REP MOVSW
 POP ES

 MOV SI,temp+4
 FLD DWORD [SI+u]       ; u
 MOV [SI],DX
 FILD WORD [SI]         ; t u
 TEST DH,16
 JNZ @F
 FCHS                   ; changing the direction of rotation
@@:
 FMUL ST0,ST1           ; u*t u
 FSINCOS                ; k s u

 MOV DI,SCR-160
 MOV BL,100
nextline:
 MOV CL,160
 ADD DI,CX
nextpixel:

 CALL pixel
 FSTP ST0               ; k s u

 ADD AL,16;*5
 CMP DL,DH
 JB @F
 ADD AL,63              ; adding some colors
@@:
 STOSB
 LOOP nextpixel
 DEC BX
 JNZ nextline

;this time we don't care FPU stack overflow

;FCOMPP                 ; u
;FSTP ST0               ; -

 BT DX,11               ; CARRY gives the num of mirrors
mirror:
 MOV DI,SI
 MOV SI,SCR+50*320+80
 REP MOVSW

 MOV SI,SCR
 MOV CL,100
.3:
 MOV BX,320
 LEA DI,[SI+BX]
.4:
 DEC DI
 MOVSB
 DEC DI
 DEC BX
 JNZ .4
 LOOP .3
 MOV DI,SI
 MOV CH,320*100/256
.5:
 DEC SI
 MOVSB
 DEC SI
 LOOP .5
 MOV CH,320*100/256/2+1
 CMC
 JNC mirror

 HLT
 IN AL,60H
 DEC AX
 JNZ main

pixel:
 FLD1                   ; l k s u
 FST DWORD [SI+z]       ; l k s u
 MOV [SI],BX
 FILD WORD [SI]         ; y l k s u
 FMUL ST0,ST4           ; dy l k s u
 FSTP DWORD [SI+BP]
 MOV [SI],CX
 FILD WORD [SI]         ; x l k s u
 FMUL ST0,ST4           ; dx l k s u
 FSTP DWORD [SI+x]

;a=d.y*k-d.x*s,d.x=d.y*s+d.x*k;d.y=a;
;a=d.z*k-d.x*s,d.x=d.z*s+d.x*k;d.z=a;
rotate:
 FLD DWORD [SI+x]       ; dx l k s u
 FMUL ST0,ST2           ; k*dx l k s u
 FLD DWORD [SI+BP]      ; dy k*dx l k s u
 FMUL ST0,ST4           ; s*dy k*dx l k s u
 FADDP                  ; s*dy+k*dx l k s u
 FLD DWORD [SI+x]       ; dx s*dy+k*dx l k s u
 FMUL ST0,ST4           ; s*dx s*dy+k*dx l k s u
 FLD DWORD [SI+BP]      ; dy s*dx s*dy+k*dx l k s u
 FMUL ST0,ST4           ; k*dy s*dx s*dy+k*dx l k s u
 FSUBRP                 ; k*dy-s*dx s*dy+k*dx l k s u
 FSTP DWORD [SI+BP]     ; s*dy+k*dx l k s u
 FSTP DWORD [SI+x]      ; l k s u
 NEG BP
 JNS rotate
 MOV AL,16
march:
 FLD DWORD [SI+BP]      ; dy l k s
 FMUL ST0,ST1           ; l*dy l k s
 FADD ST0,ST3           ; l*dy+s l k s
 FABS                   ; y l k s
 FLD DWORD [SI+x]       ; dx y l k s
 FMUL ST0,ST2           ; l*dx y l k s
 FSUB ST0,ST4           ; l*dx-s y l k s
 FSUB ST0,ST4           ; l*dx-2*s y l k s
 FABS                   ; x y l k s
 FLD DWORD [SI+z]       ; dz x y l k s
 FMUL ST0,ST3           ; l*dz x y l k s
 FSUB ST0,ST4           ; l*dz-k x y l k s
 FSUB ST0,ST4           ; l*dz-2*k x y l k s
 FABS                   ; z x y l k s

 FCOMI ST0,ST2          ; z x y l k s
 FCMOVB ST0,ST2         ; b x y l k s
 FXCH                   ; x b y l k s
 FCOMI ST0,ST2
 FCMOVB ST0,ST2         ; a b y l k s
 FSTP ST2               ; b a l k s

 FLDLN2                 ; .69 b a l k s
 FMUL ST0,ST0           ; .48 b a l k s
 FSUB ST1,ST0           ; .48 b-.48 a l k s
 FSUBR ST0,ST2          ; a-.48 b-.48 a l k s
 FMUL ST0,ST0
 FSTP ST2
 FMUL ST0,ST0
 FADDP
 FSQRT
 FLDLG2
 FMUL ST0,ST0
 FSUBP ST1,ST0          ; g l k s u
 FCOMI ST0,ST4          ; g l k s u
 FADDP                  ; l k s u
 JB @F
 FLDL2T
 FMUL ST0,ST0           ; 11 l k s u
 FCOMIP ST0,ST1         ; l k s u
 JB @F
 DEC AX
 JNZ march
@@:
 RETN

 DB 0D7H,0A3H,03BH      ; 1/200
temp:
 DD ?
 DD ?
 DD ?

SCR: