comment +                                         .
                         .            -.AqUa.-
    *      _.====.._           MS-DOS 256 byte iNTR0
         ,:._       ~-_          code:  bitl/7dump
             `\        ~-_      aleks_gs @ yahoo.com
  .            |          `.    .     .-2022-.
        .    ,/             ~-_           .      *
.._....__..-''                 ~~--..__...--...--...-..

  GrEeTiNgS & ReSpEct:   HellMood, sensenstahl, rrrola
  TomCatAbaddon, p01,  pestis,  Asato, iONic, Optimus,
  superogue, Kuemmel, Digimind, wbc\\bz7, Manwe, & YOU

  Features and hacks:             For compilation use:
  - Only integer math ;)          Turbo Assembler 2.02
  - SINus from radial gradient    -  tasm /m2 aqua.asm
  - Timer sync animation          -  tlink /t aqua.obj

comment end! +

.model tiny
.data
    X       DW 0A000h
;   oldtime DW 0

.code
.486
org 0100h

start:
     mov al, 13h     ; set VGA 320x200x8bpp
     int 10h

     add dh, al      ; = CS+1300h (assume dx=cs)
     mov gs, dx      ; segment for frame-buffer

     add dh, al      ; = CS+2600h
     mov fs, dx      ; segment for texture


;**************************************************************************
; MAKE RADIAL-GRADIENT TEXTURE (128x128) [pass through 64kb due code size]
;**************************************************************************
     xor di, di      ;
@l1:                 ;                       _,,ddP"""Ybb,,_
     mov ax, di      ;                     ,dP"'         `"Yb,
     shr ax, 7       ; =Y                ,d"                 "b,
     sub al, 64      ; DY:=Y-R;         d"                     "b
     imul al         ; A:=DY*DY;       d'        ,gPPRg,        `b
     xchg si, ax     ; = A             8        dP'   `Yb        8
                     ;                 8        8)     (8        8
     mov ax, di      ;                 8        Yb     dP        8
     and al, 127     ; =X              Y,        "8ggg8"        ,P
     sub al, 64      ; DX:=X-R;         Ya                     aP
     imul al         ; B:=DX*DX;         "Ya                 aP"
     add ax, si      ; M:=B+A;             "Yb,_         _,dP"
                     ;                       `""YbbgggddP""'
     xor dl, dl      ;
     cmp ax, 4096    ; if M < R*R then begin
     jae @skip       ;
                     ; Z:=(255-M div (R div 16));}
        shr ax, 4    ;
        mov dl, cl   ; assume cx=255
        sub dl, al   ;
                     ;
     @skip:          ;
     mov fs:[di], dl ;
     inc di          ;
jnz @l1              ;

;**************************************************************************
; SET PALETTE (WHITE -> BLUE+GREEN/2 -> BLACK)
;**************************************************************************
@palette:            ;
     mov cl, bh      ; blue                 *
     shr cl, 1       ;             _             .
     cmp cl, 63      ;            (_)    .                   .
     jna @contp1     ;                                *
     mov cl, 63      ;           O      ___/i      .
@contp1:             ;               _/'  ) '\/l          .
                     ;          o  _/ __    )  '\/l      _..
     mov ch, bh      ; green      /  (o_) )   )  '|    /' /'
     shr ch, 2       ;           |          )   )  '\/" =|     .
                     ;           |___/    )   )   )    ==(
     mov dh, bh      ; red       |          )   ) _/-\. =|
     cmp bh, 216     ;            \_      )   ) _/     \__\  .
     ja @contp2      ;           .  \_      )_./
     shr dh, 3       ;                \___|  |      o        .
                     ;            .        \__\   .     .
@contp2:             ;                   .
     inc bh          ;
     dec bl          ; use BIOS function for palette setup
     mov ax, 1010h   ; bl=index, cl=blue, ch=green, dh=red
     int 10h         ;
jnz @palette         ;


;**************************************************************************
; SOME INITS
;**************************************************************************
     lea bx, X
     mov es, [bx]    ; set ES to 0A000h


;**************************************************************************
; GENERATION LIST WITH RANDOM START POSITION AND VELOCITY (PUT TO STACK)
;**************************************************************************
     mov cx, 25               ; count balls
@random:
     mov dx, es               ; set max limit (for start offset)
     xor di, di
  @r2:

     @r_loop:
          in ax, 40h          ; make pseudo-random value
          xadd [bx], ax       ;
          cmp ax, dx
     ja @r_loop               ; repeat until value greater than DX

     mov dx, 6                ; set max limit for velocity value
     sub ax, 3                ; some velocity values be negative
     push ax                  ; put OFFSET/XV/YV to stack
     inc di

  jpo @r2                     ; loop three times
loop @random


;**************************************************************************
; MAIN LOOP
;**************************************************************************

@mainloop:

        push es               ; Calls elapsed render time
        mov es, cx            ; es=0
        mov ax, es:[46Ch]     ; get timer
        mov dx, ax
        sub dx, [bx+2]        ; pasttime:=(time-oldtime);
        mov [bx+2], ax        ; oldtime:=time;
        pop es

        test dx, dx           ; if pasttime = 0 then skip render
        jz @mainloop          ; (it gives smoother animation)

        mov bp, sp

        mov [bx], byte ptr 25 ; count of balls

   @balls:

        mov ax, [bp]          ; = YV (y-velocity)
        mov si, [bp+2]        ; = XV (x-velocity)
        mov di, [bp+4]        ; = M  (current screen-offset)

        imul ax, 320          ; M = M + (YV * 320 + XV) * pasttime
        add ax, si            ;
        imul ax, dx           ; * pasttime (snap animation to time)
        add [bp+4], ax        ;
        add bp, 6             ;

;**************************************************************************
; MAIN DRAW ROUTINE
;**************************************************************************

        push bx
        xor si, si            ; N:=0;
        mov cl, 128

        @draw:                ; for y:=0 to 127 do begin

             ;---------------------------------------------------------
             mov bx, di          ; For sinus-distort we use
             shr bx, 6           ; data from radial-gradient texture
             and bx, 255         ;
             mov al, bl          ;    .
             mov bl, fs:[si+bx]  ;            .      .__,O
             shr bl, 6           ;        .      *     / /`-'
             cmp al, 127         ;                     \^\
             jna @notneg         ;,.-'``'-.,_,  _____ /_ /____  _.-'``'
             not bl              ;            ``~~~~~~~~~~~~~~~`_ =
             @notneg:            ;,.-'``'-.,_,.-'``'-.,_,.='``'-.,_,.-''
             add bl, 4           ;
             ;---------------------------------------------------------

             @drawline:            ; for x:=0 to 127 do begin
                  db 64h                   ;
                  lodsb                    ; C:=mem[map:n]; inc(n);
                  cmp al, gs:[di+bx]       ; if C>mem[buf:m] then
                  jbe @drawskip            ;
                      mov gs:[di+bx], al   ; mem[buf:m]:=byte(C);
                  @drawskip:               ;
                  inc di                   ; inc(m);
                  test si, 127             ;
             jnz @drawline

             add di, 192           ; m:=m+192;

        loop @draw

        pop bx
        dec byte ptr [bx]
   jnz @balls


;**************************************************************************
; MOVE FRAME-BUFFER TO SCREEN (WITH CLEAR DATA IN BUFFER)
;**************************************************************************
     xor di, di
     xor si, si
     @l:
        db 65h
        movsw
        mov gs:[si-2], cx     ; assume cx=0
     test si,si
     jnz @l

     in al, 60h               ; wait for ESC
     dec al
jnz @mainloop                 ; none received, start over


;**************************************************************************
; EXIT
;**************************************************************************
;     mov ax, 3                ; back to text
;     int 10h                  ; mode
     int 20h                  ; exit

end start






















;                            .-""-.
;                           (___/\ \
;         ,   YOU FOUND     (|^ ^ ) )
;        /(   HIDDEN       _)_\=_/  (
;  ,..__/ `\  PART ;) ____(_/_ ` \   )
;   `\    _/        _/---._/(_)_  `\ (
; jgs '--\ `-.__..-'    /.    (_), |  )
;         `._        ___\_____.'_| |__/
;            `~----"`   `-.........'






