;   hypnoscope by xylem
;      256b intro for
;    @party 2018 Party
;
;  code: metajack, unlord, zoner, shiz
;  song: zoner
;
; nasm XLMHYPNO.ASM -o XLMHYPNO.COM

  bits 16
  org 0x100

%define WIDTH (320)
%define HEIGHT (200)

  segment .text
start:
  push 0x8000
  pop fs
  push 0x9000
  pop gs
  push 0xa000
  push 0x7000

  push si

  inc ax

  ; assume cx = 0, di = 0
  xor di, di
  mov cl, HEIGHT
@row:
  mov dx, WIDTH
@col:

  ; assume bx = 0, si = 0x100
  pusha

  fild word [bx-0xc]      ; y
  fidiv word [si]         ; y/104

  fild word [bx-0xe]      ; x
  fidiv word [bx-0x3]     ; x/160

  ; st = x, y
  ; st = x2, x, y
  ; st = y, x, x2
  ; st = y2, y, x, x2

@unitize:
  fld1                    ; 1
  fsubp                   ; x = x/160 - 1
  fld st0                 ; x
  fmul st0, st1           ; x2 = x*x
  fxch st0, st2           ; x2 <-> y
  dec ax
  jns @unitize

  ; st = x, y, y2, x2

  fpatan                  ; a = atan2(y, x)

  ; st = a, x2, y2

  fxch st0, st2           ; a <-> x2
  faddp                   ; x2 + y2
  fsqrt                   ; d = sqrt(x2 + y2)

  ; st = d, a

  fld st1                 ; a
  fcos                    ; c = cos(a)
  fxch st0, st2           ; c <-> a

  ; st = a, d, c

  fsin                    ; s = sin(a)
  fdiv st0, st1           ; u = s/d

  ; st = u, d, c

  fimul word [bx-0x5]     ; u*256
  fistp word [fs:di]      ; ax = floor(u + 0.5)

  ; st = d, c

  fdivp                   ; v = c/d
  fimul word [bx-0x5]     ; v*256
  fistp word [gs:di]      ; ax = floor(v + 0.5)

  popa

  inc di

  dec dx
  jnz @col

  dec cx
  jnz @row

  pop ax

  pop es

  ; any DI is fine, texture is tileable
@texture:
  mov ax, di
  xor al, ah
  stosb
  loop @texture

  push es

  mov dx, my_isr
  mov ax, 0x13

  call init_reset

  mov ax, es

  pop ds                  ; DS = texture segment
  pop es                  ; ES = 0xa000

  push ax
  push bx

@main:
  ; assume cl = 0
  xor di, di
  mov ch, 0xfa            ; 0xfa00 = 64000 = 320*200
@pixel:
  mov bh, byte [fs:di]
  mov bl, byte [gs:di]
  add bx, si

  mov al, byte [ds:bx]
  stosb
  loop @pixel

  mov ah, 1
  int 0x16
  jz @main

  pop dx
  pop ds
  mov ax, 0x3

; set the mode and swap the isr
; ds:dx = vector, ax = mode
init_reset:
  int 0x10
  ; isr into es:bx
  mov ax, 0x3508
  int 0x21
  ; assume ds:dx is set
  mov ah, 0x25
  int 0x21
  mov al, 0x36
  out 0x43, al
  ;mov dx, 11931   ; 100Hz
  mov al, dl       ; DL = offset my_isr
  out 0x40, al
  mov al, 0x2e     ; 0x2eb1 = 99.811Hz, assumes DL = b1
  out 0x40, al
  ret

my_isr:
  inc si
  pushad
  mov dx, 0x388

  mov ax, 0xf063
  out dx, ax
  mov ax, 0x7783
  out dx, ax

  ; crazy song
  mov cx, si
  mov ah, 00111010b
  sub ah, ch
  inc cx
  test cx, 111b
  jnz skip
  sub ah, cl
  add ah, ch
  mov al, 0xa0
  out dx, ax
skip:
  mov al, 0xb0
  out dx, ax

  mov cx, dx
  and si, 0x3f
  jz @white
  and si, 0x3
  jnz @end

  ; orange:   0-127 = 128
  ;  green: 128-181 = 54
  ; purple: 182-221 = 40
  ;   blue: 222-255 = 34
  ; assume cx = 0xff
@colors:
  mov dl, 0xc8
  mov al, cl
  out dx, al
  inc dx
  mul al
  xchg al, ah
  out dx, al
  shr al, 1
  out dx, al
  ;shr al, 1
  out dx, al
  loop @colors
  jmp @end

@white:
  mov dl, 0xc8
  mov al, cl
  out dx, al
  inc dx
  mov al, 0x3f
  out dx, al
  out dx, al
  out dx, al
  loop @white
@end:
  mov al,0x20
  out 0x20, al
  popad
  iret
