;x86 port of ZX-Spectrum music player by TomCat/Abaddon
;theme: Star Wars (short title)

Divider EQU 67          ; INT8 speed
A EQU 17H
M EQU (2DH-A+2)

ORG 256

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 SUB AL,90H-Divider
 CALL init

 PUSH 0A000H
 POP ES

main:
 MOV AH,0
 INT 16H

 SUB AL,AL
 POP DX
 POP DS

init:
 OUT 61H,AL
 OUT 40H,AL
 SALC
 OUT 40H,AL
 MOV AX,2508H
 INT 21H
RETN                    ; return to DOS prompt

IRQ:
 PUSHA
 PUSH DS
 PUSH CS
 POP DS
 MOV DI,zax
 CWD
c1:
 MOV AL,0
 INC AX
f1:
 AAM 255
 MOV [c1+1],AL
 JNZ c2
v1:
 MOV DL,0
c2:
 MOV AL,0
 INC AX
f2:
 AAM 255
 MOV [c2+1],AL
 JNZ c3
v2:
 MOV DL,0
c3:
; MOV AL,0
; INC AX
;f3:
; AAM 255
; MOV [c3+1],AL
; JNZ c4
;v3:
; MOV DL,0
c4:
 MOV AL,0
 INC AX
f4:
 AAM 255
 MOV [c4+1],AL
 JNZ spk
v4:
 MOV DL,0
spk:
 XCHG AX,DX
 CMP AL,1
 JL @F
 OUT 42H,AL
@@:

c5:
 MOV CX,256*7
 LOOP nexttick

 MOV BX,v1+1
 MOV CL,(c5-c1)/(c2-c1)
x4:
 DEC BYTE [BX]
 ADD BL,c2-c1
 LOOP x4

c6:
 MOV AH,1
 DEC AH
 JNZ nofetch

c7:
 MOV SI,zax
 LODSB
 AAM M
 JZ replay
c9:
 MOV BL,0
 SUB BL,c2-c1
 JNC @F
 MOV BL,c4-c1
@@:
 MOV [DI-zax+c9+1],BL
 ADD AL,A-1
; ADD AX,0100H+A-1
 MOV [BX+c1-255],CH
 MOV [BX+f1-255],AL
 MOV [BX+v1-255],AL
 DB 3DH                 ; skip next instruction
replay:
 MOV SI,DI
 ADD AH,AH
 MOV [DI-zax+c7+1],SI
nofetch:
 MOV [DI-zax+c6+1],AH
 MOV CH,7
nexttick:
 MOV [DI-zax+c5+1],CX

 POP DS
 MOV AL,20H
 OUT 20H,AL
 POPA
IRET

INCLUDE "NOTES2.INC"

zax:
DB G_4+1-A+M*6,D_5+1-A+M*6
DB C_5+1-A+M*1,B_4+1-A+M*1,A_4+1-A+M*1,G_5+1-A+M*6,D_5+1-A+M*3
DB C_5+1-A+M*1,B_4+1-A+M*1,A_4+1-A+M*1,G_5+1-A+M*6,D_5+1-A+M*3
DB C_5+1-A+M*1,B_4+1-A+M*1,C_5+1-A+M*1,A_4+1-A+M*6
DB M*10



