;x86 port of ZX-Spectrum music player by TomCat/Abaddon
;theme: Star Wars

Divider EQU 67          ; INT8 speed

ORG 256

 MOV AL,13H             ; set video mode 320x200
 INT 10H                ; call VGA Bios

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,Divider-90H     ; carry flag means turn on the speaker
 CALL init

 PUSH 0A000H
 POP ES

main:
 HLT
;CALL music
 CLC

 IN AL,60H              ; check for keypress
 DAS                    ; if not pressed
 JC main

 SALC
 POP DX
 POP DS

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN                    ; return to DOS prompt


music:
 CWD
c1:
 MOV AL,0
 INC AX
f1:
 AAM 255
 MOV [c1+1],AL
 JNZ c2
v1:
 MOV DL,0
c2:
 MOV AL,0
 INC AX
f2:
 AAM 255
 MOV [c2+1],AL
 JNZ c3
v2:
 MOV DL,0
c3:
 MOV AL,0
 INC AX
f3:
 AAM 255
 MOV [c3+1],AL
 JNZ c4
v3:
 MOV DL,0
c4:
 MOV AL,0
 INC AX
f4:
 AAM 255
 MOV [c4+1],AL
 JNZ spk
v4:
 MOV DL,0
spk:
 XCHG AX,DX
 CMP AL,1
 JL @F
 OUT 42H,AL
@@:

c5:
 MOV CX,1792
 LOOP nexttick

 MOV BX,v1+1
c6:
 MOV AL,1

 MOV CX,4
x4:
 DEC BYTE [BX]
;JNZ @F
;INC BYTE [BX]
@@:
 ADD BL,v2-v1
 LOOP x4

c7:
 MOV SI,zax
 CMP BYTE [SI],255
 JE nofetch

 DEC AL
 MOV [c6+1],AL
 JNZ nofetch

c9:
 MOV BL,0
 SUB BL,c2-c1
 JNC @F
 MOV BL,c4-c1
@@:
 MOV [c9+1],BL

 MOV [BX+c1-255],AL
 LODSB
 MOV [BX+f1-255],AL
 MOV AH,153
 MUL AH
 ADD AX,1571
 MOV [BX+v1-255],AH
 LODSB
 MOV [c6+1],AL
 MOV [c7+1],SI

nofetch:
 MOV CH,1792/256
nexttick:
 MOV [c5+1],CX
RETN


IRQ:
 PUSHA
 PUSH DS
 PUSH CS
 POP DS

 CALL music

 POP DS
 MOV AL,20H
 OUT 20H,AL
 POPA
IRET


INCLUDE "NOTES2.INC"

zax:

DB D_4,02,D_4,02,D_4,02

DB G_4,12,D_5,12
DB C_5,02,B_4,02,A_4,02,G_5,12,D_5,06
DB C_5,02,B_4,02,A_4,02,G_5,12,D_5,06
DB C_5,02,B_4,02,C_5,02,A_4,12,D_4,03,D_4,03

DB G_4,12,D_5,12
DB C_5,02,B_4,02,A_4,02,G_5,12,D_5,06
DB C_5,02,B_4,02,A_4,02,G_5,12,D_5,06
DB C_5,02,B_4,02,C_5,02,A_4,12,D_4,03,D_4,03

DB E_4,09,E_4,03,C_5,03,B_4,03,A_4,03,G_4,03
DB G_4,02,A_4,02,B_4,02,A_4,03,E_4,03,Fs4,06,D_4,03,D_4,03
DB E_4,09,E_4,03,C_5,03,B_4,03,A_4,03,G_4,03
DB D_5,04,A_4,02,A_4,12,D_4,03,D_4,03

DB E_4,09,E_4,03,C_5,03,B_4,03,A_4,03,G_4,03
DB G_4,02,A_4,02,B_4,02,A_4,03,E_4,03,Fs4,06,D_4,03,D_4,03
DB G_5,03,F_5,03,Eb5,03,D_5,03,C_5,03,Bb4,03,A_4,03,G_4,03
DB D_5,18;,D_4,03,D_4,03


DB 255

