; Magic Carpet 256b intro by LBi/Bitbandit - 2022.09.10
; compile: nasm carpet.asm -o carpet.com

	org 0x100

start:
	push 0xa000		; es to VGA screen segment
	pop es
	add si,si
	mov al, 0x13		; 320x200, 256 color

	fldz			; [cnt]

colr:	int 0x10

main:
 	mov ax, 0x1010		; set palette
	imul dx,bx,0x40		; 3b
	mov ch, dh		; 2b
	add dh, 32		; 3b
	add ch, 16		; 3b
	mov cl, [si+blue]	; 3b
	inc bl			; pal index
	jns colr		; 1..127

	fadd dword [si+cinc]	; [cnt+cinc]
	fst dword [si+cnt]	; [cnt]

	fld st0			; [cnt] [cnt]
	fadd st0
	fsincos			; [sin] [cos] [cnt]
	fld st0			; [sin] [sin] [cos] [cnt]
	fimul word [si+i31]	; [sin*31] [sin] [cos] [cnt]
	fiadd word [si+i31]	; [sin*31+31] [sin] [cos] [cnt]
	fistp word [si+blue]	; [sin] [cos] [cnt]
	fstp dword [si+sin]	; [cos] [cnt]

	fstp dword [si+cos]	; [cnt]

	fidiv word [si+i3]	; [cnt/3]
	fsin			; [sin(cnt*0.69)]
	fld dword [si+zoom]	; [zoom] [sin]
	fld dword [si+zinc]	; [zinc] [zoom] [sin]
	fldz			; [0] [zinc] [zoom] [sin]
	fucomip st3		; [zinc] [zoom] [sin]
	jc .2			; skip if sin > 0
	fld1			; [1] [zinc] [zoom] [sin]
	fdivrp			; [1/zinc] [zoom] [sin]
.2:	fmulp			; [zoom*zinc] [sin]
	fst dword [si+zoom]	; [zoom] [sin]
	fimul word [si+i100]	; [size/2=H/2*zoom] [sin]
	fstp dword [si+size2]	; [sin]
	fstp st0		; can be left out, eliminated by fninit

	xor di, di		; screen start

	mov bx, 200		; Y
yloop:
	fld dword [si+size2]	; [size/2]
	mov word [bp+si], bx
	fild word [bp+si]	; [Y] [size/2]
	fld st0			; [Y] [Y] [size/2]
	fmul dword [si+sin]	; [Y*sin] [Y] [size/2]
	fsub st2		; [Y*sin-size2] [Y] [size/2]
	fxch st1		; [Y] [ys=Y*sin-size2] [size/2]
	fmul dword [si+cos]	; [Y*cos] [ys] [size/2]
	faddp st2		; [ys] [yc=Y*cos+size2]
	fstp dword [si+ys]	; [yc]
	fstp dword [si+yc]

i320 equ $+1-beg
	mov cx, 320		; X
xloop:	
	fld dword [si+yc]	; [yc]
	fld dword [si+ys]	; [ys]
	mov word [bp+si], cx
	fild word [bp+si]	; [X] [ys] [yc]
	fild word [si+i320]	; [320] [X] [ys] [yc]
	fmul dword [si+sin]	; [sin*320] [X] [ys] [yc]
	faddp st1		; [X+sin*320] [ys] [yc]
	fld st0			; [X] [X] [ys] [yc]
	fmul dword [si+sin]	; [X*sin] [X] [ys] [yc]
	faddp st3		; [X] [ys] [py=X*sin+yc]
	fmul dword [si+cos]	; [X*cos] [ys] [py]
	fsubrp			; [px=X*cos-ys] [py]
	fld dword [si+size2]	; [size/2] [px] [py]
	fadd st0		; [size] [px] [py]
	xor ax, ax		; default color #0
	fild word [si+i3]	; [3] [size] [px] [py]
.2:	fdiv st1, st0		; [3] [size/3] [px] [py]
	fld st3			; [py] [3] [size] [px] [py]
	fdiv st2		; [py/size] [3] [size] [px] [py]
	frndint			; [iy=round(py/size)] [3] [size] [px] [py]
	fld st3			; [px] [iy] [3] [size] [px] [py]
	fdiv st3		; [px/size] [iy] [3] [size] [px] [py]
	frndint			; [ix=round(px/size)] [iy] [size] [px] [py]
	fldz			; [0] [ix] [iy] [3] [size] [px] [py]
	fucomi st1		; [0] [ix] [iy] [3] [size] [px] [py]
	jnz .1			; skip if ix<>0
	fucomip st2		; [ix] [iy] [3] [size] [px] [py]
	jnz .1a			; skip if iy<>0
	fld st3			; [size] [ix] [iy] [3] [size] [px] [py]
	fdiv st0, st3		; [size/3] [ix] [iy] [3] [size] [px] [py]
	fistp word [bp+si]	; [ix] [iy] [3] [size] [px] [py]
	mov ax, word [bp+si]	; color
	and al, 0x7f
	jmp .3			; break
.1:	fstp st0		; [ix] [iy] [3] [size] [px] [py]
.1a:	fmul st3		; [ix*size] [iy] [3] [size] [px] [py]
	fsubp st4		; [iy] [3] [size] [px-ix*size] [py]
	fmul st2		; [iy*size] [3] [size] [px-ix*size] [py]
	fsubp st4		; [3] [size] [px-ix*size] [py-iy*size]
	fucomi st1		; [3] [size] [px] [py]
	jc .2			; loop while size > 3

.3:	fninit
	stosb

	loop xloop
	dec bx
	jnz yloop

; wait for vertical retrace
;	mov	dx, 0x3da	; 3b
;.4:     in	al, dx		; 1b
;        test	al, 8		; 2b
;        jz .4			; 2b

	fld dword [si+cnt]	; [cnt]

; check for ESC
	in al, 0x60
	dec ax
	jnz main

; restore text mode
i3 equ $+1-beg
	mov ax, 3
	int 0x10
	ret

datalen equ 14
	times 256-($-$$)-datalen db 0
beg equ $+datalen
i31 equ $-beg
	dw 31
zoom equ $-beg
	dd 0x40400000		; 3
zinc equ $-beg
	dd 0x3f81930c		; 1.0123
cinc equ $-beg
i100 equ cinc
	dd 0x3c490064		; 0.0123

sin equ $-beg
cos equ sin+4
size2 equ cos+4
cnt equ size2+4
yc  equ cnt+4
ys  equ yc+4
blue equ ys+4