%define delay 15                 ; number of delays
%define b -11                    ; base values of notes
org 100h                         ; start of code
dw -320-256,-1,320,1             ; offsets for animation
mov al,0x13                      ; 13h = 320x200 8bit
int 0x10                         ; set mode
les dx,[bx]                      ; screen pointer & start
Z:  mov ax,-10                   ; number of iterations
    push dx                      ; save animation value
    X:  sub dx,di                ; offset by screen position
        pusha                    ; save all
            mov al,dh            ; get first coordinate
            sw: and al,63        ; mask coordinate
                sub al,31        ; center coordinate
                imul al          ; circle border
                sub al,16        ; ornaments
                xchg dx,ax       ; swap and store
                dec si           ; triggers once
            jp sw                ; repeat twice
            add ax,dx            ; combine
            rol ax,6             ; select special bit
        popa                     ; restore all
        inc ax                   ; advance iteration
        inc ax                   ; ... twice
    ja X                         ; repeat until hit or done
    pop dx                       ; restore animation value
    add al,23                    ; offset into palette
    stosb                        ; write to screen
loop Z                           ; repeat 2^16 times
    pusha                        ; save everything
        mov cl,delay             ; number of delays
        ZL: sub bx,byte 12       ; shift timer for delay
            test bx,0xf80f       ; start/end/point of music
            jnz S                ; otherwise silence
            mov dx,330h          ; MIDI port (UART)
            mov si,notes         ; MIDI data location
            outsb                ; change instrument
            shrd ax,bx,20        ; get time and scale
            and al,15            ; mask first instruments
            out dx,al            ; set instrument
            and al,7             ; mask as note number
            xchg bp,ax           ; keeping later in bp
            outsb                ; play note
            shrd ax,bx,7+16-1    ; get block for key change
            and al,byte 3*2*2    ; mask and multiplay
            sub al,[bp+si]       ; subtract note
            neg al               ; restore order
            out dx,al            ; play note
            imul ax,cx,byte 9    ; decrease volume
            add al,127 - delay*9 ; add maximum
            out dx,al            ; set volume
        S:  loop ZL              ; repeat til done
    popa                         ; restore everything
    inc bx                       ; advance time
    push bx                      ; save time
        shr bx,8-1               ; get block for anim change
        and bl,6                 ; mask and multiply
        add dx,[bx+si]           ; add specific offset
    pop bx                       ; restore time
QW: cmp bx,0x44C*2+24+8-1        ; stop exactly at this time
jl Z                             ; or repeat
notes: db 0xc3,0x93              ; RET/ MIDI data
db 60+b,67+b,63+b,75+b,72+b,79+b,87+b,84+b