        ;cpu     80386
        bits    16
        org     100h

        ; Enable 80x50
        mov     ax, 0x1112
        int     0x10

        ; Make ES point to B800
        mov     ax, 0xb800
        mov     es, ax

        ; Setup timer
        ; https://en.wikibooks.org/wiki/X86_Assembly/Programmable_Interval_Timer
        xor     bp, bp
        mov     ax, 0x251c
        mov     dx, timer
        int     0x21

        ; config instruments
        mov     si, instruments
        mov     cl, 11
.loop:
        lodsw
        call    setReg
        inc     ax
        call    setReg
        loop    .loop

; ------------------------------------------------------
; DISPLAY
; ------------------------------------------------------

        xor     di,di
startp:

        mov     ax, di
        shr     ax, 1
        mov     cl, 80
        div     cl              ; AH = x, AL = y

        xor     al, ah

        ; % 5
        add     ax, [0x800]
        mov     ah, 0
        xor     dx, dx
        mov     bx, 5
        div     bx
fg:
        mov     ax, 0x0fdb
        cmp     dx, 0
        jz      paint

bg:
        mov     ax, 0x06b3  ; lineas 'gradiente oro'
        ; -- other variations
        ;mov     ax, 0x0309  ; circulos verdes
        ;mov     ax, 0x05b3  ; lineas 'gradiente lila'
        ;mov     ax, 0x0db3  ; lineas 'gradiente rosa'

paint:
        stosw

        cmp     di, 80*50*2
        jb      startp

        xor     di, di

        mov     al, 0x30
    	out     40h, al

        ; Exit on ESC
        in      al,0x60
	    dec     al
	    jnz     startp

setReg:
		mov     dx, 0388h	    ; Adlib port
		out     dx, al		    ; 388 = Address
        xchg    ah, al
		inc     dx			    ; 389 = Data
		out     dx, al
        xchg    ah, al
    	ret

;
;
; TIMER
;
;
timer:
        inc     bp

        test    bp, 0xf
        jnz     skip

        mov     bx, bp
        shr     bx, 4
        and     bx, 0x7

        cmp     bx, 0x03
        jnz     timer2

        inc      byte [0x800]

        ; Play Ch0 + Kick
        mov     si, line0
        mov     cl, 6
.loop:
        lodsw
        call    setReg
        loop    .loop

        ; arpegio off
        mov     ax, 0x00b1
        call    setReg

timer2:
        cmp     bx, 0x07
        jnz     timer3

        ; Half beat at the beginnig
        cmp     bp, 0x0500
        jb      timer3
        cmp     bp, 0x0800
        ja      timer3

        inc      byte [0x800]
        ; Play kick
        mov     si, line0 + 6
        mov     cl, 3
.loop:
        lodsw
        call    setReg
        loop    .loop

timer3:
        cmp     bp, 0x0300
        jb      skip

        add     bx, arpegio

        ; Play Arpegio notes
        mov     al, 0xa1
        mov     ah, byte [ds:bx]
        call    setReg

        mov     ax, 0x31b1
        call    setReg

        ; End song / demo
        cmp     bp, 0x0a00
        jb      skip
        mov     bp, -0x200           ; end

        xor     ax, ax
        inc     byte [bg+2]
skip:
        iret

line0:
        dw      0x00b0          ; ch 0 off
        dw      0x58a0          ; ch 0 on
        dw      0x31b0
        dw      0x00b3          ; kick off
        dw      0x20a3          ; kick on
        dw      0x21b3
arpegio:
        db      0x58            ; C
        db      0xb2            ; E
        db      0x83            ; D
        db      0xcc            ; F
        db      0xcc            ; F
        db      0xff            ; C (queda mejor un A pero se me va de escala)
        db      0xcc            ; F
        db      0xb2            ; E

; line 00
        ; kick off
;        mov     ax, 0xB300
;        call    setReg
;
;        ; kick On
;        mov     ax, 0xA380
;        call    setReg
;        mov     ax, 0xB330
;        call    setReg
;
;        ; Ch 0 off
;        mov     ax, 0xB000
;        call    setReg
;
;        ; Ch 0 On
;        mov     ax, 0xA058
;        call    setReg
;        mov     ax, 0xB031
;        call    setReg
;
;        ; Ch 1 off
;        mov     ax, 0xB100
;        call    setReg
;
;        ; Ch 1 On
;        mov     ax, 0xA1CC
;        call    setReg
;        mov     ax, 0xB131
;        call    setReg
;
instruments:
        dw  0x1040      ; Synth
        dw  0x1260
        dw  0x4380
        dw  0x0123
        dw  0x0943
        dw  0x2163
        dw  0x1183
        dw  0xf66b      ; Kick
        dw  0xf58b
        dw  0xf668
        dw  0xf588


;        ; CH0 - 1
;        ;mov     ax, 0x2000          ; ch0/op1 - set tremolo/vibrato/sustain/ksr/freq mod
;        ;call    setReg
;        mov     ax, 0x4010          ; ch0/op1 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6012          ; ch0/op1 - attack / decay
;        call    setReg
;        mov     ax, 0x8043          ; ch0/op1 - sustain / release
;        call    setReg
;        mov     ax, 0x2301          ; ch0/op2 - set t/v/s/k/f
;        call    setReg
;        mov     ax, 0x4319          ; ch0/op2 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6321          ; ch0/op2 - attack / decay
;        call    setReg
;        mov     ax, 0x8311          ; ch0/op2 - sustain / release
;        call    setReg
;
;        ; CH1 - 4
;        ;mov     ax, 0x2100          ; ch1/op1 - set tremolo/vibrato/sustain/ksr/freq mod
;        ;call    setReg
;        mov     ax, 0x4110          ; ch1/op1 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6112          ; ch1/op1 - attack / decay
;        call    setReg
;        mov     ax, 0x8143          ; ch1/op1 - sustain / release
;        call    setReg
;        mov     ax, 0x2401          ; ch1/op2 - set t/v/s/k/f
;        call    setReg
;        mov     ax, 0x4419          ; ch1/op2 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6421          ; ch1/op2 - attack / decay
;        call    setReg
;        mov     ax, 0x8411          ; ch1/op2 - sustain / release
;        call    setReg
;
;        ; CH2 - 5 (Arpegio)
;        ;mov     ax, 0x2200          ; ch1/op1 - set tremolo/vibrato/sustain/ksr/freq mod
;        ;call    setReg
;        mov     ax, 0x4210          ; ch1/op1 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6212          ; ch1/op1 - attack / decay
;        call    setReg
;        mov     ax, 0x8243          ; ch1/op1 - sustain / release
;        call    setReg
;        mov     ax, 0x2501          ; ch1/op2 - set t/v/s/k/f
;        call    setReg
;        mov     ax, 0x4510          ; ch1/op2 - key scale level / output level
;        call    setReg
;        mov     ax, 0x6521          ; ch1/op2 - attack / decay
;        call    setReg
;        mov     ax, 0x8511          ; ch1/op2 - sustain / release
;        call    setReg
;
;        ; CH3 - kick
;        ;mov     ax, 0x2800          ; ch6/op1 - set tremolo/vibrato/sustain/ksr/freq mod
;        ;call    setReg
;        mov     ax, 0x483F          ; ch6/op1 - key scale level / output level
;        call    setReg
;        ;mov     ax, 0x6800          ; ch6/op1 - attack / decay
;        ;call    setReg
;        ;mov     ax, 0x8800          ; ch6/op1 - sustain / release
;        ;call    setReg
;        ;mov     ax, 0x2B00          ; ch6/op2 - set t/v/s/k/f
;        ;call    setReg
;        ;mov     ax, 0x4B00          ; ch6/op2 - key scale level / output level
;        ;call    setReg
;        mov     ax, 0x6BB6          ; ch6/op2 - attack / decay
;        call    setReg
;        mov     ax, 0x8B66          ; ch6/op2 - sustain / release
;        call    setReg
;
;
;scale:  dw      0x3158, 0x3183, 0x31b2, 0x31cc, 0x3204, 0x3244, 0x328b, 0x32b1, 0x0000
;density:
;    db          0xde
;    db          0xdd
;    db          0xba
;    db          0xdd
;    db          0xba
;    db          0xb3
;    db          0x7c
;    db          0x20
;density2:
;    db          0x07
;    db          0xfa
;    db          0x2e
;    db          0x3a
;    db          0x20
;colors:
;    db          0x01        ; blue
;    db          0x03        ; green
;    db          0x0f        ; white
;    db          0x08        ; dark gray
