;NO SLEEP! - 256b intro to Function 2018
; code - TomCat
; music - ern0

;Inspirations:
; Wheels by Andrew Glassner
; Insomnia by Faithless

RESX EQU 320
RESY EQU 200
M EQU 59

F_4 = (10500000000/88/36999+M/2)/M
E4 = (10500000000/88/32963+M/2)/M
D4 = (10500000000/88/29366+M/2)/M
C_4 = (10500000000/88/27718+M/2)/M
B3 = (10500000000/88/24694+M/2)/M
A3 = (10500000000/88/22000+M/2)/M
B2 = (10500000000/88/12347+M/2)/M
F_2 = (10500000000/88/9650+M/2)/M
F2 = (10500000000/88/9250+M/2)/M

ORG 256
;---------------------------------------------------------------------
 PUSH   0A000H
 POP    ES
 MOV    FS,AX
 MOV    [FS:46CH],AX    ; reset timer counter
 MOV    AL,13H
 INT    10H             ; set video mode
;---------------------------------------------------------------------
 MOV    AL,0B6H         ; not necesary
 OUT    43H,AL          ; just make it more compatible
;---------------------------------------------------------------------
 MOV    BP,320          ; RESX
main:
 MOV    BH,64000/256
 SUB    DI,DI
 MOV    CX,[FS:46CH]
nextpixel:
 DEC    BX
 TEST   CH,2
 JZ     wheels
 TEST   CL,64
 JZ     wheels
;---------------------------------------------------------------------
andpattern:
 MOV    AX,0CCCDH
 MUL    DI
 TEST   CL,CL
 JNS    colors
 XCHG   AX,DX
 SUB    AL,[SI]
 AND    AL,AH           ; PLOT (X-t and Y)
;---------------------------------------------------------------------
plot:
 STOSB
 JNC    @F
 XOR    AL,32           ; swap colors (on wheels only)
@@:
 MOV    [ES:BX],AL      ; mirroring for speedup
 CMP    DI,BX           ; check halfscreen
 JC     nextpixel
;---------------------------------------------------------------------
 MOV    AL,CL           ; get BIOS timer counter
 SHR    AL,1            ; music please...
 CBW
 PUSHF
 AND    AL,31
 XCHG   DI,AX
 MOV    AL,[DI+BP-320+table]
 POPF
 JC     @F
 CMP    AL,1
 JL     skip
 MOV    AL,B3
 CMP    CL,110*2
 JB     @F
 MOV    AL,A3
@@:
 JO     skip
 CMP    AL,F_4
 JNE    skip
 MOV    AL,D4
skip:
 MOV    AH,M
 MUL    AH
beep:
 OUT    42H,AL
 MOV    AL,AH
 OUT    42H,AL
 SALC
 OUT    61H,AL
 MOV    [SI],AH
;---------------------------------------------------------------------
 CBW                    ; if speaker off then AH=0
 IN     AL,60H          ; if ESC pressed then AL=1
 DEC    AX              ; if AX=1 then EXIT
 JNZ    main
 MOV    AL,3
 INT    10H
RETN
;---------------------------------------------------------------------
colors:
 MOV    AL,DH
 IMUL   AL
 XCHG   AX,DX
 IMUL   AL
 ADD    AX,DX
 SHR    AX,11
 ADD    AL,[SI]         ; PLOT (X*X + Y*Y + t)
 ADD    AL,16           ; first color: 16
plot0:
 JMP    plot
;---------------------------------------------------------------------
wheels:
 MOV    AX,DI
 CWD
 DIV    BP
 SUB    AX,RESY/2
 SUB    DX,RESX/2
 MOV    [SI+BP],AX
 FILD   WORD [SI+BP]
 MOV    [SI+BP],DX
 FILD   WORD [SI+BP]
 FLD    ST1
 FMUL   ST0,ST0
 FLD    ST1
 FMUL   ST0,ST0
 FADDP
 FSQRT
 FISTP  WORD [SI+BP]
 FPATAN
 MOV    AL,[SI+BP]
 FIMUL  WORD [SI-256+BP-320+MULP]
 FISTP  WORD [SI+BP]

 SHR    AL,3
 ADD    AL,4
 MOV    AH,16
 TEST   CH,1
 JZ     @F
 OR     AH,CL           ; transition to fullscreen
@@:
 CMP    AL,AH
 JNC    plot0
 MUL    CL
 ADD    AL,[SI+BP]
 SHL    AL,1
 SALC
 AND    AL,32
 SUB    AL,-91          ; two colors: 91, 123
 JMP    plot0
;---------------------------------------------------------------------
MULP DW -41
;---------------------------------------------------------------------
table:
DB 0,B2,E4,0,E4,0,0,F_4,0,B2,F_4,0,F_4,0,0,C_4
DB 0,F2,C_4,0,C_4,0,0,D4,0,F_2,D4,0,C_4,0,D4,0
