; an x86 variation on Minskytron
; by Pavel Bazant pbazant@gmail.com
; got insightful feedback from Rrrola

; I used the following sources of information:
; http://www.masswerk.at/minskytron/
; http://www.masswerk.at/minskytron/minskytron-annotated.txt

cnt equ 100h - 4
d0 equ cnt - 4
d1 equ d0 + 2

org 100h
; https://en.wikipedia.org/wiki/VESA_BIOS_Extensions

mov ax, 4f02h
mov bx, 0103h ; 800x600, 256-color
int 0x10

mov di, a
L:
mov si, b
call iter_add
mov si, c
call iter_sub
mov si, a
call iter_sub


mov cx,300
G:
push cx

add [d0], dword 2654435769
mov ax, [d0]

mov cx, ax

and cx, 511

imul cx, 81
shr cx, 6

shr ax, 14
add cx, ax
add cx, 144-64

mov ax, [d1]

mov dx, ax
and dx, 511
shr ax, 14
add dx, ax
add dx, 44

mov ah,0ch
mov al,0
xor bx, bx
int 10h

pop cx

loop G

add dword [cnt], 4

in al,60h
dec al
jnz L

mov ax, 3
int 10h

ret

iter_add:
mov bx, [di]
add bx, [si]
jmp iter

iter_sub:
mov bx, [di]
sub bx, [si]

iter:

push bx
mov bx, [cnt+2]
shr bx, 3
and bx, 1
;mov cx, [di+obj_params-obj_begin+bx]
mov al, [di+obj_params-obj_begin+bx]
aam 16
xchg ax, cx

pop bx

sar bx, cl

add bx, [di+2]
mov [di+2], bx

sub bx, [si+2]
xchg ch, cl
sar bx, cl
neg bx

add bx, [di]
mov [di], bx

; calculate color

cmp di, b

sbb ax, ax
and ax, 24

mul word [cnt]
xchg ax, dx

add al, [di+obj_base_color-obj_begin]

; todo: consider using 0..65535 instead of -32768..32767

mov cx, bx

sar cx, 3
imul cx, cx, 5
sar cx, 4 + 2
;sar cx, 6

mov dx, [di+2]
sar dx,7

add cx,256+144; 144 = (800-512)/2
add dx,256+44; 44 = (600-512)/2

mov ah,0ch
; al set by the color calculation above
xor bx, bx

pusha

movzx di, byte [di+obj_brush_size-obj_begin]

mov si, di
brushY:
push cx
mov bp,di
brushX:
int 10h
inc cx
dec bp
jnz brushX
pop cx
inc dx
dec si
jnz brushY
popa

; !
mov di, si; ugh

ret

c:
dw 0
dw -1280
db 2 ; brush size
db 32+3*24 ; base color
db 23h ; traditional
db 00h ; fractal

a:
obj_begin:
obj_X0: dw 0
obj_X1: dw -7601
obj_brush_size: db 4 ; brush size
obj_base_color: db 32 ; base color
obj_params: db 87h ; traditional
db 10h ; fractal

b:
dw -3840
dw 0
db 4 ; brush size
db 15 ; base color
db 88h ; traditional
db 0cbh ; fractal
