
{ MIDI-player for "Forever Reality" intro (2023)         }
{ coded by Bitl/7dump    (for Turbo Pascal 7.0)          }
{ and this is what was used to create this cover ;)      }

{ P.S.: This program make file "data.txt" with crunched music-data}

uses dos, crt;

const
channel_num=16;
note_size = 180;
contr_size = 156;
stat_offs = note_size+contr_size; {offset to array of status channels on playback}

{num instrument / volume }
instdata: array[0..channel_num*2-1] of byte = (
  {0}     {1}     {2}     {3}     {4}     {5}    {6}    {7}     {8}     {9}
117,127, 38,127, 38,127, 34,110, 81,96,  81,96, 81,96, 87,127, 87,127, 0,127,

 {A}      {B}     {C}     {D}     {E}     {F}
80,96,   38,70,  80,70,  47,127, 55,127, 81,70);


notesdata: array[0..note_size-1] of byte = (
{beat/length/octave}
 {0}      {1}    {2}    {3}      {4}       {5}      {6}      {7}     {8}    {9}
11,7,9, 7,15,6, 1,3,5, 1,0,2, 7,12,11, 14, 1,11, 15,14,11, 14,1,5, 15,2,5, 3,4,7,

  {A}      {B}        {C}        {D}      {E}        {F}
7,14,12,  15,4,5,   7,15,12,   11,8,3,  15, 1, 7,  7, 15, 11,

{Notes data}
{0} 15,13, 0, 11,10, 0, 6, 5,      {tom tom tom}
{1} 2, 2, 14, 2, 15, 2, 15, 14, 2, 14, 2, 2, 15, 2, 15, 12, {techno lead bass (shifted)}
{2} 3, 3, 15, 3,                   {lead bass (1 part)}
{3} 15,                            {bass drum imitation}

{   A#     A#  F   A#  F#  A#    A#   F  A#  F#   C#               }
{4} 3,  0, 15, 10, 15, 11, 3, 0, 15, 10, 15, 11,  6,
{                                                     .   F   G#+  }
{5}                                                       10, 13,
{                                                     C   G#  .    }
{6} 0,  0,  0,  0,  0, 0,  0, 0,  0,  0,  0,  0,  0,  5,  1,

{7} 13, 10,                        {synth bass addition}
{8} 15, 15, 3,                     {synth bass}
{9} 0, 0, 0, 0, 10,                {drums}

{   D#+ D#+ A  G#     G#+ D+        A  A+ G#+  D+
{A} 2,  9,  3,  2, 0, 14, 8, 0,0,0, 3, 15,14,0,8, {interference part synth}

{B} 13, 10, 15, 15, 3,             {synth bass echo}
{C} 0, 0, 0, 2,  9,  3,  2, 0, 14, 8, 0,0,0, 3, 15,14, {interferen.part echo}
{D} 12, 11, 7, 5, 4, 3, 2, 0, 15,  {noise effect}
{E} 15,15,                         {orcestro hit}
{F} 0, 0, 0, 3,  0, 15, 10, 15, 11, 3, 0, 15, 10, 15, 11,  6
);


control: array[0..contr_size-1] of byte =(
{pos/8, channel,  off/on/downshift}

$7 , $9 , $1, {drums channel ON              0 pattern}
$7 , $8 , $1, {synth bass (1)}
$7 , $B , $1, {synth bass echo}
$7 , $7 , $1, {synth bass (2)}

$5 , $D , $1, {noise effect                  1 pattern }
$8 , $4 , $1, {solo synth (1)}
$8 , $5 , $1, {solo synth (2)}
$8 , $6 , $1, {solo synth (3)}
$8 , $F , $1, {solo synt echo}
$8 , $D , $0, {noise effect stop}

$7 , $E , $1, {orcestro hit                  2 pattern}
$8 , $3 , $1, {bass drum}
$8 , $2 , $1, {simple lead bass}
$F , $7 , $0, {synt bass (2) OFF}
$F , $8 , $0, {synt bass (1) OFF}

$0 , $2 , $5, {lead bass shift down          3 pattern}
$4 , $2 , $8, {lead bass shift down}
$8 , $F , $F, {F0 command:jump one times backward to -128 pos (1 pattern)}
$8 , $2 , $1, {lead bass shift normal}
$8 , $E , $0, {orcestra hit OFF}

$6 , $4 , $0, {solo synth OFF                4 pattern}
$6 , $5 , $0, {solo synth OFF}
$6 , $6 , $0, {solo synth OFF}
$6 , $2 , $0, {lead bass OFF}
$6 , $E , $e, {orcestra hit shift down ON}
$7 , $F , $0, {solo synth echo OFF}
$7 , $1 , $6, {techno bass lead ON (shifted down)}

$5 , $0 , $1, {tom drums ON                  5 pattern}
$7 , $E , $1, {orcestra hit ON (normal shift)}
$8 , $9 , $C, {channel drums to snare ON}
$9 , $E , $0, {orcestra hit OFF}
$9 , $0 , $E, {tom drums shift down ON}

{                                            6 pattern}
$0 , $F , $F, {jump (channel 0 is OFF after end cycle)}
$1 , $D , $1, {noise effect ON}
$7 , $E , $1, {orcestra hit ON}
$8 , $D , $0, {noise effect OFF}
$8 , $C , $6, {interference part solo synth ON}
$8 , $A , $6, {interference part echo ON}
$9 , $E , $0, {orcestra hit OFF}

$7 , $9 , $1, {drums channel to percussion   7 pattern}
$7 , $1 , $0, {techno bass lead OFF}
$7 , $2 , $1, {simple lead bass ON}

$0 , $D , $1, {on noise effect               8 pattern}
$7 , $C , $0, {solo off}
$8 , $A , $0, {solo echo off}
$8 , $3 , $0, {off drum bass}
$8 , $E , $1, {orcestra hit on}
$8 , $2 , $0, {simple bass off}
$8 , $9 , $0, {off drums channel}
$C , $E , $0, {orcestra hit off}
$C , $D , $0, {noise off}
$C , $B , $0
);

type
VirtualMusic = Array[1..1024] of byte;
Virmus = ^VirtualMusic;

var
 Tick, music_position: word;
 mus1, mus2, mus3: virmus;
 Instr, Notes: word;

 ftxt1:text;
 k:byte;
 n, m:word;
 OldAddress:pointer;

PROCEDURE SetUpMusicMem(VAR screenname:virmus;VAR add : word);
BEGIN
  GetMem (Screenname,1024);
  add := seg (Screenname^);
END;


Procedure player;interrupt;
begin
asm
cli
push ds

     inc byte ptr tick

     cmp byte ptr tick, 16
     jbe @exit_player
       mov byte ptr tick, 0

       mov si, note_size
       inc word ptr music_position
       push word ptr music_position
       mov di, stat_offs

       mov es, notes  {; ES to uncrunched data}

       {-- Channel control block --}
       xor cx, cx
       @l_contr:
          pop dx
          push dx
          shr dx, 3

          mov al, es:[si]
          inc si
          cmp al, ch
          jae @skip_add_pattern
          add cl, 10h
          @skip_add_pattern:

          mov ch, al  {save current pos}
          add al, cl  {add num pattern}

          xor bx, bx
          cmp dl, al     {if m=a then}
          jne @next_contr

                mov ax, es:[si]
                cmp ah, 0Fh
                jb @channel_contr

                sub word ptr music_position, 128 {pos:=pos-128}
                mov word ptr es:[si], bx
                jmp @next_contr

                @channel_contr:
                mov bl, al  {channel number}
                shl bl, 3
                cmp byte ptr es:[di+bx], 8Fh
                jbe @next_contr
                mov es:[di+bx+3], ah  {mem[stat:(b and 15)*8+3]:=b; {enable=b}

       @next_contr:
       inc si
       inc si
       cmp si, contr_size+note_size
       jb @l_contr

push es
pop ds
mov si, di
xor di, di
mov bl, 48
  @loop_channel:

       mov dx, ds:[di] {DL=beat, DH=length}
       inc dh      {DH=length+1}
       inc dx
       shl dl, 2   {DL=beat}

     @renew:
       pop ax
       push ax {mov ax, pos {if ((pos and 63 +1) mod beat = 0)}
       and ax, 63
       inc ax
       div dl
       test ah, ah
       jnz @skip_beat {then mem[stat:ch+4]:=1;{pause[ch]:=1;}
       inc byte ptr ds:[si+4]
       @skip_beat:


       mov al, byte ptr ds:[si+5]  {al=possition}

       xor cx, cx
       cmp dh, al {if length=Possition then}
       jne @skip_renew
          mov word ptr ds:[si+4], cx {possition[ch]:=0 pause[ch]:=0;}
          jmp @renew {goto renew}
       @skip_renew:


       db $0f,$c0,$c3  {xadd bl,al {accum+possition];}
       mov cl, ds:[bx]  {CL=note}
       xchg al,bl

       add bl, dh {accum=accum+length}

       inc di
       inc di
       imul ax, word ptr ds:[di], 6  {octave}

       mov dx, ds:[si+3]  {DL=enable, DH=pause}
       test dh, dh
       jz @skip_playchannel {if (pause>0) then begin}
           test dl, dl         {downshift}
           jz @skip_playnote   {if (Enable<>0)}
               add al, cl         {Octave+Note}
               sub al, dl         {-downshift}
               mov ds:[si+1], al  {Note+Octave-downshift;}
               jcxz @skip_playnote  {if (note<>0) then}

                   mov dx, 330h  {then for n:=0 to 2 do port[$330]:=mem[stat:chl+n];}

                   outsb
                   outsb
                   outsb
                   sub si, 3

                   xor al, al    {fix for Windows XP (NTVDM)}
                   out dx, al
                   out dx, al


            @skip_playnote:

               db $0f,$ba,$3c,$04 {btc word ptr ds:[si], 4}
               jc @skip_playchannel
               inc byte ptr ds:[si+5]

        @skip_playchannel:

     add si, 8
     inc di

     cmp di, 15*3   { (channel_num-1)*3 }
     jbe @loop_channel
     pop ax

@exit_player:
     pop ds
     sti
end;
end;



begin
SetUpMusicMem(mus1,Instr);
SetUpMusicMem(mus2,Notes);

{----------------- Make crunched data-file (to 4-bit values) ---------------}
Assign(ftxt1, 'data.txt');
rewrite(ftxt1);

WriteLn(ftxt1, '; ----- Channels setup block (not crunched) ------');
for n:=0 to channel_num*2-1 do begin
Write(ftxt1, instdata[n],', ');
if ((n+1) mod 16)=0 then WriteLn(ftxt1);
end;

WriteLn(ftxt1);
WriteLn(ftxt1, '; ----- Notes block ------');
for n:=0 to note_size div 2-1 do begin
k:=Notesdata[n*2+1];
k:=k shl 4;
k:=k+Notesdata[n*2];
Write(ftxt1, k,', ');
if ((n+1) mod 16)=0 then WriteLn(ftxt1);
end;

WriteLn(ftxt1);
WriteLn(ftxt1, '; ----- Control block ------');
for n:=0 to contr_size div 2-1 do begin
k:=control[n*2+1];
k:=k shl 4;
k:=k+control[n*2];
Write(ftxt1, k,', ');
if ((n+1) mod 16)=0 then WriteLn(ftxt1);
end;
Close(ftxt1);



{---------Load constant data to dynamic memory ----------}
for n:=0 to note_size-1 do begin
mem[Notes:n]:=Notesdata[n];
end;
for n:=0 to contr_size-1 do begin
mem[Notes:n+note_size]:=control[n];
end;

for n:=0 to 16*2-1 do begin
mem[instr:n]:=instdata[n];
end;


{---------------initialization ---------------------}
music_position:=60;

port[$331]:=$3F;         { set UART mode}

m:=note_size+contr_size;
for n:=0 to channel_num-1 do begin
port[$330]:=$0c0 + n;
port[$330]:=mem[instr:n*2];

mem[notes:m+n*8]:=$90+n; {OnOff}
mem[notes:m+n*8+1]:=0;   {Note}
mem[notes:m+n*8+2]:=mem[instr:n*2+1]; {Volume}
mem[notes:m+n*8+3]:=0;   {Enable}
mem[notes:m+n*8+4]:=0;   {Pause}
mem[notes:m+n*8+5]:=0;   {Possition}
end;

{-------------- Quick Timer --------------------}
asm
mov al, 34h
out 43h, al
mov al, 4096 and 0ffh {1193180/freq}
out 40h, al
mov al, 4096 shr 8
out 40h, al
end;

{-----------------start player ------------------}
getintvec($1c, OldAddress);
setintvec($1c, @player);



repeat

ClrScr;
Write(music_position);
delay(100);

until port[$60]=1;


{-------------- Normal Timer --------------------}
asm
mov al, 34h
out 43h, al
xor al, al
out 40h, al
out 40h, al
end;


{------------------stop player ------------------}
setintvec($1c, OldAddress);


for n:=0 to 15 do begin
asm
mov   dx, 330h  {; MIDI Data Port }
mov   al, 0b0h  {; control to 0 channel}
add   al, byte ptr n
out   dx, al
mov   al, 123   {; all note OFF}
out   dx, al
mov   al, 0
out   dx, al
end;
end;

end.