; Skulina (Cranny)
; a 64-byte intro
; by rrrola

; greets to all who
; like tight spaces

  org 100h
;ah=0 sp=-2 bp=0x9?? si=0x100

;320x200 mode, centered segment
  mov al,0x93 ; [si]=t = -27728
  int 0x10
  push 0x9ff6
  pop es

;width 320->65536: dx=y, dl:bh=x
M mov ax,0xcccd
  mul di
  xchg ax,bx

;t++ each frame (di=0 <=> cf=0)
  sbb word[si],-1

;ah = y offset = init color
  mov ax,0x9610 ; al = gray ramp

K equ $-1 ; K=150
  db 0x00,0xe6  ;=add dh,ah

;registers<->x87: use the stack
  pusha;[-9 -8 -7 -6 -5 -4 -3]
   ; ... bh dl dh cl ch al ah
   ;        __y__       col
   ;     __x__       err
  xor bx,bx

;w = |x|
;z = 150 / w
  fild word[bx-9]
  fabs
  fist word[bp+si]
  fidivr word[byte si-0x100+K]

;Texture coordinates
;u = (0.693 - z) * t
  fldln2
  fsub st1
  fimul word[si]
  fistp word[bx]

;v = z * x
;tex = (150 OR u) XOR v
  or ah,[bx]
  fimul word[bx-8]
  fistp word[bx]
  xor ah,[bx]

;Shading, error diffusion
;pushed al:ch += (tex * w) / 4
  mul word[bp+si]
  shr dx,2
  add [bx-5],dx
  popa

;Draw pixel, loop forever
  stosb
  jmp M
