; MAGIXFLY.ASM   - Simple 3d flying demo in 64 Bytes! (C) A.Millett 2014-2025. (+rrrola, see below)
;-----------------------------------------------------------------------------
;  
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;  
; This is a simple DOS/VGA old-school graphics demo program in x86 Assembler, 
; demonstrating some basic asm methods. 
; It can run on an 8086 (or later) PC with VGA under MSDOS/Freedos.
; It does not require an FPU.
; For modern PCs, it will run on Linux/Windows in DOSBOX, or other emulators.
;
; All variables held in registers.
;
; It uses the NETWORK x86 assembler, NASM, but can easily be adapted to others. 
; Build with: NAS2COM magixfly
;   or    NASM -f bin magixfly.asm -o magixfly.com
;
; If you replace the key-hit check & ret with jp reloop, you can save 4 bytes.
;-----------------------------------------------------------------------------
;  History..
; ->DFLYA5  (23.10.2014) (64 bytes)
;  Take old demo, tidy up, add comments etc.
;  Remove shr ax,1   Add mov di,OFFSETY  (reduce flicker)
;  Imp constants OFFSETY, VDUX, VDUY 
; ->MAGIXFLY63 (20.4.2025) (63 bytes)
; 
;  25.4.2025 - A rework of the code from user "rrrola" brings the .COM size down to 52 Bytes.
; ->MAGIXFLY7 (20.4.2025) (52 bytes)
;  Adjust to run on 8086, 2 bytes longer.
; ->MAGIXFLY7 (20.4.2025) (54 bytes)
;  NOEXIT version 
;   You can save 4 bytes more by not allowing user exit by hitting a key.
	; Init some Constants

; Register vars: es:di = pixel address, bx=frame count, bp=ypos, cx=xpos

OFFSETY equ 12		; Start Y pos (for calc)
VDUX    equ 320		; Pixels across

  org 100h

  mov al,19
  int 10h			 	; Screen mode 19 - VGA 320x200x256  (Using default VGA palette)
  ;mov ax,0A000h
  ;mov es,ax		; ES=VGA segment A000
  push 0A000h		; 286+ method (saves 1 byte)
  pop es

reloop:
  mov bp,OFFSETY	; ypos = OFFSETY (Start Y pixel pos)
			; xor bp,bp ; saves 1 byte, but top flickers.
loopY:
  inc bp	; ypos++;
  mov ax,0A00h  ; si = (2560/ypos) + time;  (Calc once for line)
  cwd  		; dx=0 (ax=2560) (clr Divide hi word)
  div bp
  add ax,bx
  xchg ax,si

  mov cx,VDUX		; xpos=320 (X Pixel pos)
loopX:
		;  pVdu [di] = (((((xpos<<4)/ypos) ^ si) + frame/256) & 31);
   imul ax,cx,16    ; 286+ version option (saves 1 byte)
   ; mov ax,16	; Try 8,16,32..
   ; mul cx	
		; or: mov ax,cx:shl ax,1:shl ax,1:shl ax,1:shl ax,1  (longer, but faster on 8086)
   cwd  	; dx=0 (ax<=5120)
   div bp		; /ypos ..
   xor ax,si		; ^si ..
   add al,bh		; +(frame/256) ..
   and al,31		; & 31
   stosb		; (es:di) = al, di++;
  test di,di		
  loopnz loopX		; xpos--; if (xpos) goto loopX;
  jnz loopY		; if (di) goto loopY;
			; di=0 after the loop, no need to clr it.
  inc bx		; frame++;
  jmp reloop
  ; mov ah,1		; Did user hit a key?
  ; int 16h
  ; je reloop		; No, reloop..

  ; ret

section .data		; Initialised data section

;tim:  dw 0		; Time var (init to 0)

section .bss	; Uninitialised data sect..

;tim:  resb 2	; Time var (reserve 2 bytes)

