; MAGIXCGA.ASM - MAGIXFLY, Simple 3d flying demo. (C) A.Millett 2014-2025.
;-----------------------------------------------------------------------------
;  
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;  
; This is a simple DOS/CGA old-school graphics demo program in x86 Assembler, 
; demonstrating some basic asm methods. 
; It can run on an 8086 (or later) PC with VGA under MSDOS/Freedos.
; It does not require an FPU.
;
; All variables held in registers.
;
; Build with:  NASM -f bin magixcga.asm -o magixcga.com
;

CPU 8086

%define FLYBACK 0	; Set for Flyback sync

  org 100h		; Simple COM file

  mov ax,4	 	; Screen mode 4 - CGA 320x200x4
  int 10h

reloop:
  mov ax,0xb800
  mov es,ax		; ES=CGA segment B800
			; bp is time (uninitialised)

  mov bx,bp		; bx=0 or 8192: CGA start,  alternating frames for alt scanlines
  and bx,1
  mov cl,13
  shl bx,cl

%if FLYBACK

  jne fly3

	; Flyback sync.. (on alt frames), remove following up to fly3 for smaller/no flyback
  mov dx,03dah
fly1:
  in  al,dx
  and al,08h
  jne fly1
fly2:
  in  al,dx
  and al,08h
  je  fly2
fly3:

%endif

  mov di,4		; init y-pos

loopY:
  mov ax,2000		; cx = (2000/ypos) + time;
  xor dx,dx
  div di
  add ax,bp
  mov cx,ax

  mov si,159		; X=159 (80 bytes, 2 double-pixels per byte) (16 psuedo-colours)

loopX:
   mov ax,si
   shl ax,1
   shl ax,1
   shl ax,1
   shl ax,1
   xor dx,dx
   div di
   xor ax,cx		; pixel=((X<<4)/Y)^((2000/Y)+time)
   shl al,1
   and al,0xf0
   push ax		; Save hi nibble
   dec si		; X--

   mov ax,si
   shl ax,1
   shl ax,1
   shl ax,1
   shl ax,1
   xor dx,dx
   div di
   xor ax,cx		; pixel=((X<<4)/Y)^((2000/Y)+time)
   shr al,1
   shr al,1
   shr al,1		; move to lo nibble.
   and al,15
   pop dx
   or al,dl		; merge with hi nibble to make 1 byte

   mov [es:bx],al	; *pVdu = 2 pixels merged
   inc bx	
   dec si		; X--
  jge loopX		; if (X) goto loopX

  inc di
  cmp di,103
  jne loopY		; if (Y!=99) goto loopY

  inc bp		; tim++;

			; Get a char in (al), loop till key hit..
  mov ah,1
  int 16h
  je reloop

  ret			; EXIT (was: mov ah,4Ch: int 21h)

section .data		; Initialised data section

;tim:  db 0		; Time var (init to 0)
;section .bss		; Uninitialised data sect..
;tim:  resb 2		; Time var (reserve 2 bytes)
