; DCPLASx.ASM   - CGA Plasma fx.. (C) A.Millett 2014-2025.
;
; Released as free/open software under the terms of the GNU GPL3 license.  
;      See:  www.gnu.org/licenses/gpl-3.0.html 
;
; Plasma graphics effect for 8086/CGA/No FPU.
; Written in NASM (Netwaork Asm), showing some basic asm methods.
;
;  assemble with: NAS2COM name
;           or    NASM -f bin name.asm -o name.com
;

%define FLYBACK 0	; Set for Flyback sync

%define VDUX 160
%define VDUY 200

  org 100h

  mov ax,4	 	; Screen mode 4 - CGA 320x200x4
  int 10h

reloop:

			; Gen precalc X sin pattern table bufx[] 
  inc byte [px1s]
  inc byte [px1s]	; px1s +=2;
  dec byte [px2s]	; px2s ++;

  mov cx,[px1s]		; px1=px1s; px2=px2s;  (cx is px1/px2)

  mov di,VDUX-1		; for (x=VDUX-1; x>=0; x--) {
gentabx:
  mov dl,cl
  call qsine		;   calc al=sin(px1)
  push ax
  mov dl,ch
  call qsine		;   calc al=sin(px2)
  pop bx
  add ax,bx
  mov [bufx+di],al	; bufx[x] = qsine(px1) + qsine(px2);
  inc cl
  inc ch
  inc ch
  inc ch		; px1+= 1; px2 += 2;
  dec di
  jge gentabx		; loop while x>=0

			; Gen precalc Y sin pattern table bufy[] 
  inc byte [py1s]	; py1s ++;
  dec byte [py2s]
  dec byte [py2s]	; py2s -= 2;

  mov cx,[py1s]		; py1=py1s; py2=py2s;  (cx is py1/py2)

  mov di,VDUY-1		; for (y=VDUY-1; y>=0; y--) {
gentaby:
  mov dl,cl
  call qsine
  push ax
  mov dl,ch
  call qsine
  pop bx
  add ax,bx
  mov [bufy+di],al	; bufy[y] = qsine(py1) + qsine(py2);
  inc cl
  inc cl
  inc cl		; py1+= 2;
  dec ch		; py2 --;
  dec di
  jge gentaby		; loop while y>=0


			; Fill CGA mem at 0xB8000 with plasma..
  mov ax,0xb800
  mov es,ax		; ES=VGA segment A000
  mov di,VDUY-2		; Y=VDUY-1  (di)

  mov bx,bp		; bx=0 or 8192: CGA start,  alternating frames for alt scanlines
  and bx,1
  mov cl,13
  shl bx,cl
  jne alty
  inc di
alty:

%if FLYBACK

	; Flyback sync.. (on alt frames), remove following up to fly3 for smaller/no flyback
  mov dx,03dah
fly1:
  in  al,dx
  and al,08h
  jne fly1
fly2:
  in  al,dx
  and al,08h
  je  fly2
fly3:

%endif

loopY:
   mov ch,[bufy+di]	; cx = bufy[y]
   mov cl,4

   mov si,VDUX-1	; X=VDUX-1   (si)
loopX:
   mov al,[bufx+si]
   add al,ch		; Pixel1 = (bufy[y] + bufx[x])
   and al,0f0h
   mov dl,al
   dec si		; X--

   mov al,[bufx+si]
   add al,ch		; Pixel2 = (bufy[y] + bufx[x])
   shr al,cl		; al=al/16  (Put pixel in low nibble)
   or  al,dl
   mov [es:bx],al	; *pVdu = (Pixel1 | Pixel2);
   inc bx		; pVdu++;
   dec si		; X--

  jge loopX		; if (X>=0) goto loopX

  dec di		; Y--;
  dec di		; Y--;
  jge loopY		; if (Y>=0) goto loopY

  inc bp		; tim++;

			; Get a char in (al), loop till key hit..
  mov ah,1
  int 16h
  jne main1
  jmp reloop
main1:			; (was  mov dl,255:mov ah,6:int 21h:cmp al,0:je reloop)


  ;mov	ax,3		; Screen mode 3 - Text 80x25
  ;int 10h

  ret			; EXIT (was: mov ah,4Ch: int 21h)

qsine: 		; Quick sine al=sin(dl)  range 0-255
  mov bx,dx
  and bx,63
  shl dx,1
  and dl,128
  je  qsine2
  xor bl,63
qsine2:
  mov al,[tabsin+bx]
  shr dh,1
  jnc qsine3
  xor al,0ffh
qsine3:
  ret

section .data		; Initialised data section

;tim:  db 0		; Time var (init to 0)

  ; Sine lookup table range -127..127.. 
tabsin:	  db  128,131,134,137,140,143,146,149,152,155,159,162,165,168,171,173
	  db  176,179,182,185,188,190,193,196,198,201,204,206,209,211,213,216
	  db  218,220,222,224,226,228,230,232,234,235,237,239,240,242,243,244
	  db  245,247,248,249,250,251,251,252,253,253,254,254,255,255,255,255


section .bss		; Uninitialised data sect..

bufx: resb VDUX+4		; Precalc x/y lookup table 
bufy: resb VDUY+4

tim:  resb 2		; Time var (reserve 2 bytes)
px1s: resb 1
px2s: resb 1
py1s: resb 1
py2s: resb 1
