; -----------------------------------------------------------------------------
; enigma - by: blossom and superogue/marquee design (superogue1@protonmail.com)
; (c)2020 marquee design
;
; This is our 256 byte MS-DOS intro for Revision 2020, called: Enigma. 
; It is our tribute to the amazing raytraced spheres and fractal effect from 
; the Enigma demo by Phenomena on the Amiga 500.
; Please run in FreeDOS or real MS-DOS! Or DosBox at max cycles if you must. 
;
; Greetings to: 
; tomcat/abaddon, rrrola, hellmood, sensenstahl, digimind, fsqrt, harekiet
; nuey, bruce, sjaak, sag, ile, aaldert, fready and ofcourse azatoth/phenomena
; -----------------------------------------------------------------------------
; nasm -fbin enigma.asm -o enigma.com
org 100h

start:
db 48,00
; init video
push    word 9FBAh
pop     es
mov     al,13h  
int     10h   

; waste some bytes on color first, we're not animals...
mov dx,3C9h
palloop:
mov ax,cx
out dx,al
shr  ax,1
out  dx,al
shr  ax,1
out  dx,al
loop palloop

frameloop:
updateloop:
mov ax,0cccdh 	; 8b-rrrola
mul di
sub dh,104
aam 6           ; woop woop
mov cl,21
sphereloop:
pusha
; Here is some of Blossom's FPU-Queen magic
fninit
fldpi
fadd st0,st0
fild word [byte si+67h]
fld1
fadd st0,st0
fild word [byte bx-14]
fdiv st1
fprem
fdiv st1
fild word [byte bx-6]
faddp
fisub word [si]
fdiv st1

fadd st1
fst st4              ; st4=cx
fdivr st1,st0        ; r
fmul st2,st0         ; cz
fsin
fmul st0,st3         ; cy

fild word [byte bx-9]
fisub word [byte si+1eh]
fdiv st0,st3         ; px/cz
fadd st5,st0
fdiv st0,st4         ; px2
fild word [byte bx-8]
fchs
fdiv st0,st4        ; py/cz
fst st7
fcompp

; superogue says: hold up.. wait a minute! 
; let me fiddle with some branching first!
cmp al,1
jne nobling
fchs             
call fcomp_dosbox
ja nextsphere
jmp calcintersection
nobling:
fldpi
call fcompadd_dosbox
jb nextsphere

; oh go on then, calc some more shit...
calcintersection:
faddp st5,st0
fld st4
call calcdist
fcomp st1
call fcomp_dosbox
jb calcdiffuse
; End of Blossom's FPU-Queen magic
nextsphere:
popa
loop sphereloop

; more rogue bitfiddling
neg dh
js drawfractal
mov al,dh
sub al,118
shr al,1
jmp drawpixel
drawfractal:
push bx
xchg al,dl
cbw              
xor al,ah        
mov bl,48
sub bl,byte [si]
xchg al,dl     
mov al,dh
neg al
shr al,1
mov cl,14
fractalloop:
cmp dl,bl
ja nosub
sub al,5
nosub:
mov ah,dh
shr ah,1
sub dh,dl
add dl,ah
loop fractalloop
pop bx
jmp drawpixel

calcdiffuse:		  ; blossom says hi again!
fdiv st0,st2          	
fsubr st4,st0
fsub st0,st3
call calcdist
fmul st0,st2              ; diffuse * 2pi
fadd st0,st0              ; diffuse * 2
fistp word [byte bx-4]    ; ax=diffuse
popa
cmp al,56		  ; thank you blossom! gimme that...
jb spec
mov al,55
spec:
cmp al,2
jb drawpixel
add al,128
drawpixel:
stosb
inc di
inc di
jnz updateloop
inc bp
cmp byte [si],0
je noscale
dec byte [si]
noscale:
in al,60h
dec al
jnz frameloop 

calcdist:
fmul st0,st0
fld st4
fmul st0,st0
fcompadd_dosbox:
faddp
fcomp_dosbox:
fstsw ax    	; 3b
sahf
ret

; aaaaand we're done! (for now)



