;ras.asm	8-Sep-2023	Boreal	loren.blaney@gmail.com
	page	240, 132	;minimize page headers
;Assemble with: tasm and tlink /t
	.model	tiny
	.code
	.486
	org	100h

;Com files are loaded with registers set like this:
; ax=0, bx=0, cx=00FFh, dx=cs, si=0100h, di=-2, bp=09xx, sp=-2, es=ds=cs=ss
;The direction flag (d) is clear (incrementing).
start:	mov	al, 13h		;call BIOS to set graphic mode 13h
	int	10h		; 320x200 with 256 colors (ah = 0)

;Set color registers with sequential shades of red and green (gives yellow, 
; gold, copper, brown, etc.). Code from SHR's YEW2 demo program.
pal10:	mov	al, cl		;cx is assumed set to 00FFh by loader
	mov	dx, 03C8h	;select color register FFh down thru 01h
	out	dx, al

	inc	dx		;point to corresponding RGB registers
	out	dx, al		;set red intensity
				;set green intensity to 7/8 of red value
	aam	8		;ah:= al/8; al:= rem
	mov	al, cl
	sub	al, ah
	out	dx, al

	xor	ax, ax		;set blue intensity to 0
	out	dx, al
	loop	pal10		;loop for 255 color registers (ff-01)

	fninit			;initialize FPU
	fldz			;Angle:= 0.0 and is kept in st(0)
	push	bx		;(bx=0) set up frame count on stack

; - - - - - - - - - - - - - - - Main Loop - - - - - - - - - - - - - - - - - - - 
;Draw background of moving vertical bars
ras10:	mov	di, offset Buffer
	mov	cx, 320*200
ras15:	pop	ax		;get frame count
	push	ax
	sub	ax, di
	and	al, 017h
	stosb			;es:[di++]:= al
	loop	ras15

;Bar:= 2
	mov	dx, 2		;dx = Bar
ras20:	mov	Bar, dx
;Build number of bars up slowly
	pop	ax		;get frame count
	push	ax
	shr	ax, 7		;div 128
	cmp	al, 9		;limit to 9 bars
	jle	ras25
	 mov	al, 9
ras25:	cmp	dl, al		;if Bar > limit then quit loop
	ja	ras90
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Play MIDI note
	nop
	pop	bx		;get frame count
	push	bx
	mov	al, bl
	aam	15		;rhythm = 3*5 -> 15/60 = 240 bpm; al:= rem
	jne	note90		;play note every 15 frames = 30 degrees =
				; 12 times per 360 degree bar cycle
	imul	cx, dx, 2	;spread:= Bar*2
	
	mov	dx, 331h	;set MPU-401 into UART mode
	mov	al, 3Fh
	out	dx, al

	dec	dx		;= 330h
	mov	al, 0C0h	;set instrument on channel 0 to
	out	dx, al
	mov	al, 11		; glockenspiel
	out	dx, al

	mov	al, 90h		;turn on note on channel 0
	out	dx, al

	mov	al, bl		;frame count
	aam	36		;ah:= al/36; al:= rem
	sub	al, cl
	add	al, 84		;+ baseNote
	out	dx, al		;play this note

	mov	al, 127		;volume
	out	dx, al
note90:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Phase:= float(Bar)*0.4;
;Y:= fix(82.*Sin(Angle+Phase));
	fld	n82
	fild	Bar		;can't use dx here; must be a memory location
	fld	N04
	fmul
	fadd	st, st(2)	;+ Angle
	fsin			;get sine in one instruction!
	fmul
	push	ax
	mov	bx, sp
	fistp	word ptr [bx]
	pop	bp

;DrawBar(Y+100, 2*Bar, 64*((3&Bar)+1)-1);
	add	bp, 100		;Y0 is now relative to vertical center of screen

	mov	dx, Bar
	imul	bx, dx, 2	;radius of bar

	and	dl, 3		;base (center scanline) color of bar
	inc	dx
	shl	dl, 6		;*64
	dec	dx		;dl = BaseColor = 63, 127, 191 or 255

;DrawBar(Y0, R, BaseColor);	\Draw cylindrical bar with its center
;int  Y0, R, BaseColor;		\ at Y0, radius R, and center BaseColor
;
;ax = working register
;bx = R = 'for' loop limit = radius of bar
;cx = line length count
;dl = BaseColor of center scanline of bar
;si = 'for' loop variable
;di = Buffer pointer
;bp = Y0 = Y screen coordinate of center of bar

;for Y:= -R to +R do
	imul	si, bx, -1	;si = 'for' loop control variable
;Color:= BaseColor - 31*abs(Y)/R; \(looks better than a round surface)
draw40:	mov	ax, si
draw45:	neg	ax
	jl	draw45
	imul	ax, -31
	idiv	bl		;al:= ah:al/bl; ah:= remainder
	add	al, dl

;Line(319, Y+Y0, Color);	\draw horizontal line from left to right
	mov	di, si
	add	di, bp
	mov	cx, 320
	imul	di, cx
	add	di, offset Buffer
	rep stosb		;es:[di++]:= al; cx--

	inc	si
	cmp	si, bx
	jle	draw40
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	mov	dx, Bar
	inc	dx
	jmp	ras20		;loop
ras90:
; 	Angle:= Angle + AngStep;
	fld	AngStep
	fadd

;WaitForVSync
	mov	dx, 03DAh
wait20:	in	al, dx		;wait for start of vertical retrace
	test	al, 08h
	je	wait20

;Copy Buffer to video RAM
	mov	ch, 320*200/2/256 ;(cl=0)
	mov	si, offset Buffer
	xor	di, di
	push	0A000h
	pop	es
	rep movsw		;es:[di++]:= ds:[si++]; cx--
	push	ds
	pop	es

	pop	bx
	inc	bx		;increment frame count
	push	bx

	in	al, 60h		;get keystroke
	dec	al		;Esc scan code = 01h
	jne	ras10		;loop if not Esc
	
	mov	ax, 0003h	;restore text display mode
	int	10h		;(unneeded for DOSBox or WinXP)
	pop	bx
	ret

N04	dd	0.4		;single precision 'float' constants
AngStep	dd	0.034906585	;= 2.0 deg * Deg2Rad = 2.0 * 3.141592654 / 180.0
n82	dd	82.0
Bar	dw	?
Buffer	db	320*200 dup(?)	;stack starts above this at top of 64K
	end	start
