;Abstract 1k by Abaddon
;DOS intro in 1024 bytes
;little black art

;code&music1 - TomCat
;music2 - polyrhythm

Divider EQU 67
include "notes.inc"

ORG 256
 DW 127 		; constant 127 -> amplitude for sinus table
 DW 3C00H		; constant 1/128 -> calculating PI/128 for sinus table

 MOV AL,13H
 MOV BL,31
.1:
 INT 10H
 SUB BL,31
 IMUL CX,BX,65
 IMUL DX,CX,2
 MOV CL,CH
 SHL CH,3
 SALC
 OR DH,AL
 MOV CH,DH
 MOV AX,1010H		; set only one color by the VGA BIOS
 ADD BL,32
 JNZ .1

 MOV AH,9
 MOV DX,text
 INT 21H

 MOV BH,63
.2:
 FLDPI			; PI
 FMUL DWORD [SI]	; PI/128
 FIMUL WORD [DI]	; counter*PI/128
 FSIN			; SIN(counter*PI/128)
 FIMUL WORD [SI]	; 127*SIN(counter*PI/128)
 FISTP WORD [BX+SI]	; -
 INC BX
 DEC BYTE [DI]		; loop 256x
 JNZ .2 		; BX = sinus LUT

 MOV DI,0A000H
 MOV DS,DI
 POP SI

 MOV CL,6
.4:
 MOV CH,8
.5:
 MOV AL,8
.6:
 MOVSB
 INC SI
 MOVSB
 INC SI
 MOVSB
 INC SI
 MOVSB
 MOVSB
 DEC AL
 JNZ .6
 ADD SI,320-8*8
 DEC CH
 JNZ .5
 SUB SI,8*320-8*8
 LOOP .4

 MOV CH,4
 REP STOSB
 MOV SI,DI

 MOV CH,4
.9:
 IMUL BP,BP,117
 INC BP
 MOV AX,BP
 MOV AL,AH
 AAM 6
 STOSB
 LOOP .9

 MOV BP,40
.7:
 MOV DI,40*18
.8:
 OR BYTE [DI+BP+0A000H+79],2
 SUB DI,40*2
 JNZ .8
 DEC BP
 JNZ .7

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 PUSH DS
 POP ES
 PUSH CS
 POP DS

 MOV DL,IRQ AND 255
 MOV AL,90H
 OUT 43H,AL
 SUB AL,90H-Divider
 CALL init
COUNTER = $-2

grad:
 PUSH 1000H
 POP DI
;MOV DI,1920+1024+1000
 MOV BP,0A000H-1
.2:
 MOV AL,[BP+DI]
 CMP AL,6
 JB .3
 MOV AL,5
.3:
 CMP AL,4
 JA .4
 SHR AL,1
.4:
 IMUL AX,AX,41
 MOV [BP+DI],AL
 DEC DI
 JNZ .2

 MOV BX,320
 MOV BP,-1920+40*22+37
 CALL fade
 MOV BP,1024
 CALL fade
 MOV BP,-1920
 CALL fade
 MOV CH,240
 REP STOSB

 MOV DX,IRQ2
;MOV AL,90H
;OUT 43H,AL
 ADD AL,75
 CALL init

 MOV BP,BX
 MOV CH,-8
 MOV [BP-320+COUNTER+1],CX
 CWD			; DX = 0
nextpixel2:
 PUSHA

 CALL uvcoord

 XOR DH,DL	     ; clever test for the middle of the screen
 JS  skip	     ; skip pixels on the sides
 SUB AH,CL
 CMP CX,128*15
 JG .1
 CMP CX,127;8
 JG .2
 NEG AH
.1:
 SHR AH,1
 IMUL AH
 SAR AX,6
.2:
 MOV DH,AL

nextsquare:
 PUSHA
 PUSH BX
 MOV AL,BL
 SUB BL,CL
 ADD AL,49
 IMUL BYTE [BX]
 POP BX
 ADD DL,AH
 JO outside
 MOV AL,90
 SUB AL,BL
 CBW
 IMUL SI,AX,102
 ADD BL,32-13
 TEST CH,3
 JNZ .1
 ADD BL,CL
.1:
 MOV CX,4
nextedge:
 CALL calc
 CMP AX,SI
 JG outside
inside:
 LOOP nextedge
 POPA
 JMP setpixel
outside:
 POPA
 SUB BL,13
 JNZ nextsquare

setpixel:
 MOV AL,BL
 AAM 13
 AAD 10
 MOV BL,AL
 CALL calc
 SHR AX,3
 SUB AL,CL

 CALL aalias
 STOSB
skip:
 POPA
 INC DI
nextframe2:
 JNZ nextpixel2

 MOV BX,78+64*256

 IN AL,60H	    ; check for keypress
 DEC AX 		   ; if not pressed
 JZ exit0

 IMUL CX,[BP-320+COUNTER+1],-1
 TEST CX,CX
 JNS nextframe2

 XCHG	AX,CX
 PUSH	08000H
 POP	ES
 MOV	CX,ES
 REP STOSW
 PUSH	ES
 POP	DS

nextframe3:
 IMUL	AX,[BP-320+COUNTER+1],-128
 MOV	BL,AH
 MOV	AL,[CS:BX]
 CBW
 SHL	AX,2
 MOV	[BP-128],AX

 MOV	AL,16
 SUB	AL,[BP-320+COUNTER+2]
exit0:
 JE	exit
 SUB	AL,3
 CMP	AL,2
 JG	.2
 JA	.1
 MOV	AL,0
.1:
 ADD	AL,2
.2:
 MOV	AH,15
 MUL	AH
 MUL	AL
 SHR	AX,1
 XCHG	SI,AX

nextpixel3:
 FILD	WORD [BP-128]
 PUSHA

 CALL uvcoord
 CBW
 MOV	BP,AX
 IMUL	AL
 MOV	DI,DX
 IMUL	DI,DI
 ADD	AX,DI
 RCR	AX,1

RECODE:
 JMP	grid1

 MOV	DI,259
 CMP	AX,SI
 JBE	grid

 MOV	DI,571
;103;129;155;181;207;233;259;285;311;337;363;389;415;441;467;493;519;545;571
;116;142;168;194;220;246;272;298
 MOV	CL,29

 CMP	AX,90*90/2
 JBE	grid

grid2:
 NEG	CX

grid:
 PUSHA
 MOV	BP,SP		; DI SI BP SP BX DX CX AX
 FILD	WORD [BP+4]
 FILD	WORD [BP+10]
 FPATAN
 FIMUL	WORD [BP+0]
 FADDP
 FLDPI
 FMULP

 FILD	WORD [BP+14]
 FSQRT
 FIMUL	WORD [BP+12]
 FADDP
 FISTP	WORD [BP+14+16]
 POPA

 POPA

 CALL aalias
 CMP AL,[DI]
 JC .1
 MOV AL,[DI]
.1:
 STOSB

 TEST DI,DI
 JNZ nextpixel3

 AND [CS:RECODE+1],CH
 PUSH 0A000H
 POP ES

 MOV AH,1
 INT 16H
 JZ nextframe3

exit:
 SUB BP,BP		; CLC
 LDS DX,[BP-4]
 SALC
 PUSH BP

init:
 OUT 61H,AL
 OUT 40H,AL
 SALC
 OUT 40H,AL
 MOV AX,2508H
 INT 21H

WAVE:
 MOV AH,0
 MUL WORD [BP+SI]
 SHR AX,4
 CBW
 XOR AL,AH
CONST:
 CBW
RETN

grid1:
 MOV	DI,311
 CMP	AX,30*30/2
 JBE	grid

 MOV	DI,571
 MOV	CX,-29
 CMP	AX,60*60/2
 JBE	grid

 MOV	DI,467
 JMP	grid2

NOTES:
 DB C_1,G_1,A_1,F_1,C_1,B_1,A_1,F_1
NOTES2:
 DB E_3,B_3,C_4,A_3
NOTES3:
 DB G_3,D_4,E_4,C_4
 DB C_3,G_3,A_3,F_3
 DB C_3,G_3,A_3,F_3

fade:
 MOV CH,[BX-320+COUNTER+2]
nextframe1:
 MOV CL,8+2;3;4;5
 ADD CL,[BX-320+COUNTER+2]
 SUB CL,CH
 INC DX
 PUSHA
 MOV AH,1
 INT 16H
 JNZ exit
n0:
 DEC SI
 IMUL DX,DX,117
 MOV AX,DX
 SAR AX,CL
 JNS n1
 INC AX
n1:
 MOV AL,[SI]
 JNZ n2
 CMP AL,[BP+SI]
 JZ n4
 INC AX
 JC n3
 DEC AX
 DEC AX
 JMP n3
n2:
 CMP AH,CL
 ADC AL,AH
 CMP AL,255
 JNE n3
 SUB AX,AX
n3:
 MOV [SI],AL
n4:
 CMP SI,0A000H+1920
 JNE n0

 PUSH 08000H
 POP DS

nextpixel1:
 SUB DX,DX
 MOV AX,DI
 DIV BX

 MOV BP,255-7
 AND BP,AX
 IMUL BP,BP,5

 MOV AH,DL
 AND AX,7*257
 MUL AH
 CMP AL,7
 JE .2
 SUB AL,3
 CMP AL,45-8
.2:
 SALC
 SHR DX,3
 ADD BP,DX
 AND AL,[SI+BP]
 ADD AL,32
 JNC .1
 SALC
.1:
 MOV [DI],AL
 INC DI
 JNZ nextpixel1
 SUB DI,BX
.5:
 MOVZX AX,BYTE [DI]
 ADD AX,AX
 ADD AL,[DI+1]
 ADC AH,DH
 ADD AL,[DI+BX]
 ADC AH,DH
 SHR AX,2
 MOV [DI],AL
 DEC DI
 JNZ .5

 MOV CH,128
 SUB SI,SI
 REP MOVSW
 PUSH CS
 POP DS

 POPA
 CMP CL,16
 JNZ nextframe1
RETN

aalias:
 CMP AL,16
 JC .2
 TEST AL,AL
 JNS .1
 NOT AL
 SUB AL,112
 JNC .2
.1:
 CMC
 SALC
.2:
 ADD AL,16
 JC .2
;CMP AL,[DI]
RETN

calc:
 PUSH DX
 MOV AL,DH
 IMUL BYTE [BX]
 ADD BL,BH
 XCHG DX,AX
 IMUL BYTE [BX]
 ADD AX,DX
 POP DX
RETN

uvcoord:
 MOV AX,DI	     ; DX:AX = pixel index
 DIV BP 	     ; DX = sX = 0..319, AX = sY = 0..199
 SUB AL,100	     ; centering sX, AL = sY = -112..87
 ADD DX,-159	     ; 159 is the center (but -128 could save a byte)
RETN

IRQ2:
 PUSHA
 MOV SI,COUNTER
 SUB BP,BP

 MOV AX,40000
 SUB DX,DX
 MOV BX,8191
 AND BX,[BP+SI]
 INC BX
 DIV BX
 AND AL,32
 XCHG BX,AX

 MOV AX,64
 MOV CL,3*2
 AND CL,[BP+SI+2]
 SHR CL,1
 SHL AX,CL
 MUL WORD [BP+SI]
 XCHG DX,AX

 MOV AX,[BP+SI+1]
 SHR AX,3
 MOV CL,AL
 SHR AX,1
 MUL CL
 XCHG CX,AX
 MOV EAX,0x1FCCCCF1
 SHR EAX,CL
 AND AL,7
 MUL DH
 MOV CX,[BP+SI]
 SHR CX,4
 OR AL,CL
 AND AL,127
 SHR AL,1
 ADD AL,BL

ENDIRQ:
 JZ .SKIP
 OUT 42H,AL		; out the 6bit sample
.SKIP:
 INC DWORD [BP+SI]
 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET

IRQ:
 PUSHA
 MOV BP,WAVE
 MOV SI,COUNTER-WAVE

 MOV AX,[BP+SI]
 MOV CL,AH
 AND AX,8191
 SHR AX,CL
 AND AL,64
 XCHG BX,AX

 FILD WORD [BP+SI]
;FMUL ST0,ST0
 FSIN
 FIMUL WORD [BP+SI-COUNTER+CONST]
 FISTP WORD [BP+SI-2]
 MOV AH,00010101B
 SHR CL,2
 STC
 ROL AH,CL
 SALC
 AND AL,[BP+SI-2]
 AND AL,31
 ADD BL,AL

.BASS:
 MOV DI,[BP+SI+2]
 AND DI,7
 MOV AL,[BP-WAVE+NOTES+DI]
 AND DI,3
 AND CX,8
 ADD DI,CX
 CBW			; FM freq
 IMUL CX,AX,4		; ratio 1:4
 CALL BP		; tri
 SHR AX,6		; FM amp
 ADD AX,CX		; carrier freq
 CALL BP		; tri
 IMUL DX,[BP+SI],-1	; note env
 MUL DX
 SHR DL,1
 ADD BL,DL

 MOV AL,[BP-WAVE+NOTES2+DI]
 CALL BP
 XCHG CX,AX
 MOV AL,[BP-WAVE+NOTES3+DI]
 CALL BP
 ADD AX,CX
 SHR AX,1
 IMUL DX,[BP+SI],-16	; note env
 MUL DX
 XCHG AX,DX
 ADD AL,BL

 SHR AL,1		; zero means pause (no sound)
JMP ENDIRQ

text:
 DB 13,9,'BlackArt'
 DB 9,9,'ABADDON$'




















