cpu 386
org	0100h

;WIDTH equ 1024
;HEIGHT equ 768
;MODE equ 118h			;1024x768x32bpp

WIDTH equ 640
HEIGHT equ 480
MODE equ 112h			;640x480x32bpp

TABLESIZE equ 8192

;Frame counter on 0xcd20 in the stack
frameCounter equ 0xfffe

;Generate some tables
;Random stuff in es
push 6000h
pop es

push es
pop fs

mov cx,0xffff
fillRandom:
xor ax, di
imul ax, 12377
rol ax, cl
stosb
loop fillRandom

;Setup es back to this segment
push cs
pop es

;Create a double sized sine table for added cosine
mov ch, 2 * TABLESIZE / 256
mov di, sineTable
fillSine:

pusha
;Load CX counter
fild word [bx-6]
fmul dword [sineStep]
fsin
fimul word [sineScale]
;Save result in ax
fistp word [bx-4]
popa
stosw
loop fillSine

skipTables:

;Setup vesa video mode.
mov	ax,4f02h
mov bx, MODE
int	10h

;Now we have a random table, sinetable and a videomode

nextFrame:

;Reset frame writer
xor di, di
;DX holds the active vesa page
mov dx, di

push 0xa000
pop es

mov bp, HEIGHT
nextRow:

mov cx, WIDTH
nextPixel:

or di,di
jnz skippage

;pusha
;Set the next window index
mov ax, 0x4f05
xor bx,bx
int 10h
;popa

inc dx

skippage:

;Setup noise coordinates to sample
;imul ax, bp, 1
;imul bx, cx, 1
mov ax, bp
;Scroll through the noise image slowly
add ax,[frameCounter]
mov bx, cx

;Base value
call getValue

;Use this value for some sines

shl ax, 1
xchg bx, ax
mov ax,[frameCounter]
and ax, TABLESIZE - 1
shl ax, 1
xchg si, ax

;bx and si both point to sine entries now
mov ax,[sineTable+bx]

add ax,[sineTable+TABLESIZE+si]
add ax, bp
push ax
mov ax,[sineTable+TABLESIZE+bx]
add ax,[sineTable+si]

add ax, cx
xchg ax, bx
pop ax

call getValue
;Very inefficient way to get colors, could as well have done it in 256 colors this way
xchg ax, bx
mov ax,0xffc0
call blendByte
stosb
mov ax,0xff30
call blendByte
stosb
mov ax,0xff50
call blendByte
stosw

loop nextPixel

dec bp
jnz nextRow

add word [frameCounter], 3
jmp nextFrame

;Get a blended value from multiple noise value from coordinates in bx:ax
getValue:
push cx

;Amount of layers that get added
mov cx, 4
;Holds the result
xor si,si

nextLayer:
push ax
push bx

;Scale up the coordinates
shl ax, cl
shl bx, cl

call getNoise
;Decrease the addition factor
add si, ax
shr si, 1

pop ax
pop bx

loop nextLayer

xchg ax, si
pop cx
ret


;Get a random value from uv coordinates in bx,ax
;Coordinates are in 8.8 fixed point
;Can only use bx,ax
getNoise:

push cx
push si

;Make si point to the right pixel by taking the upper 8 bits
push ax

movzx si, bh
mov al, 0
or si, ax

;Load 4 surrounding pixels
;Blend factor
mov bh, 0
mov ax,[fs:si]
call blendByte
xchg cx, ax
mov ax,[fs:si+256]
call blendByte
pop bx

;Now containing the new blend factor
mov bh, 0
mov ah, cl
xchg al, ah
call blendByte
;Final value should now be zero extended into ax

pop si
pop cx

ret


;Blend value from al to ah using factor 0-255 in bl
;Result is in ah, lower bits in al
blendByte:
push cx

movzx cx, ah
mov ah, 0
sub cx, ax
imul cx, bx
shr  cx, 8
;ax containing the result
add al, cl

pop cx

ret


;Sine table gets put here
sineStep:
;dd 0.000155425
dd 0.000776085
sineScale:
dw 2048

sineTable: