;q-type
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: marukabis - morning flight

;after "collider", released at lovebyte 2o21, where one needed
;to know the palette order in textmode, this time it is good
;to know where the hell your keys are. not only letters but also
;numbers and a few special keys. ascii 33 (!) .. 122 (z) to be exact.
;but i excluded ^ (94) and ` (96) since they need an additional
;keypress.

;if your timer runs out before you press a key, you get punished
;by losing 1 block of your life bar. if you enter the wrong key
;you also get punished. if you type correctly you gain 1 block
;and 250 points. in that case also the counter gets reset

;if you fill up your lifebar to the max you get
;rewarded with additional 20000 points. your lifebar then gets
;reset to the initial value while the time available for pressing
;a key gets lowered by 1. that is the price

;assuming ax = bx = 0 cx = 255

;A = 65
;Z = 90

;a = 97
;z = 122

;33 .. 122 contain most normal keys ;)

org 100h
use16

start:   push 0b800h ;textmooooooode
frmz:    pop ds
         inc ax ;mov al,01h; 1 = 40*25 16 colors
         int 10h

;clear screen
filler1:
mov byte[ds:bx],ch ;0
inc bx
jnz filler1

;make display area
mov bx,80*6
filler2:
mov word[ds:bx-2+80*9],7dbh
dec bx
dec bx
jnz filler2

;add some design
mov bl,36*2
filler3:
mov word[ds:bx+2+80*13],71cdh
dec bx
dec bx
jnz filler3

;add some more design left and right
;from the shown letter and score
mov ax,71b9h
mov word[ds:2+80*13+18],ax;71b9h
mov word[ds:2+80*13+48],ax;71b9h

mov al,0cch
mov word[ds:2+80*13+22],ax;71cch
mov word[ds:2+80*13+48+20],ax;71cch

mov di,38  ;initial life bar
           ;1 block extra because of time
           ;for modeswitching under freedos
mov si,100 ;initial value for frame counter


;draw initial score on screen into vga and NOT into the buffer
;used a lot in previous prods but it works
mov bl,18
scrz:
mov byte[ds:80*13+50+bx+1],79+16*3;30h ;'0' = 48 = 30h / 16*7+1 = 113 = 71h
;mov word[es:80*24+50+bx],79;30h ;'0' = 48 = 30h / 16*7+1 = 113 = 71h
;dec bx ;save 2b
dec bx
jnz scrz
;dec byte[es:80*24+50+18]

mov cl,1
jmp addor
;start adding points with 1st frame because you deserve them!
next:


mov cx,250 ;add cx points to the score into screen buffer
addor:

xor ax,ax ;indicate that score +1 has to be proceeded

;bx = ? here
mov bx,9*2; score numbers/digits * 2

scorehandler:
;mov dl,byte[cs:score+bx-1]
mov dl,byte[ds:80*13+50+bx] ;only grab ascii from screen buffer
cmp al,bh;0;1                    ;next row is coming so +1, set above
jne fine3
inc dl ;score +1
cmp dl,"9"
jna fine4  ;no reminder
mov dl,"0" ;reminder
jmp fine3  ;update score
fine4:
;mov al,bh   ;0 ;no more change
inc ax;
fine3:

mov byte[ds:80*13+50+bx],dl ;set new ascii to the screen

dec bx           ;next digit
dec bx           ;next digit
jnz scorehandler
loop addor       ;add up all score

mov bp,2 ;init counter so game starts right away with a new letter
add di,4 ;you pressed the right key +1
                    ;other +1 to counter the general -1 when
                    ;timer runs out

cmp di,36*2 ;max life
jna main
mov cx,20000 ;bonus on top of the 250 points
mov di,36    ;back to start because you are too 1337 with your keys :D
dec si       ;lower frame counter to make it harder
jmp addor

main:

dec bp    ;frame counter
jnz fine  ;no run out yet
mov bp,si ;reset counter

dec di    ;punish right away
dec di    ;punish right away
          ;always
          ;no space for laming around
          ;you have to press a key

;create new key consisting of (non)capital letters,
;extra keys (excluding a few), and numbers
again:
in al,40h ;should be random enough
mul si    ;at least it was while testing a bit
adc cx,ax ;

shr cl,1 ;0..128
add cl,33 ;!
cmp cl,122 ;z
ja again

;excluding those which need a 2nd keypress
cmp cl,'^';94
je again ;no way
cmp cl,'`';96
je again ;no way

;cmp cl,'C' ;test to make sure
;je breaker ;every letter is possible
fine:
;draw letter
mov ch,7fh ;add color
mov word[ds:80*13+22],cx

;bx = 0
mov bl,36*2
nrg:
mov ax,79b1h
cmp bx,di   ;energy bar
jbe nochange
mov ax,74b1h
nochange:
mov word[ds:bx+80*10+1*2],ax

mov ax,7efeh
cmp bx,bp   ;timer
jbe nochange2
mov ax,70feh;7dbh
nochange2:
mov word[ds:bx+80*11+2],ax

dec bx
dec bx
jnz nrg

;this could be below at the key check and dec to save
;5b but then you would see 1 remaining life while being dead
;and that is a no no
cmp di,bx;0 ;dead?
je breaker  ;yeah.


mov dx,3dah     ;wait for vsync for constant speed
vsync1:         ;of the frames
in al,dx
test al,8
jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2


         in al,60h            ;read keyboard buffer
         dec al               ;ESC?
         jz breaker           ;leave

         mov ah,01h
         int 16h
         jz main               ;if no key pressed do nothing

         mov ah,00h            ;key pressed so get the code
         int 16h

         cmp al,27             ;esc
         je breaker            ;bye bye

         cmp al,cl ;same letter?
         je next ;add score because you deserve it
         dec di ;punish for the wrong key
         dec di ;punish for the wrong key

jmp main

breaker: ret ;halt!
         nop
         nop
         nop ;256