org 100h
 
%define base 63				; base midi note # . about 311 Hz frequency
%define instrument 11		; that's a vibraphone
%define tonevolume 110		; volume for vibraphone, quite strong, so a bit lower than max
%define tonevolume2 105		; volume for piano, louder than vibraphone, reduced to blend in
%define hihatvolume 127		; at max, because it is hard to hear otherwise
%define clapvolume 127		; at max, because it is hard to hear otherwise
%define hihat 53			; sample number of the hihat (standard MIDI drumkit)
%define clap 39				; sample number of the clap (standard MIDI drumkit)
%define basscutoff 12		; number of the first N slots of 256 slots of the 1/x curve
							; effectively working as a low pass filter
							; basetimer : 1193182 Hz
%define bassbassline 120 	; the frequency of the base bass is 1193182 / (this * 256 + this)
							; = 38,69 Hz, which is almost harmonic to the 311 Hz above (x8)
%define basslineoffset bassbassline*10/9-bassbassline
							; frequency for the alternating bassline scheme, set approx. to	
							; "Major second", see https://en.wikipedia.org/wiki/Interval_(musicdata)
%define perctime 185		; manual value to sync MIDI with PC SPEAKER
							; for the following DOSBOX settings
							; nosound=false, rate=44100, blocksize=4096, prebuffer=20
							; this has to be TUNED BY HAND FOR THE TARGET MACHINE !!!
							; since there is NO WAY to know the MIDI synth delay beforehand!
%define basssound			; for debugging purposes, enabling bassline and kickdrum
%define midisound			; for debugging purposes, enabling piano, vibraphone, hihat, clap
%define aspectcorrect		; doing manual aspect correction to be all over the big screen =)
							; instead of letting DOSBOX perform ugly letterboxing :D
%define timercount bp		; leftover when juggling around registers to see which	
							; timing variable uses the least space
%define stackbaseoffset +2	; +2 if we POP a word before (BP),0 is normal (used for stack addressing)
pop bp						; top stack contains 0x0000, reset timecounter that way
push 0xa000 - 70			; prepare segment for screen access
pop es						; aligned to use as few bytes as possible for the #Rrola_Trick
mov al,0x13					; AH = 0, setting up screen mode to 320x200 pixels in 256 colors
out 0x61,al					; using the last three bits of 0x13 to connect the 2nd timer to speaker
L:
	inc cx 					; palette generation, produces 4 gradients
	sub ch,4				; black to light green, blue to light blue
	sub dh,2				; brown to yellow, purple to white
	int 0x10				; reusing this (1st: switch mode, 2nd: set palette entry)
	mov ax,0x1010			; service routine for passing CL,CH,DH as color
	inc bx					; saves one byte, slow on real dos/xp (passes 64K colors)
	jnz L					; that's just 13 bytes for color! ( reusing int 10h does not count )

mov dx,music_int			; installing a callback routine for sound generation
mov ax,0x251C				; address is [ds:si]
int 0x21					; the timing itself is set inside that routine

X:
draw:
mov ax,0xCCCD				; the famous Rrola_Trick : transformed screen coordinates
mul di						; from screen pointer DI land in DH(+DL) and DL(+AH)

mov si,musicdata			; initialize SI for the later OUTSB calls, and for saving
							; bytes on addressing ([SI+byte])
sub dh,100					; align the screen coordinate to the middle of the screen
pusha						; push coordinates on the stack for addressing via FPU

fild 	word	[bx-9+stackbaseoffset]			; fpustack :  x
fild 	word	[bx-8+stackbaseoffset]			; fpustack :  y  x
%ifdef aspectcorrect
fdiv dword [byte si-3]							; aspect ratio correction (divide by ~ 1.29)
												; the Rrola_Trick changes pixel ratio to 256 : 200
												; divide by this to make circles to look like actual circles
%endif
fpatan											; fpustack :  arc
fst 	st1										; fpustack :  arc  arc
fcos											; fpustack :  cos(arc)  arc
fimul	dword	[si+modnote+1-musicdata-3]		; fpustack :  l*cos(arc)  arc
fidiv	word	[bx-8+stackbaseoffset]			; fpustack :  l*cos(arc)/x  arc
moveop:
			add al,0x07							; 0x0007 dummy operation (self modifying code)
;later :	fiadd	word	[bx]				; 0xDF07 fpustack :  l*cos(arc)/x  arc
rangeop:
fistp	dword	[bx-7+stackbaseoffset]			; fpustack :  arc	;0xDB	; save to CL
;later :	fistp	word	[bx-7]				; fpustack :  arc	;0xDF	; gets selfmodified into *this*
%ifdef aspectcorrect							; the aspect ratio constant changes location of *this*
fimul	word	[byte si-3]						; fpustack :  scaled_arc
%elif
fimul	word	[byte si-2]						; fpustack :  scaled_arc
%endif
spinop:
			add al,0x27							; 0x0027 dummy operation (self modifying code)
;later :	fisub	word	[bx]				; 0xDE27 fpustack : scaled_arc + offset (spin)
fistp	dword	[bx-5+stackbaseoffset]			; fpustack :  -				; save to AL
popa											; get our results (AL and CL are interesting to us)

texfx:
add al,cl					; first spiral FX, later gets modified to XOR texture
test al,16					; flip half bands, because initial 4 gradients
jz noflip					; have "hard cuts" between them, this produces
not al						; 4 alternate gradients, having "lights" in the middle
noflip:
subwoofinfluence:
add al,16					; subwoofer influence, initially mapping to green/blue
							; the value gets modified later (synced fake red light FX)
stosb						; write the actual pixel to the screen (finally :D )
imul di,byte 121			; pseudrandomize screen position, also for dithering
jc draw						; also for not *always* checking for ESC, because performance!
in al,0x60					; read key value
dec ax						; ESC would be 1, AH is 00 from time to time, saves one byte
jz lefin					; if ESC was pressed, quit intro, otherwise check final time
cmp timercount,-113*256		; check if intro should be ended anyway
jnz draw					; if not, continue with drawing
xchg bp,ax 					; get zero in AL (low part of BP is 0x00)
lefin:				
out 0x61,al					; in any case AL is now ZERO, so this shuts down PC SPEAKER
int 0x20					; [bx] = [0] corrupted at this point, also, stack is not aligned
							; so ending with RET is not an option, instead quit "normally"
val:	dw 7823 			; = 6 * 32 * 256 / pi / 2 ... aligning the arc to produce 6 spiral arms
%ifdef aspectcorrect
db 0xa6						; aspect correction value is 0x3FA6, shares a byte with MIDI data
%endif

musicdata: 					; DATA section, this is output to the MIDI port with OUTSB 
db 0x3f						; set MIDI controller to UART mode
db 0xc0						; set instrument (0xC.) on channel 0 (0x.0) ...
db instrument				; ... set it to defined instrument as declared above
db 0x90,tonevolume			; send note on channel 0 (note value implicit) send volume (vibraphone)
db 0x91,tonevolume2			; send note on channel 1 (note value implicit) send volume (piano)
db 0x90,tonevolume			; send note on channel 0 (note value implicit) send volume (vibraphone)
db 0x99,hihat,hihatvolume	; send note on drum channel, send hihat code, send volume
musicdata2:					; separate label, since conditional branching makes SI addressing impossible
db 0x99,clap,clapvolume		; send note on drum channel, send clap code, send volume

music_int:					; timer interrupt service routine, called to play MIDI and PC SPEAKER sound
mov al,7					; two pass setting the timer interrupt to 1193182 / (7 * 256 + 7) ~ 663 Hz
out 0x40,al					; which is (almost xD) enough to create procedural sounds with PC speaker
							; ALSO, it let's increment the high byte of the timer 2,59 times a second
							; which creates a 155 BPM beat when the low byte is passed to the PC SPEAKER
inc timercount				; increment the custom timer variable (BP)
mov ax,timercount			; and pass it to AX since CMP AL is very short, and several processing
							; steps profit from having the actual value in AL or AH

shld [bx],ax,16+3			; store animation parameter in [BX] = [0] for later FPU access

; .... at this point, i got better things to do than comment my code :D
; an continued, cleaned, commented version will be available at pouet after the party

%ifdef midisound
mov dx,0x331
outsb
dec dx
%endif

cmp al,perctime
jnz noinstrumentnow

push ax
	outsb						; SWITCH
		cmp ah,127 - 16
		jng F2
		mov byte [byte si-musicdata+rangeop-2],0xDF
		dec byte [bx+si]		; outro instrument modification
		F2:
	outsb						; INSTRUMENT		
	zoom3:
	shr ax,9
	imul ax,byte 3
	
	modnote: ; ALSO 0x0C zoomconst address !!!!
	aam 12	
	
	outsb
	basenote:
	add al,base
	out dx,al
	outsb
	
	outsb
	pianonote:
	add al,3
	out dx,al
	outsb
	
	outsb
	vibratwo:
	add al,4
	out dx,al
	outsb
	
pop ax

cmp ah,15
jng skiphihat
	; mov byte [spinop],0xDE
	mov byte [byte si-musicdata+spinop-1-8],0xDE 
	; carefully count the "outsb"s since (8)
	outsb
	outsb
	outsb
skiphihat:

noinstrumentnow:
; mov si,musicdata2	; moved from the skipclap branch


cmp ah,31	
;jng draw				; cant jump to draw in an interupt!
jng interend

mov cx,bassbassline + 16 * 256
; mov byte [byte si-musicdata-1-8-3+subwoofinfluence+1],ch
test ah,1
jz skipclap_ah
mov cx,(bassbassline + basslineoffset) + 0 * 256
;xor byte [subwoofinfluence+1],16




cmp ah,47		;normally 47 but switch to xor earlier
jng skipclap

; -128 or +128 depending on perctime to supress byte warning!
cmp al,perctime-128 ;clap is perfectly offset to hihat (perctime)
jnz skipclap
	; mov byte [texfx],0x30
	mov byte [byte si-musicdata+texfx-1],0x30
	; mov byte [byte si-musicdata2+texfx-1],0x30
	; no other "outsb"s from the other branch, so -1!
	
	; add byte [texfx],0x08
	; and byte [texfx],0x3f
	mov si,musicdata2
	outsb
	outsb
	outsb
	; xor byte [subwoofinfluence+1],16
	
skipclap_ah:	
skipclap:
mov byte [subwoofinfluence+1],ch ; 4
; mov byte [si],ch	; 2
; mov byte [byte si-musicdata2+subwoofinfluence+1],ch

		cmp ah,63
		jng skipbasscut

		cmp al,basscutoff
		jg F
			mov byte [moveop],0xDE ; 5
			; mov byte [si+4],0xDE ; 4
			skipbasscut:
			xchg cx,ax
		F:
		%ifdef basssound
		out 0x42,al
		%endif
	
skipallmusicdata:

interend:
iret
theend:


