; "Enchanted" - 256 bytes intro for MSDOS
; shown at Revision Demoparty 2025

; original voxel engine from Rudi/Darklite ("Pluto", 2012)
; optimization, design, music by HellMood/DSR
; DosBox X recommended, use provided config file
; needs MIDI set to UART and about 193k cycles

%define skyheight 66	; literally the skyheight
%define le_tempo 99*2	; animation and music tempo
%define scapetime 15	; init time for the landscape
%define delay 13		; delay (0-15)
%define midi_inst 82	; flute
%define os 31			; note offset
org 100h	
xchg cx,ax				; get "65536" in CX for star loop
mov al, 13h				; 320 x 200
ptop:
int 10h	   				; set mode ; set color
		movsx cx,bl		; Rrrolas Palette with Tomcats Bug ^^
		xor cl,ch		; alternative code variation
		mov ah,cl
		mov ch,cl
		mul cx
		shr cx,1     
		inc bl       
		jns pmid     
		xchg cl,dh
		pmid:
		mov ax,0x1010
		jnz ptop
		
		les ax,[bx]		; get screen address
		stars:
		sub al,cl		; pseudo
		adc [si],ch		; random
		jz S1
		salc			; black
		S1:
		stosb			; star
		loop stars		; more stars!
			
	mov ax,0x8027		; segment start and landscape seed
	mov es, ax			; offscreen segments
	mov gs, ax
    xor bp,bp			; time = 0
 
		L:	
		add al, ch 		; pseudo random init
		stosb			; for the voxel landscape
		loop L
	DRAW2:	
		mov bl,scapetime
		B:	
		es lodsw		; 4 neighbourhood smoothing
		dec si
		add ax, [es:si-257]		
		add al, ah
		shr al, 2
		inc ax				
		stosb					
		loop B			; often
		dec bx
		jnz B			; VERY often
mov fs,ax
DRAW:	
	mov si, 320
XLOOP:	
	xor di, di
	mov bl, 200-skyheight-1
TLOOP:	
		push si
			 push di
			 shr di,1
			 sub si, di ; curve
			 pop di
			imul si, di
			xchg si,ax
			lea dx,[bp+di]	; offset by time
			mov dh,ah		; combine hi and lo byte for lookup
			mov si,dx			
			DDD:
			gs lodsw		; height from map
		pop si
		imul dx,ax,byte 6	; color compression

		inc di
		push dx				; remember color
		cwd
		div di	; divide heigth by distance -> persp

		shld dx,di,14
		add al,dl ; curve height by distance (horizon)
		
		sub al,65 ; adjust general height
		pop dx		; restore color
		inc bx
KK:
		dec bx		; draw line ...
		push bx
			imul bx,320
			mov [fs:bx+si-1], dh
		pop bx
		cmp ax,bx		
		jb KK		; ...
Y_LD:
		cmp di, 340
		jnz TLOOP
		dec si
	 jnz XLOOP			
	 hlt			; sync against timer ( ~ 25 FPS ) 
	 push 0a000h+20*skyheight
	 pop es
CP:	
	mov ax,di
	mov al,ah
	xchg al, [fs:di]		; write sky, get voxel
	imul dx,di,byte 117		; pseudo random
	xor dl,dh
	mov dh,0				; only last 8 bits
	add dx,bp				; offset by time
	shr dh,1				; fade yes/no
	 jnz tzu
	 clear:
	 inc di
	 jmp short noplot
	tzu:
	
	stosb					; write pixel
	noplot:					; dont xD
	imul di,byte 85			; pseudo randomize
	loop CP
	mov al,le_tempo			; set tempo
	out 40h,al

inc bp
pusha

mov dx,330h			; midi port
mov cl,8			; 8 note trials per tick
M:sub bp,byte 12
	js nomuse		; luxury, cold start <3
	test bp,31
	jnz nomuse
	shld bx,bp,11	; time to note
	mov si,preface ; output midi data from below
	outsb			; set instrument command
	outsb			; instrument number
	outsb			; change channel parameter
	outsb			; panning
    imul ax,cx,byte 16
	out dx,al		; send panning value
	outsb			; send play note command
	and bx,byte 7	; reduce to 8
	mov al,[bx+si]	; read note
	out dx,al		; send note value
	imul ax,cx,byte delay ; calculate ...
	add al,127-delay*8		; ... volume
	out dx,al		; send volume value

nomuse:
loop M
nodr:
popa		
GG:
in al,0x60		; wait for ESC
dec al
jnz DRAW
QQQ:
preface: 
db 0xc3,midi_inst	; 0xC3 = change instrument = RET
db 0xb3,0xa,0x93	; stereo panning setup
notes: 
db os+27+12,os+23+12,os+30,os+16-12,os+23+12,os+20+12
db os+25+2
db os+20-12
